/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.galleon.plugin.config;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.runtime.PackageRuntime;
import org.wildfly.galleon.plugin.WfInstallPlugin;
import org.wildfly.galleon.plugin.WildFlyPackageTask;
import org.wildfly.galleon.plugin.config.FileFilter;

public class LineEndingsTask
implements WildFlyPackageTask {
    private final List<FileFilter> unixLineEndFilters;
    private final List<FileFilter> windowsLineEndFilters;
    private WildFlyPackageTask.Phase phase;

    public LineEndingsTask(List<FileFilter> unixLineEndFilters, List<FileFilter> windowsLineEndFilters, WildFlyPackageTask.Phase phase) {
        this.unixLineEndFilters = unixLineEndFilters;
        this.windowsLineEndFilters = windowsLineEndFilters;
        this.phase = phase;
    }

    @Override
    public WildFlyPackageTask.Phase getPhase() {
        return this.phase;
    }

    @Override
    public void execute(WfInstallPlugin plugin, PackageRuntime pkg) throws ProvisioningException {
        final Path installDir = plugin.getRuntime().getStagedDir();
        if (this.unixLineEndFilters.isEmpty() && this.windowsLineEndFilters.isEmpty()) {
            return;
        }
        try {
            Files.walkFileTree(installDir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                    String relative = installDir.relativize(file).toString();
                    for (FileFilter filter : LineEndingsTask.this.unixLineEndFilters) {
                        if (!filter.matches(relative)) continue;
                        try {
                            LineEndingsTask.changeLineEndings(file, false);
                        }
                        catch (IOException e) {
                            throw new UncheckedIOException(String.format("Failed to convert %s to Unix line endings.", file), e);
                        }
                    }
                    for (FileFilter filter : LineEndingsTask.this.windowsLineEndFilters) {
                        if (!filter.matches(relative)) continue;
                        try {
                            LineEndingsTask.changeLineEndings(file, true);
                        }
                        catch (IOException e) {
                            throw new UncheckedIOException(String.format("Failed to convert %s to Windows line endings.", file), e);
                        }
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (UncheckedIOException e) {
            throw new ProvisioningException(e.getMessage(), (Throwable)e.getCause());
        }
        catch (IOException e) {
            throw new ProvisioningException(String.format("Failed to process %s for files that require line ending changes.", installDir), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void changeLineEndings(Path file, boolean isWindows) throws IOException {
        String eol = isWindows ? "\r\n" : "\n";
        Path temp = Files.createTempFile(file.getFileName().toString(), ".tmp", new FileAttribute[0]);
        Files.copy(file, temp, StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.COPY_ATTRIBUTES);
        try (BufferedReader reader = Files.newBufferedReader(temp, StandardCharsets.UTF_8);
             BufferedWriter writer = Files.newBufferedWriter(file, StandardCharsets.UTF_8, StandardOpenOption.TRUNCATE_EXISTING);){
            String line;
            while ((line = reader.readLine()) != null) {
                writer.write(line);
                writer.write(eol);
            }
        }
        finally {
            Files.delete(temp);
        }
    }
}

