/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.galleon.plugin.config;

import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.galleon.ProvisioningDescriptionException;
import org.jboss.galleon.config.ConfigModel;
import org.jboss.galleon.util.CollectionUtils;
import org.jboss.galleon.util.ParsingUtils;
import org.jboss.galleon.xml.ConfigXml;
import org.jboss.galleon.xml.XmlNameProvider;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.wildfly.galleon.plugin.WildFlyPackageTask;
import org.wildfly.galleon.plugin.WildFlyPackageTasks;
import org.wildfly.galleon.plugin.config.CopyArtifact;
import org.wildfly.galleon.plugin.config.CopyPath;
import org.wildfly.galleon.plugin.config.DeletePath;
import org.wildfly.galleon.plugin.config.ExampleFpConfigs;
import org.wildfly.galleon.plugin.config.FileFilter;
import org.wildfly.galleon.plugin.config.FilePermission;
import org.wildfly.galleon.plugin.config.FilePermissions;
import org.wildfly.galleon.plugin.config.LineEndingsTask;
import org.wildfly.galleon.plugin.config.XmlMerge;
import org.wildfly.galleon.plugin.config.XslTransform;

class WildFlyPackageTasksParser20
implements XMLElementReader<WildFlyPackageTasks.Builder> {
    WildFlyPackageTasksParser20() {
    }

    public void readElement(XMLExtendedStreamReader reader, WildFlyPackageTasks.Builder builder) throws XMLStreamException {
        EnumSet<Attribute> required = EnumSet.noneOf(Attribute.class);
        int count = reader.getAttributeCount();
        if (count != 0) {
            throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
        }
        if (!required.isEmpty()) {
            throw ParsingUtils.missingAttributes((Location)reader.getLocation(), required);
        }
        block15: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    Element element = Element.of(reader.getName());
                    switch (element) {
                        case COPY_ARTIFACT: {
                            builder.addTask(this.parseCopyArtifact((XMLStreamReader)reader));
                            continue block15;
                        }
                        case COPY_PATH: {
                            builder.addTask(this.parseCopyPath(reader));
                            continue block15;
                        }
                        case DELETE: {
                            builder.addTask(this.parseDeletePath((XMLStreamReader)reader));
                            continue block15;
                        }
                        case EXAMPLE_CONFIGS: {
                            builder.addTask(this.parseExampleConfigs(reader));
                            continue block15;
                        }
                        case TRANSFORM: {
                            builder.addTask(this.parseTransform(reader));
                            continue block15;
                        }
                        case FILE_PERMISSIONS: {
                            this.parseFilePermissions(reader, builder);
                            continue block15;
                        }
                        case MKDIR: {
                            builder.addMkDir(this.parseMkdir((XMLStreamReader)reader));
                            continue block15;
                        }
                        case XML_MERGE: {
                            builder.addTask(this.parseXmlMerge((XMLStreamReader)reader));
                            continue block15;
                        }
                        case LINE_ENDINGS: {
                            this.parseLineEndings((XMLStreamReader)reader, builder);
                            continue block15;
                        }
                    }
                    throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
                }
            }
            throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
        }
        throw ParsingUtils.endOfDocument((Location)reader.getLocation());
    }

    private ExampleFpConfigs parseExampleConfigs(XMLExtendedStreamReader reader) throws XMLStreamException {
        ExampleFpConfigs exampleConfigs = new ExampleFpConfigs();
        int count = reader.getAttributeCount();
        block10: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            switch (attribute) {
                case ORIGIN: {
                    exampleConfigs.setOrigin(reader.getAttributeValue(i));
                    continue block10;
                }
                default: {
                    throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
                }
            }
        }
        block11: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return exampleConfigs;
                }
                case 1: {
                    Element element = Element.of(reader.getName());
                    switch (element) {
                        case CONFIG: {
                            this.parseExampleConfigs(reader, exampleConfigs);
                            continue block11;
                        }
                    }
                    throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
                }
            }
            throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
        }
        throw ParsingUtils.endOfDocument((Location)reader.getLocation());
    }

    private void parseExampleConfigs(XMLExtendedStreamReader reader, ExampleFpConfigs builder) throws XMLStreamException {
        ConfigModel.Builder configBuilder = ConfigModel.builder();
        ConfigXml.readConfig((XMLExtendedStreamReader)reader, (ConfigModel.Builder)configBuilder);
        try {
            builder.addConfig(configBuilder.build());
        }
        catch (ProvisioningDescriptionException e) {
            throw new XMLStreamException("Failed to instantiate config model", e);
        }
    }

    private String parseName(XMLStreamReader reader) throws XMLStreamException {
        int count = reader.getAttributeCount();
        String name = null;
        EnumSet<Attribute> required = EnumSet.of(Attribute.NAME);
        block3: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case NAME: {
                    name = reader.getAttributeValue(i);
                    continue block3;
                }
                default: {
                    throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ParsingUtils.missingAttributes((Location)reader.getLocation(), required);
        }
        ParsingUtils.parseNoContent((XMLStreamReader)reader);
        return name;
    }

    private String parseMkdir(XMLStreamReader reader) throws XMLStreamException {
        return this.parseName(reader);
    }

    private void parseLineEndings(XMLStreamReader reader, WildFlyPackageTasks.Builder builder) throws XMLStreamException {
        List unixLineEndFilters = Collections.emptyList();
        List windowsLineEndFilters = Collections.emptyList();
        block8: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    LineEndingsTask lineEndingsTask = new LineEndingsTask(unixLineEndFilters, windowsLineEndFilters, WildFlyPackageTask.Phase.PROCESSING);
                    builder.addLineEndings(lineEndingsTask);
                    return;
                }
                case 1: {
                    Element element = Element.of(reader.getName());
                    switch (element) {
                        case WINDOWS: {
                            windowsLineEndFilters = CollectionUtils.addAll(windowsLineEndFilters, this.parseLineEnding(reader));
                            continue block8;
                        }
                        case UNIX: {
                            unixLineEndFilters = CollectionUtils.addAll(windowsLineEndFilters, this.parseLineEnding(reader));
                            continue block8;
                        }
                    }
                    throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
                }
            }
            throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
        }
        throw ParsingUtils.endOfDocument((Location)reader.getLocation());
    }

    private List<FileFilter> parseLineEnding(XMLStreamReader reader) throws XMLStreamException {
        if (reader.getAttributeCount() != 0) {
            throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
        }
        List filters = Collections.emptyList();
        block7: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return filters;
                }
                case 1: {
                    Element element = Element.of(reader.getName());
                    FileFilter filter = this.parseFilter(reader);
                    switch (element) {
                        case FILTER: {
                            filters = CollectionUtils.add(filters, (Object)filter);
                            continue block7;
                        }
                    }
                    throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
                }
            }
            throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
        }
        throw ParsingUtils.endOfDocument((Location)reader.getLocation());
    }

    public FileFilter parseFilter(XMLStreamReader reader) throws XMLStreamException {
        FileFilter builder = new FileFilter();
        EnumSet<Attribute> required = EnumSet.of(Attribute.PATTERN, Attribute.INCLUDE);
        int count = reader.getAttributeCount();
        block4: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case PATTERN: {
                    builder.setPatternString(reader.getAttributeValue(i));
                    continue block4;
                }
                case INCLUDE: {
                    if (!Boolean.parseBoolean(reader.getAttributeValue(i))) continue block4;
                    builder.setInclude();
                    continue block4;
                }
                default: {
                    throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ParsingUtils.missingAttributes((Location)reader.getLocation(), required);
        }
        ParsingUtils.parseNoContent((XMLStreamReader)reader);
        return builder;
    }

    private CopyArtifact parseCopyArtifact(XMLStreamReader reader) throws XMLStreamException {
        CopyArtifact builder = new CopyArtifact();
        EnumSet<Attribute> required = EnumSet.of(Attribute.ARTIFACT, Attribute.TO_LOCATION);
        int count = reader.getAttributeCount();
        block14: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case ARTIFACT: {
                    builder.setArtifact(reader.getAttributeValue(i));
                    continue block14;
                }
                case TO_LOCATION: {
                    builder.setToLocation(reader.getAttributeValue(i));
                    continue block14;
                }
                case EXTRACT: {
                    if (!Boolean.parseBoolean(reader.getAttributeValue(i))) continue block14;
                    builder.setExtract();
                    continue block14;
                }
                case OPTIONAL: {
                    if (!Boolean.parseBoolean(reader.getAttributeValue(i))) continue block14;
                    builder.setOptional();
                    continue block14;
                }
                case FEATURE_PACK_VERSION: {
                    if (!Boolean.parseBoolean(reader.getAttributeValue(i))) continue block14;
                    builder.setFeaturePackVersion();
                    continue block14;
                }
                default: {
                    throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ParsingUtils.missingAttributes((Location)reader.getLocation(), required);
        }
        block15: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return builder;
                }
                case 1: {
                    Element element = Element.of(reader.getName());
                    switch (element) {
                        case FILTER: {
                            builder.addFilter(this.parseFilter(reader));
                            continue block15;
                        }
                    }
                    throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
                }
            }
            throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
        }
        throw ParsingUtils.endOfDocument((Location)reader.getLocation());
    }

    private CopyPath parseCopyPath(XMLExtendedStreamReader reader) throws XMLStreamException {
        CopyPath cpBuilder = new CopyPath();
        boolean src = false;
        int count = reader.getAttributeCount();
        block6: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            switch (attribute) {
                case SRC: {
                    cpBuilder.setSrc(reader.getAttributeValue(i));
                    src = true;
                    continue block6;
                }
                case TARGET: {
                    cpBuilder.setTarget(reader.getAttributeValue(i));
                    continue block6;
                }
                case REPLACE_PROPERTIES: {
                    cpBuilder.setReplaceProperties(Boolean.parseBoolean(reader.getAttributeValue(i)));
                    continue block6;
                }
                case RELATIVE_TO: {
                    cpBuilder.setRelativeTo(reader.getAttributeValue(i));
                    src = true;
                    continue block6;
                }
                default: {
                    throw ParsingUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!src) {
            throw ParsingUtils.missingAttributes((Location)reader.getLocation(), Collections.singleton(Attribute.PATH));
        }
        ParsingUtils.parseNoContent((XMLStreamReader)reader);
        return cpBuilder;
    }

    private void parseFilePermissions(XMLExtendedStreamReader reader, WildFlyPackageTasks.Builder builder) throws XMLStreamException {
        FilePermissions permissions = new FilePermissions();
        int count = reader.getAttributeCount();
        block10: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            switch (attribute) {
                case PHASE: {
                    permissions.setPhase(reader.getAttributeValue(i));
                    continue block10;
                }
                default: {
                    throw ParsingUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        block11: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    builder.addTask(permissions);
                    return;
                }
                case 1: {
                    Element element = Element.of(reader.getName());
                    switch (element) {
                        case PERMISSION: {
                            permissions.addFilePermissions(this.parsePermission((XMLStreamReader)reader));
                            continue block11;
                        }
                    }
                    throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
                }
            }
            throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
        }
        throw ParsingUtils.endOfDocument((Location)reader.getLocation());
    }

    protected FilePermission parsePermission(XMLStreamReader reader) throws XMLStreamException {
        FilePermission permissionBuilder = new FilePermission();
        EnumSet<Attribute> required = EnumSet.of(Attribute.VALUE);
        int count = reader.getAttributeCount();
        block10: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case VALUE: {
                    permissionBuilder.setValue(reader.getAttributeValue(i));
                    continue block10;
                }
                default: {
                    throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ParsingUtils.missingAttributes((Location)reader.getLocation(), required);
        }
        block11: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return permissionBuilder;
                }
                case 1: {
                    Element element = Element.of(reader.getName());
                    switch (element) {
                        case FILTER: {
                            permissionBuilder.addFilter(this.parseFilter(reader));
                            continue block11;
                        }
                    }
                    throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
                }
            }
            throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
        }
        throw ParsingUtils.endOfDocument((Location)reader.getLocation());
    }

    private DeletePath parseDeletePath(XMLStreamReader reader) throws XMLStreamException {
        int count = reader.getAttributeCount();
        String path = null;
        boolean recursive = false;
        boolean ifEmpty = false;
        block5: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            switch (attribute) {
                case PATH: {
                    path = reader.getAttributeValue(i);
                    continue block5;
                }
                case RECURSIVE: {
                    recursive = Boolean.parseBoolean(reader.getAttributeValue(i));
                    continue block5;
                }
                case IF_EMPTY: {
                    ifEmpty = Boolean.parseBoolean(reader.getAttributeValue(i));
                    continue block5;
                }
                default: {
                    throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
                }
            }
        }
        if (path == null) {
            throw ParsingUtils.missingAttributes((Location)reader.getLocation(), Collections.singleton(Attribute.PATH));
        }
        ParsingUtils.parseNoContent((XMLStreamReader)reader);
        return new DeletePath(path, recursive, ifEmpty);
    }

    private XslTransform parseTransform(XMLExtendedStreamReader reader) throws XMLStreamException {
        XslTransform result = new XslTransform();
        int count = reader.getAttributeCount();
        block14: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            switch (attribute) {
                case SRC: {
                    result.setSrc(reader.getAttributeValue(i));
                    continue block14;
                }
                case OUTPUT: {
                    result.setOutput(reader.getAttributeValue(i));
                    continue block14;
                }
                case STYLESHEET: {
                    result.setStylesheet(reader.getAttributeValue(i));
                    continue block14;
                }
                case PHASE: {
                    result.setPhase(reader.getAttributeValue(i));
                    continue block14;
                }
                case FEATURE_PACK_PROPS: {
                    if (!Boolean.parseBoolean(reader.getAttributeValue(i))) continue block14;
                    result.setFeaturePackProperties();
                    continue block14;
                }
                default: {
                    throw ParsingUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        block15: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    if (result.getSrc() == null) {
                        throw ParsingUtils.missingAttributes((Location)reader.getLocation(), Collections.singleton(Attribute.SRC));
                    }
                    if (result.getOutput() == null) {
                        throw ParsingUtils.missingAttributes((Location)reader.getLocation(), Collections.singleton(Attribute.OUTPUT));
                    }
                    if (result.getStylesheet() == null) {
                        throw ParsingUtils.missingAttributes((Location)reader.getLocation(), Collections.singleton(Attribute.STYLESHEET));
                    }
                    return result;
                }
                case 1: {
                    Element element = Element.of(reader.getName());
                    switch (element) {
                        case PARAMS: {
                            this.parseParams((XMLStreamReader)reader, result);
                            continue block15;
                        }
                    }
                    throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
                }
            }
            throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
        }
        throw ParsingUtils.endOfDocument((Location)reader.getLocation());
    }

    private void parseParams(XMLStreamReader reader, XslTransform result) throws XMLStreamException {
        block7: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    Element element = Element.of(reader.getName());
                    switch (element) {
                        case PARAM: {
                            this.parseParam(reader, result);
                            continue block7;
                        }
                    }
                    throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
                }
            }
            throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
        }
        throw ParsingUtils.endOfDocument((Location)reader.getLocation());
    }

    private void parseParam(XMLStreamReader reader, XslTransform result) throws XMLStreamException {
        String name = null;
        String value = null;
        int count = reader.getAttributeCount();
        block4: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            switch (attribute) {
                case NAME: {
                    name = reader.getAttributeValue(i);
                    continue block4;
                }
                case VALUE: {
                    value = reader.getAttributeValue(i);
                    continue block4;
                }
                default: {
                    throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
                }
            }
        }
        if (name == null) {
            throw ParsingUtils.missingAttributes((Location)reader.getLocation(), Collections.singleton(Attribute.NAME));
        }
        if (value == null) {
            throw ParsingUtils.missingAttributes((Location)reader.getLocation(), Collections.singleton(Attribute.VALUE));
        }
        ParsingUtils.parseNoContent((XMLStreamReader)reader);
        result.setParam(name, value);
    }

    private XmlMerge parseXmlMerge(XMLStreamReader reader) throws XMLStreamException {
        XmlMerge builder = new XmlMerge();
        EnumSet<Attribute> required = EnumSet.of(Attribute.OUTPUT);
        int count = reader.getAttributeCount();
        block11: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case OUTPUT: {
                    builder.setOutput(reader.getAttributeValue(i));
                    continue block11;
                }
                case BASEDIR: {
                    builder.setBasedir(reader.getAttributeValue(i));
                    continue block11;
                }
                default: {
                    throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ParsingUtils.missingAttributes((Location)reader.getLocation(), required);
        }
        block12: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return builder;
                }
                case 1: {
                    Element element = Element.of(reader.getName());
                    switch (element) {
                        case FILTER: {
                            builder.addFilter(this.parseFilter(reader));
                            continue block12;
                        }
                    }
                    throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
                }
            }
            throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
        }
        throw ParsingUtils.endOfDocument((Location)reader.getLocation());
    }

    static enum Attribute implements XmlNameProvider
    {
        ARTIFACT("artifact"),
        BASEDIR("basedir"),
        EXTRACT("extract"),
        FEATURE_PACK_PROPS("feature-pack-properties"),
        FEATURE_PACK_VERSION("feature-pack-version"),
        GROUP("group"),
        IF_EMPTY("if-empty"),
        INCLUDE("include"),
        MODEL("model"),
        NAME("name"),
        OPTIONAL("optional"),
        ORIGIN("origin"),
        OUTPUT("output"),
        PATH("path"),
        PATTERN("pattern"),
        PHASE("phase"),
        RELATIVE_TO("relative-to"),
        RECURSIVE("recursive"),
        REPLACE_PROPERTIES("replace-props"),
        SRC("src"),
        STYLESHEET("stylesheet"),
        TARGET("target"),
        TO_LOCATION("to-location"),
        VALUE("value"),
        UNKNOWN(null);

        private static final Map<QName, Attribute> attributes;
        private final String name;

        static Attribute of(QName qName) {
            Attribute attribute = attributes.get(qName);
            return attribute == null ? UNKNOWN : attribute;
        }

        private Attribute(String name) {
            this.name = name;
        }

        public String getLocalName() {
            return this.name;
        }

        public String getNamespace() {
            return null;
        }

        static {
            HashMap<QName, Attribute> attributesMap = new HashMap<QName, Attribute>(24);
            attributesMap.put(new QName(ARTIFACT.getLocalName()), ARTIFACT);
            attributesMap.put(new QName(BASEDIR.getLocalName()), BASEDIR);
            attributesMap.put(new QName(EXTRACT.getLocalName()), EXTRACT);
            attributesMap.put(new QName(FEATURE_PACK_PROPS.getLocalName()), FEATURE_PACK_PROPS);
            attributesMap.put(new QName(FEATURE_PACK_VERSION.getLocalName()), FEATURE_PACK_VERSION);
            attributesMap.put(new QName(GROUP.getLocalName()), GROUP);
            attributesMap.put(new QName(IF_EMPTY.getLocalName()), IF_EMPTY);
            attributesMap.put(new QName(INCLUDE.getLocalName()), INCLUDE);
            attributesMap.put(new QName(MODEL.getLocalName()), MODEL);
            attributesMap.put(new QName(NAME.getLocalName()), NAME);
            attributesMap.put(new QName(ORIGIN.getLocalName()), ORIGIN);
            attributesMap.put(new QName(OPTIONAL.getLocalName()), OPTIONAL);
            attributesMap.put(new QName(OUTPUT.getLocalName()), OUTPUT);
            attributesMap.put(new QName(PATH.getLocalName()), PATH);
            attributesMap.put(new QName(PATTERN.getLocalName()), PATTERN);
            attributesMap.put(new QName(PHASE.getLocalName()), PHASE);
            attributesMap.put(new QName(RECURSIVE.getLocalName()), RECURSIVE);
            attributesMap.put(new QName(RELATIVE_TO.getLocalName()), RELATIVE_TO);
            attributesMap.put(new QName(REPLACE_PROPERTIES.getLocalName()), REPLACE_PROPERTIES);
            attributesMap.put(new QName(SRC.getLocalName()), SRC);
            attributesMap.put(new QName(STYLESHEET.getLocalName()), STYLESHEET);
            attributesMap.put(new QName(TARGET.getLocalName()), TARGET);
            attributesMap.put(new QName(TO_LOCATION.getLocalName()), TO_LOCATION);
            attributesMap.put(new QName(VALUE.getLocalName()), VALUE);
            attributes = attributesMap;
        }
    }

    static enum Element {
        CONFIG("config"),
        COPY_ARTIFACT("copy-artifact"),
        COPY_PATH("copy-path"),
        DELETE("delete"),
        EXAMPLE_CONFIGS("example-configs"),
        FILE_PERMISSIONS("file-permissions"),
        FILTER("filter"),
        LINE_ENDINGS("line-endings"),
        MKDIR("mkdir"),
        PARAM("param"),
        PARAMS("params"),
        PERMISSION("permission"),
        TASKS("tasks"),
        TRANSFORM("transform"),
        UNIX("unix"),
        WINDOWS("windows"),
        XML_MERGE("xml-merge"),
        UNKNOWN(null);

        private static final Map<QName, Element> elements;
        private final String name;

        static Element of(QName qName) {
            QName name = qName.getNamespaceURI().equals("") ? new QName("urn:wildfly:wildfly-feature-pack-tasks:2.0", qName.getLocalPart()) : qName;
            Element element = elements.get(name);
            return element == null ? UNKNOWN : element;
        }

        private Element(String name) {
            this.name = name;
        }

        public String getLocalName() {
            return this.name;
        }

        static {
            HashMap<QName, Element> elementsMap = new HashMap<QName, Element>(17);
            elementsMap.put(new QName("urn:wildfly:wildfly-feature-pack-tasks:2.0", CONFIG.getLocalName()), CONFIG);
            elementsMap.put(new QName("urn:wildfly:wildfly-feature-pack-tasks:2.0", COPY_ARTIFACT.getLocalName()), COPY_ARTIFACT);
            elementsMap.put(new QName("urn:wildfly:wildfly-feature-pack-tasks:2.0", COPY_PATH.getLocalName()), COPY_PATH);
            elementsMap.put(new QName("urn:wildfly:wildfly-feature-pack-tasks:2.0", DELETE.getLocalName()), DELETE);
            elementsMap.put(new QName("urn:wildfly:wildfly-feature-pack-tasks:2.0", EXAMPLE_CONFIGS.getLocalName()), EXAMPLE_CONFIGS);
            elementsMap.put(new QName("urn:wildfly:wildfly-feature-pack-tasks:2.0", FILE_PERMISSIONS.getLocalName()), FILE_PERMISSIONS);
            elementsMap.put(new QName("urn:wildfly:wildfly-feature-pack-tasks:2.0", FILTER.getLocalName()), FILTER);
            elementsMap.put(new QName("urn:wildfly:wildfly-feature-pack-tasks:2.0", LINE_ENDINGS.getLocalName()), LINE_ENDINGS);
            elementsMap.put(new QName("urn:wildfly:wildfly-feature-pack-tasks:2.0", MKDIR.getLocalName()), MKDIR);
            elementsMap.put(new QName("urn:wildfly:wildfly-feature-pack-tasks:2.0", PARAM.getLocalName()), PARAM);
            elementsMap.put(new QName("urn:wildfly:wildfly-feature-pack-tasks:2.0", PARAMS.getLocalName()), PARAMS);
            elementsMap.put(new QName("urn:wildfly:wildfly-feature-pack-tasks:2.0", PERMISSION.getLocalName()), PERMISSION);
            elementsMap.put(new QName("urn:wildfly:wildfly-feature-pack-tasks:2.0", TASKS.getLocalName()), TASKS);
            elementsMap.put(new QName("urn:wildfly:wildfly-feature-pack-tasks:2.0", TRANSFORM.getLocalName()), TRANSFORM);
            elementsMap.put(new QName("urn:wildfly:wildfly-feature-pack-tasks:2.0", UNIX.getLocalName()), UNIX);
            elementsMap.put(new QName("urn:wildfly:wildfly-feature-pack-tasks:2.0", WINDOWS.getLocalName()), WINDOWS);
            elementsMap.put(new QName("urn:wildfly:wildfly-feature-pack-tasks:2.0", XML_MERGE.getLocalName()), XML_MERGE);
            elements = elementsMap;
        }
    }
}

