/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.audit;

import java.io.IOException;
import java.net.PortUnreachableException;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;
import org.jboss.logging.annotations.ValidIdRange;
import org.jboss.logging.annotations.ValidIdRanges;
import org.wildfly.security.audit.EventPriority;

@MessageLogger(projectCode="ELY", length=5)
@ValidIdRanges(value={@ValidIdRange(min=11001, max=11007), @ValidIdRange(min=12000, max=12002)})
interface ElytronMessages
extends BasicLogger {
    public static final ElytronMessages audit = (ElytronMessages)Logger.getMessageLogger(ElytronMessages.class, (String)"org.wildfly.security.audit");

    @LogMessage(level=Logger.Level.FATAL)
    @Message(id=11001, value="Endpoint unable to handle SecurityEvent priority=%s, message=%s")
    public void endpointUnavaiable(String var1, String var2, @Cause Throwable var3);

    @Message(id=11002, value="Invalid EventPriority '%s' passed to AuditEndpoint.")
    public IllegalArgumentException invalidEventPriority(EventPriority var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=11003, value="Unable to rotate log file")
    public void unableToRotateLogFile(@Cause Throwable var1);

    @Message(id=11004, value="Invalid suffix \"%s\" - rotating by second or millisecond is not supported")
    public IllegalArgumentException rotatingBySecondUnsupported(String var1);

    @LogMessage(level=Logger.Level.FATAL)
    @Message(id=11007, value="Endpoint unable to accept SecurityEvent.")
    public void unableToAcceptEvent(@Cause Throwable var1);

    @Message(id=12000, value="The reconnect attempts value of %s is invalid. Please use an integer value >= -1.")
    public IllegalArgumentException badReconnectAttemptsNumber(int var1);

    @Message(id=12001, value="The maximum reconnect attempts value of %s was reached. The syslog endpoint will be shutdown.")
    public IOException syslogMaximumReconnectAttemptsReached(int var1);

    @Message(id=12002, value="The configured UDP port is unavailable.")
    public PortUnreachableException udpPortUnavailable(@Cause Throwable var1);
}

