/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.mechanism.scram;

import java.util.Arrays;
import org.wildfly.security.mechanism.scram.ScramClient;
import org.wildfly.security.mechanism.scram.ScramMechanism;

public final class ScramInitialClientMessage {
    private final ScramMechanism mechanism;
    private final String authorizationId;
    private final String authenticationName;
    private final boolean binding;
    private final String bindingType;
    private final byte[] bindingData;
    private final byte[] nonce;
    private final int initialPartIndex;
    private final byte[] messageBytes;

    ScramInitialClientMessage(ScramClient scramClient, String authenticationName, boolean binding, byte[] nonce, int initialPartIndex, byte[] messageBytes) {
        this.binding = binding;
        this.initialPartIndex = initialPartIndex;
        this.bindingType = scramClient.getBindingType();
        this.bindingData = scramClient.getRawBindingData();
        this.mechanism = scramClient.getMechanism();
        this.authorizationId = scramClient.getAuthorizationId();
        this.authenticationName = authenticationName;
        this.nonce = nonce;
        this.messageBytes = messageBytes;
    }

    ScramInitialClientMessage(ScramMechanism mechanism, String authorizationId, String authenticationName, boolean binding, String bindingType, byte[] bindingData, byte[] nonce, int initialPartIndex, byte[] messageBytes) {
        this.mechanism = mechanism;
        this.authorizationId = authorizationId;
        this.authenticationName = authenticationName;
        this.binding = binding;
        this.bindingType = bindingType;
        this.bindingData = bindingData;
        this.nonce = nonce;
        this.initialPartIndex = initialPartIndex;
        this.messageBytes = messageBytes;
    }

    public ScramMechanism getMechanism() {
        return this.mechanism;
    }

    public String getAuthenticationName() {
        return this.authenticationName;
    }

    public byte[] getNonce() {
        return (byte[])this.nonce.clone();
    }

    byte[] getRawNonce() {
        return this.nonce;
    }

    public byte[] getInitialPart() {
        return Arrays.copyOfRange(this.messageBytes, 0, this.initialPartIndex);
    }

    public byte[] getMessageBytes() {
        return (byte[])this.messageBytes.clone();
    }

    public String getAuthorizationId() {
        return this.authorizationId;
    }

    public boolean isBinding() {
        return this.binding;
    }

    public String getBindingType() {
        return this.bindingType;
    }

    public byte[] getBindingData() {
        return this.bindingData == null ? null : (byte[])this.bindingData.clone();
    }

    byte[] getRawBindingData() {
        return this.bindingData;
    }

    int getInitialPartIndex() {
        return this.initialPartIndex;
    }

    byte[] getRawMessageBytes() {
        return this.messageBytes;
    }
}

