/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.jaspi.impl;

import java.io.IOException;
import java.security.Principal;
import java.security.PrivilegedActionException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.message.callback.CallerPrincipalCallback;
import javax.security.auth.message.callback.GroupPrincipalCallback;
import javax.security.auth.message.callback.PasswordValidationCallback;
import org.wildfly.common.Assert;
import org.wildfly.security.auth.callback.CallbackUtil;
import org.wildfly.security.auth.jaspi._private.ElytronMessages;
import org.wildfly.security.auth.jaspi.impl.SecurityActions;
import org.wildfly.security.auth.principal.NamePrincipal;
import org.wildfly.security.auth.server.SecurityDomain;
import org.wildfly.security.auth.server.SecurityIdentity;
import org.wildfly.security.auth.server.ServerAuthenticationContext;
import org.wildfly.security.authz.RoleMapper;
import org.wildfly.security.authz.Roles;
import org.wildfly.security.evidence.Evidence;
import org.wildfly.security.evidence.PasswordGuessEvidence;
import org.wildfly.security.permission.ElytronPermission;

public class JaspiAuthenticationContext {
    static final ElytronPermission CREATE_AUTH_CONTEXT = ElytronPermission.forName("createServerAuthenticationContext");
    private final SecurityDomain securityDomain;
    private final boolean integrated;
    private volatile SecurityIdentity securityIdentity = null;
    private final Set<String> roles = new HashSet<String>();

    JaspiAuthenticationContext(SecurityDomain securityDomain, boolean integrated) {
        this.securityDomain = securityDomain;
        this.integrated = integrated;
    }

    public static JaspiAuthenticationContext newInstance(SecurityDomain securityDomain, boolean integrated) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(CREATE_AUTH_CONTEXT);
        }
        return new JaspiAuthenticationContext((SecurityDomain)Assert.checkNotNullParam((String)"securityDomain", (Object)securityDomain), integrated);
    }

    public CallbackHandler createCallbackHandler() {
        return this.createCommonCallbackHandler(this.integrated);
    }

    private CallbackHandler createCommonCallbackHandler(final boolean integrated) {
        return new CallbackHandler(){

            @Override
            public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
                try {
                    SecurityActions.doPrivileged(() -> {
                        this.handleOne(callbacks, 0);
                        return null;
                    });
                }
                catch (Exception e) {
                    if (e instanceof PrivilegedActionException) {
                        if (e.getCause() instanceof UnsupportedCallbackException) {
                            throw (UnsupportedCallbackException)e.getCause();
                        }
                        if (e.getCause() instanceof IOException) {
                            throw (IOException)e.getCause();
                        }
                    }
                    throw new IOException(e);
                }
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            private void handleOne(Callback[] callbacks, int index) throws IOException, UnsupportedCallbackException {
                if (callbacks.length == index) {
                    return;
                }
                Callback callback = callbacks[index];
                if (callback instanceof PasswordValidationCallback) {
                    PasswordValidationCallback pvc = (PasswordValidationCallback)callback;
                    String username = pvc.getUsername();
                    ElytronMessages.log.tracef("Handling PasswordValidationCallback for '%s'", (Object)username);
                    PasswordGuessEvidence evidence = new PasswordGuessEvidence(pvc.getPassword());
                    try {
                        SecurityIdentity authenticated = JaspiAuthenticationContext.this.securityDomain.authenticate(username, (Evidence)evidence);
                        pvc.setResult(true);
                        JaspiAuthenticationContext.this.securityIdentity = authenticated;
                    }
                    catch (Exception e) {
                        ElytronMessages.log.trace("Authentication failed", e);
                        pvc.setResult(false);
                    }
                } else if (callback instanceof CallerPrincipalCallback) {
                    ElytronMessages.log.trace("Handling CallerPrincipalCallback");
                    CallerPrincipalCallback cpc = (CallerPrincipalCallback)callback;
                    Principal originalPrincipal = cpc.getPrincipal();
                    String callerName = cpc.getName();
                    Principal callerPrincipal = originalPrincipal != null ? originalPrincipal : (callerName != null ? new NamePrincipal(callerName) : null);
                    ElytronMessages.log.tracef("Original Principal = '%s', Caller Name = '%s', Resulting Principal = '%s'", (Object)originalPrincipal, (Object)callerName, (Object)callerPrincipal);
                    SecurityIdentity authorizedIdentity = null;
                    if (JaspiAuthenticationContext.this.securityIdentity != null) {
                        if (callerPrincipal != null) {
                            boolean authorizationRequired = integrated && !JaspiAuthenticationContext.this.securityIdentity.getPrincipal().equals(callerPrincipal);
                            authorizedIdentity = JaspiAuthenticationContext.this.securityIdentity.createRunAsIdentity(callerPrincipal, authorizationRequired);
                        } else if (integrated) {
                            ServerAuthenticationContext sac = JaspiAuthenticationContext.this.securityDomain.createNewAuthenticationContext();
                            sac.importIdentity(JaspiAuthenticationContext.this.securityIdentity);
                            sac.authorize();
                            authorizedIdentity = sac.getAuthorizedIdentity();
                        } else {
                            authorizedIdentity = JaspiAuthenticationContext.this.securityIdentity;
                        }
                    } else {
                        if (callerPrincipal == null) {
                            this.handleOne(callbacks, index + 1);
                            return;
                        }
                        if (integrated) {
                            ServerAuthenticationContext sac = JaspiAuthenticationContext.this.securityDomain.createNewAuthenticationContext();
                            sac.setAuthenticationPrincipal(callerPrincipal);
                            if (sac.authorize()) {
                                authorizedIdentity = sac.getAuthorizedIdentity();
                            }
                        } else {
                            authorizedIdentity = JaspiAuthenticationContext.this.securityDomain.createAdHocIdentity(callerPrincipal);
                        }
                    }
                    if (authorizedIdentity == null) throw ElytronMessages.log.authorizationFailed();
                    JaspiAuthenticationContext.this.securityIdentity = authorizedIdentity;
                    Subject subject = cpc.getSubject();
                    if (subject != null && !subject.isReadOnly()) {
                        subject.getPrincipals().add(authorizedIdentity.getPrincipal());
                    }
                } else if (callback instanceof GroupPrincipalCallback) {
                    ElytronMessages.log.trace("Handling GroupPrincipalCallback");
                    ElytronMessages.log.trace("Handling GroupPrincipalCallback");
                    GroupPrincipalCallback gpc = (GroupPrincipalCallback)callback;
                    String[] groups = gpc.getGroups();
                    if (groups != null && groups.length > 0) {
                        JaspiAuthenticationContext.this.roles.addAll(Arrays.asList(groups));
                    }
                } else {
                    CallbackUtil.unsupported(callback);
                    this.handleOne(callbacks, index + 1);
                }
                this.handleOne(callbacks, index + 1);
            }
        };
    }

    public SecurityIdentity getAuthorizedIdentity() throws IllegalStateException {
        SecurityIdentity securityIdentity = this.securityIdentity;
        if (securityIdentity != null && this.roles.size() > 0) {
            if (ElytronMessages.log.isTraceEnabled()) {
                Iterator<String> rolesIterator = this.roles.iterator();
                StringBuilder sb = new StringBuilder(rolesIterator.next());
                while (rolesIterator.hasNext()) {
                    sb.append(",").append(rolesIterator.next());
                }
                ElytronMessages.log.tracef("Assigning roles '%s' to resulting SecurityIdentity", (Object)sb.toString());
            }
            Roles roles = Roles.fromSet(this.roles);
            RoleMapper roleMapper = RoleMapper.constant(roles);
            SecurityIdentity temp = securityIdentity;
            securityIdentity = SecurityActions.doPrivileged(() -> temp.withDefaultRoleMapper(roleMapper));
        } else {
            ElytronMessages.log.trace("No roles request of CallbackHandler.");
        }
        return securityIdentity;
    }
}

