/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.util;

import java.security.Principal;
import java.util.Map;
import java.util.regex.Pattern;
import org.wildfly.security.auth.server.RealmMapper;
import org.wildfly.security.auth.util.SimpleRegexRealmMapper;
import org.wildfly.security.evidence.Evidence;

public class MappedRegexRealmMapper
extends SimpleRegexRealmMapper {
    private final Map<String, String> realmNameMap;

    public MappedRegexRealmMapper(Pattern realmNamePattern, Map<String, String> realmNameMap) {
        super(realmNamePattern);
        this.realmNameMap = realmNameMap;
    }

    public MappedRegexRealmMapper(Pattern realmNamePattern, RealmMapper delegate, Map<String, String> realmNameMap) {
        super(realmNamePattern, delegate);
        this.realmNameMap = realmNameMap;
    }

    @Override
    public String getRealmMapping(Principal principal, Evidence evidence) {
        String mappedRealmPart = super.getRealmMapping(principal, evidence);
        if (mappedRealmPart == null) {
            return null;
        }
        return this.realmNameMap.get(mappedRealmPart);
    }
}

