/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.http.util.sso;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Locale;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.Logger;
import org.wildfly.security.http.HttpAuthenticationException;
import org.wildfly.security.http.util.sso.ElytronMessages;

public class ElytronMessages_$logger
extends DelegatingBasicLogger
implements ElytronMessages,
BasicLogger,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = ElytronMessages_$logger.class.getName();
    private static final Locale LOCALE = Locale.ROOT;

    public ElytronMessages_$logger(Logger log) {
        super(log);
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    @Override
    public final void warnHttpMechSsoFailedLogoutParticipant(String url, Throwable cause) {
        this.log.logf(FQCN, Logger.Level.WARN, cause, this.warnHttpMechSsoFailedLogoutParticipant$str(), (Object)url);
    }

    protected String warnHttpMechSsoFailedLogoutParticipant$str() {
        return "ELY06008: Failed to logout participant [%s]. Participant will be removed from list of participants but its local session may still be active.";
    }

    protected String httpMechSsoInvalidLogoutMessage$str() {
        return "ELY06012: Invalid logout message received for local session [%s]";
    }

    @Override
    public final IllegalStateException httpMechSsoInvalidLogoutMessage(String localSessionId) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.httpMechSsoInvalidLogoutMessage$str(), localSessionId));
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    private static void _copyStackTraceMinusOne(Throwable e) {
        StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }

    @Override
    public final void errorHttpMechSsoFailedInvalidateLocalSession(Throwable cause) {
        this.log.logf(FQCN, Logger.Level.ERROR, cause, this.errorHttpMechSsoFailedInvalidateLocalSession$str(), new Object[0]);
    }

    protected String errorHttpMechSsoFailedInvalidateLocalSession$str() {
        return "ELY06013: Failed to invalidate local session";
    }

    protected String httpServerAuthenticationMechanismNotFound$str() {
        return "ELY06014: Authentication mechanism '%s' cannot be found";
    }

    @Override
    public final HttpAuthenticationException httpServerAuthenticationMechanismNotFound(String mechanismName) {
        HttpAuthenticationException result = new HttpAuthenticationException(String.format(this.getLoggingLocale(), this.httpServerAuthenticationMechanismNotFound$str(), mechanismName));
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }
}

