/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.cli;

import java.io.IOException;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.enterprise.inject.Vetoed;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.wildfly.swarm.Swarm;
import org.wildfly.swarm.cli.CommandLineParser;
import org.wildfly.swarm.cli.Option;
import org.wildfly.swarm.cli.Options;
import org.wildfly.swarm.spi.api.StageConfig;

@Vetoed
public class CommandLine {
    public static final Option<Boolean> HELP = new Option().withLong("help").withShort(Character.valueOf('h')).withDescription("Display this help").withDefault(() -> false).then((cmd, opt, value) -> cmd.put(opt, true));
    public static final Option<Boolean> VERSION = new Option().withLong("version").withShort(Character.valueOf('v')).withDescription("Display the version of WildFly Swarm").withDefault(() -> false).then((cmd, opt, value) -> cmd.put(opt, true));
    public static final Option<Properties> PROPERTY = new Option().withShort(Character.valueOf('D')).hasValue("<name>[=<value>]").valueMayBeSeparate(false).withDescription("Set a system property").withDefault(Properties::new).then((cmd, opt, value) -> {
        String[] nameValue = value.split("=");
        Properties props = (Properties)cmd.get(opt);
        String propName = nameValue[0];
        String propValue = "true";
        if (nameValue.length > 1) {
            propValue = nameValue[1];
        }
        props.setProperty(propName, propValue);
    });
    public static final Option<URL> PROPERTIES_URL = new Option().withShort(Character.valueOf('P')).withLong("properties").hasValue("<url>").withDescription("Load system properties from the given URL").then((cmd, opt, value) -> cmd.put(opt, Option.toURL(value)));
    public static final Option<URL> SERVER_CONFIG = new Option().withShort(Character.valueOf('c')).withLong("server-config").hasValue("<config>").valueMayBeSeparate(true).withDescription("URL of the server configuration (e.g. standalone.xml)").withDefault(() -> CommandLine.resolveResource("standalone.xml")).then((cmd, opt, value) -> cmd.put(opt, Option.toURL(value)));
    public static final Option<URL> STAGE_CONFIG = new Option().withShort(Character.valueOf('s')).withLong("stage-config").hasValue("<config>").valueMayBeSeparate(true).withDescription("URL to the stage configuration (e.g. config.yaml").withDefault(() -> CommandLine.resolveResource("project-stages.yml")).then((cmd, opt, value) -> cmd.put(opt, Option.toURL(value)));
    public static final Option<String> ACTIVE_STAGE = new Option().withShort(Character.valueOf('S')).withLong("stage").hasValue("<active-stage>").valueMayBeSeparate(true).withDescription("When using a stage-config, set the active stage").then(CommandLine::put);
    public static final Option<String> BIND = new Option().withShort(Character.valueOf('b')).hasValue("<value>").valueMayBeSeparate(true).withDescription("Set the property swarm.bind.address to <value>").then(CommandLine::put);
    private final Options options;
    private final Map<Option<?>, Object> values = new HashMap();
    private final List<String> extraArguments = new ArrayList<String>();
    private final List<String> invalidArguments = new ArrayList<String>();

    public static Options defaultOptions() {
        return new Options(HELP, VERSION, PROPERTY, PROPERTIES_URL, SERVER_CONFIG, STAGE_CONFIG, ACTIVE_STAGE, BIND);
    }

    CommandLine(Options options) {
        this.options = options;
    }

    public <T> void put(Option<T> key, T value) {
        this.values.put(key, value);
    }

    public <T> T get(Option<T> key) {
        Object v = this.values.get(key);
        if (v == null) {
            v = key.defaultValue();
            this.values.put(key, v);
        }
        return (T)v;
    }

    public void displayHelp(PrintStream out) {
        this.options.displayHelp(out);
    }

    public void displayHelp(PrintStream out, StageConfig stageConfig) {
        this.displayHelp(out);
        if (stageConfig != null) {
            out.println();
            out.println("Stage configuration options:");
            out.println();
            for (String key : stageConfig.keys()) {
                out.println("  " + key);
            }
            out.println();
        }
    }

    public void displayVersion(PrintStream out) {
        out.println("WildFly Swarm version UNKNOWN");
    }

    public void applyProperties() throws IOException {
        URL propsUrl = this.get(PROPERTIES_URL);
        if (propsUrl != null) {
            Properties urlProps = new Properties();
            urlProps.load(propsUrl.openStream());
            for (String name : urlProps.stringPropertyNames()) {
                System.setProperty(name, urlProps.getProperty(name));
            }
        }
        Properties props = this.get(PROPERTY);
        for (String name : props.stringPropertyNames()) {
            System.setProperty(name, props.getProperty(name));
        }
        if (this.get(BIND) != null) {
            System.setProperty("swarm.bind.address", this.get(BIND));
        }
        if (this.get(ACTIVE_STAGE) != null) {
            System.setProperty("swarm.project.stage", this.get(ACTIVE_STAGE));
        }
    }

    public void applyConfigurations(Swarm swarm) throws MalformedURLException {
        if (this.get(SERVER_CONFIG) != null) {
            swarm.withXmlConfig(this.get(SERVER_CONFIG));
        }
        if (this.get(STAGE_CONFIG) != null) {
            swarm.withStageConfig(this.get(STAGE_CONFIG));
        }
    }

    public void apply(Swarm swarm) throws IOException {
        this.applyProperties();
        this.applyConfigurations(swarm);
        if (this.get(HELP).booleanValue()) {
            this.displayVersion(System.err);
            System.err.println();
            this.displayHelp(System.err, swarm.hasStageConfig() ? swarm.stageConfig() : null);
            System.exit(0);
        }
        if (this.get(VERSION).booleanValue()) {
            this.displayVersion(System.err);
        }
    }

    void extraArgument(String arg) {
        this.extraArguments.add(arg);
    }

    public List<String> extraArguments() {
        return this.extraArguments;
    }

    public String[] extraArgumentsArray() {
        return this.extraArguments.toArray(new String[this.extraArguments.size()]);
    }

    void invalidArgument(String arg) {
        this.invalidArguments.add(arg);
    }

    public List<String> invalidArguments() {
        return this.invalidArguments;
    }

    public boolean hasInvalidArguments() {
        return !this.invalidArguments.isEmpty();
    }

    public static CommandLine parse(String ... args) throws Exception {
        return CommandLineParser.parse(CommandLine.defaultOptions(), args);
    }

    public static CommandLine parse(Options options, String ... args) throws Exception {
        return CommandLineParser.parse(options, args);
    }

    private static URL resolveResource(String path) {
        Path candidate = Paths.get(path, new String[0]);
        if (Files.exists(candidate, new LinkOption[0])) {
            try {
                return candidate.toUri().toURL();
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        URL yml = null;
        try {
            Module appModule = Module.getBootModuleLoader().loadModule(ModuleIdentifier.create((String)"swarm.application"));
            yml = appModule.getClassLoader().getResource(path);
            if (yml != null) {
                return yml;
            }
        }
        catch (ModuleLoadException moduleLoadException) {
            // empty catch block
        }
        yml = ClassLoader.getSystemClassLoader().getResource(path);
        return yml;
    }
}

