/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.ejb.cache.timer;

import java.lang.reflect.Method;
import java.util.function.Predicate;

public class TimeoutDescriptor
implements Predicate<Method> {
    static final String DEFAULT_METHOD_NAME = "ejbTimeout";
    static final int DEFAULT_PARAMETERS = 0;
    static final TimeoutDescriptor DEFAULT = new TimeoutDescriptor("ejbTimeout", 0);
    private final String methodName;
    private final int parameters;

    public TimeoutDescriptor(Method method) {
        this(method.getName(), method.getParameterCount());
    }

    public TimeoutDescriptor(String methodName, int parameters) {
        this.methodName = methodName;
        this.parameters = parameters;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public int getParameters() {
        return this.parameters;
    }

    @Override
    public boolean test(Method method) {
        return method.getName().equals(this.methodName) && method.getParameterCount() == this.parameters;
    }

    public boolean equals(Object object) {
        if (!(object instanceof TimeoutDescriptor)) {
            return false;
        }
        TimeoutDescriptor descriptor = (TimeoutDescriptor)object;
        return this.methodName.equals(descriptor.methodName) && this.parameters == descriptor.parameters;
    }

    public int hashCode() {
        return this.methodName.hashCode() + this.parameters;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(this.methodName).append('(');
        for (int i = 1; i <= this.parameters; ++i) {
            builder.append("arg").append(i);
            if (i >= this.parameters) continue;
            builder.append(", ");
        }
        return builder.append(')').toString();
    }
}

