/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.application.deployer;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axis2.deployment.Deployer;
import org.apache.axis2.deployment.DeploymentEngine;
import org.apache.axis2.deployment.DeploymentException;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.osgi.framework.Bundle;
import org.wso2.carbon.CarbonException;
import org.wso2.carbon.application.deployer.CarbonApplication;
import org.wso2.carbon.application.deployer.Feature;
import org.wso2.carbon.application.deployer.config.Artifact;
import org.wso2.carbon.application.deployer.config.CappFile;
import org.wso2.carbon.application.deployer.config.RegistryConfig;
import org.wso2.carbon.application.deployer.internal.ApplicationManager;
import org.wso2.carbon.application.deployer.persistence.CarbonAppPersistenceManager;
import org.wso2.carbon.base.ServerConfiguration;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.feature.mgt.core.util.ProvisioningUtils;
import org.wso2.carbon.utils.CarbonUtils;

public final class AppDeployerUtils {
    private static final Log log = LogFactory.getLog(AppDeployerUtils.class);
    private static final AppDeployerUtils INSTANCE = new AppDeployerUtils();
    private static String APP_UNZIP_DIR;
    private static final String INTERNAL_ARTIFACTS_DIR = "internal-artifacts";
    private static volatile boolean isAppDirCreated;

    private AppDeployerUtils() {
    }

    public static String getAppUnzipDir() {
        return APP_UNZIP_DIR;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void createAppDirectory() {
        if (isAppDirCreated) {
            return;
        }
        AppDeployerUtils.createDir(AppDeployerUtils.getAppUnzipDir());
        File doNotDeleteNote = new File(AppDeployerUtils.getAppUnzipDir(), "DO-NOT-DELETE.txt");
        try (PrintWriter writer = null;){
            writer = new PrintWriter(doNotDeleteNote);
            writer.println("Do not delete this folder if the Carbon server is running! Otherwise, it might cause issues for artifacts that come from CApps.");
        }
        isAppDirCreated = true;
    }

    public static String getProjectArtifactName(Bundle bundle) {
        Dictionary dictionary = bundle.getHeaders();
        if (dictionary != null) {
            Enumeration e = dictionary.keys();
            while (e.hasMoreElements()) {
                String headerValue;
                String headerKey = (String)e.nextElement();
                if (!"WSO2-Application-Name".equals(headerKey) || (headerValue = (String)dictionary.get(headerKey)) == null) continue;
                return headerValue;
            }
        }
        return null;
    }

    public static String getParentAppName(Bundle bundle) {
        Dictionary dictionary = bundle.getHeaders();
        if (dictionary != null) {
            Enumeration e = dictionary.keys();
            while (e.hasMoreElements()) {
                String headerValue;
                String headerKey = (String)e.nextElement();
                if (!"ParentApplication".equals(headerKey) || (headerValue = (String)dictionary.get(headerKey)) == null) continue;
                return headerValue;
            }
        }
        return null;
    }

    public static boolean isAppDeployer(Bundle bundle) {
        Dictionary dictionary = bundle.getHeaders();
        if (dictionary != null) {
            Enumeration e = dictionary.keys();
            while (e.hasMoreElements()) {
                String headerKey = (String)e.nextElement();
                if (!"WSO2-Application-Deployer".equals(headerKey)) continue;
                return true;
            }
        }
        return false;
    }

    public static String getAxis2Repo() {
        String axis2Repo = CarbonUtils.getAxis2Repo();
        if (axis2Repo == null) {
            axis2Repo = CarbonUtils.getCarbonRepository();
        }
        return axis2Repo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(String fromPath, String toPath) throws DeploymentException {
        File in = new File(fromPath);
        if (!in.exists()) {
            log.error((Object)("Artifact file not found at : " + fromPath));
            throw new DeploymentException("Artifact file not found at : " + fromPath);
        }
        File out = new File(toPath);
        FileInputStream fis = null;
        FileOutputStream fos = null;
        try {
            int i;
            fis = new FileInputStream(in);
            fos = new FileOutputStream(out);
            byte[] buf = new byte[10240];
            while ((i = fis.read(buf)) != -1) {
                fos.write(buf, 0, i);
            }
        }
        catch (Exception e) {
            log.error((Object)("Error occured while copying artifact : " + fromPath), (Throwable)e);
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (IOException e) {
                log.error((Object)"Error occured while closing the streams", (Throwable)e);
            }
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException e) {
                log.error((Object)"Error occured while closing the streams", (Throwable)e);
            }
        }
    }

    public static Artifact populateArtifact(OMElement artifactEle) {
        if (artifactEle == null) {
            return null;
        }
        Artifact artifact = new Artifact();
        artifact.setName(AppDeployerUtils.readAttribute(artifactEle, "name"));
        artifact.setVersion(AppDeployerUtils.readAttribute(artifactEle, "version"));
        artifact.setType(AppDeployerUtils.readAttribute(artifactEle, "type"));
        artifact.setServerRole(AppDeployerUtils.readAttribute(artifactEle, "serverRole"));
        Iterator itr = artifactEle.getChildrenWithLocalName("dependency");
        while (itr.hasNext()) {
            OMElement depElement = (OMElement)itr.next();
            Artifact.Dependency dep = new Artifact.Dependency();
            dep.setServerRole(AppDeployerUtils.readAttribute(depElement, "serverRole"));
            dep.setName(AppDeployerUtils.readAttribute(depElement, "artifact"));
            dep.setVersion(AppDeployerUtils.readAttribute(depElement, "version"));
            artifact.addDependency(dep);
        }
        OMElement subArtifactsElement = artifactEle.getFirstChildWithName(new QName("subArtifacts"));
        if (subArtifactsElement != null) {
            Iterator subArtItr = subArtifactsElement.getChildrenWithLocalName("artifact");
            while (subArtItr.hasNext()) {
                Artifact subArtifact = AppDeployerUtils.populateArtifact((OMElement)subArtItr.next());
                artifact.addSubArtifact(subArtifact);
            }
        }
        Iterator fileItr = artifactEle.getChildrenWithLocalName("file");
        while (fileItr.hasNext()) {
            OMElement fileElement = (OMElement)fileItr.next();
            CappFile tempFile = new CappFile();
            tempFile.setName(fileElement.getText());
            tempFile.setVersion(AppDeployerUtils.readAttribute(fileElement, "version"));
            artifact.addFile(tempFile);
        }
        return artifact;
    }

    public static RegistryConfig populateRegistryConfig(OMElement resourcesElement) {
        if (resourcesElement == null) {
            return null;
        }
        RegistryConfig regConfig = new RegistryConfig();
        Iterator itemItr = resourcesElement.getChildrenWithLocalName("item");
        while (itemItr.hasNext()) {
            OMElement itemElement = (OMElement)itemItr.next();
            regConfig.addResource(AppDeployerUtils.readChildText(itemElement, "path"), AppDeployerUtils.readChildText(itemElement, "file"), AppDeployerUtils.readChildText(itemElement, "registry-type"), AppDeployerUtils.readChildText(itemElement, "mediaType"));
        }
        Iterator dumpItr = resourcesElement.getChildrenWithLocalName("dump");
        while (dumpItr.hasNext()) {
            OMElement itemElement = (OMElement)dumpItr.next();
            regConfig.addDump(AppDeployerUtils.readChildText(itemElement, "path"), AppDeployerUtils.readChildText(itemElement, "file"), AppDeployerUtils.readChildText(itemElement, "registry-type"));
        }
        Iterator collectionItr = resourcesElement.getChildrenWithLocalName("collection");
        while (collectionItr.hasNext()) {
            OMElement collElement = (OMElement)collectionItr.next();
            regConfig.addCollection(AppDeployerUtils.readChildText(collElement, "path"), AppDeployerUtils.readChildText(collElement, "directory"), AppDeployerUtils.readChildText(collElement, "registry-type"));
        }
        Iterator associationItr = resourcesElement.getChildrenWithLocalName("association");
        while (associationItr.hasNext()) {
            OMElement assoElement = (OMElement)associationItr.next();
            regConfig.addAssociation(AppDeployerUtils.readChildText(assoElement, "sourcePath"), AppDeployerUtils.readChildText(assoElement, "targetPath"), AppDeployerUtils.readChildText(assoElement, "type"), AppDeployerUtils.readChildText(assoElement, "registry-type"));
        }
        return regConfig;
    }

    public static String readAttribute(OMElement element, String attName) {
        if (element == null) {
            return null;
        }
        OMAttribute temp = element.getAttribute(new QName(attName));
        if (temp != null) {
            return temp.getAttributeValue();
        }
        return null;
    }

    public static String readChildText(OMElement element, String ln) {
        return AppDeployerUtils.readChildText(element, ln, null);
    }

    public static String readChildText(OMElement element, String ln, String ns) {
        if (element == null) {
            return null;
        }
        OMElement temp = element.getFirstChildWithName(new QName(ns, ln));
        if (temp != null) {
            return temp.getText();
        }
        return null;
    }

    public static String[] readServerRoles(CarbonAppPersistenceManager capm) {
        String[] serverRoles;
        String temp = System.getProperty("serverRoles");
        if (temp != null) {
            serverRoles = temp.split(",");
        } else if (capm.areRolesOverridden()) {
            List<String> roles = capm.readServerRoles("Default");
            List<String> customRoles = capm.readServerRoles("Custom");
            ArrayList<String> serverRolesList = new ArrayList<String>(roles);
            serverRolesList.addAll(customRoles);
            serverRoles = serverRolesList.toArray(new String[serverRolesList.size()]);
        } else {
            ServerConfiguration serverConfig = ServerConfiguration.getInstance();
            serverRoles = serverConfig.getProperties("ServerRoles.Role");
        }
        return serverRoles;
    }

    public static String getArchivePathFromBundle(Bundle b) {
        String bundlePath = b.getLocation();
        bundlePath = AppDeployerUtils.formatPath(bundlePath);
        return CarbonUtils.getComponentsRepo() + File.separator + bundlePath.substring(bundlePath.lastIndexOf(47) + 1);
    }

    public static String getApplicationLocation() {
        return AppDeployerUtils.getAxis2Repo() + File.separator + "carbonapps";
    }

    public static String getFileExtension(String fileName) {
        int index = fileName.lastIndexOf(46);
        return fileName.substring(index + 1);
    }

    public static String extractCarbonApp(String appCarPath) throws CarbonException {
        AppDeployerUtils.createAppDirectory();
        String tenantId = AppDeployerUtils.getTenantIdString();
        String appCarPathFormatted = AppDeployerUtils.formatPath(appCarPath);
        String fileName = appCarPathFormatted.substring(appCarPathFormatted.lastIndexOf(47) + 1);
        String dest = AppDeployerUtils.getAppUnzipDir() + File.separator + tenantId + File.separator + System.currentTimeMillis() + fileName + File.separator;
        AppDeployerUtils.createDir(dest);
        try {
            AppDeployerUtils.extract(appCarPath, dest);
        }
        catch (IOException e) {
            throw new CarbonException("Error while extracting Carbon Application : " + fileName, (Throwable)e);
        }
        return dest;
    }

    public static String createAppExtractionPath(String parentAppName) {
        AppDeployerUtils.createAppDirectory();
        String tenantId = AppDeployerUtils.getTenantIdString();
        String parentPath = AppDeployerUtils.getAppUnzipDir() + File.separator + tenantId + File.separator + System.currentTimeMillis() + parentAppName + File.separator;
        AppDeployerUtils.createDir(parentPath);
        return parentPath;
    }

    public static String extractAppArtifact(String artifactPath, String parentPath) throws CarbonException {
        AppDeployerUtils.createDir(parentPath + INTERNAL_ARTIFACTS_DIR);
        String fileName = artifactPath.substring(artifactPath.lastIndexOf(47) + 1);
        String dest = parentPath + INTERNAL_ARTIFACTS_DIR + File.separator + fileName.substring(0, fileName.lastIndexOf(46)) + File.separator;
        AppDeployerUtils.createDir(dest);
        try {
            AppDeployerUtils.extract(artifactPath, dest);
        }
        catch (IOException e) {
            throw new CarbonException("Error while extracting cApp artifact : " + fileName, (Throwable)e);
        }
        return dest;
    }

    public static void attachArtifactToOwnerApp(String fileName, String artifactType, String runtimeObjectName, int tenantId) {
        if (fileName == null || artifactType == null || tenantId == -1) {
            return;
        }
        ApplicationManager appManager = ApplicationManager.getInstance();
        for (CarbonApplication carbonApp : appManager.getCarbonApps(String.valueOf(tenantId))) {
            Artifact appArtifact = carbonApp.getAppConfig().getApplicationArtifact();
            for (Artifact.Dependency dep : appArtifact.getDependencies()) {
                if (dep.getArtifact() == null) continue;
                Artifact depArtifact = dep.getArtifact();
                for (CappFile file : depArtifact.getFiles()) {
                    if (!file.getName().equals(fileName) || !depArtifact.getType().equals(artifactType)) continue;
                    depArtifact.setRuntimeObjectName(runtimeObjectName);
                }
            }
        }
    }

    public static String formatPath(String path) {
        String pathformatted = path.replaceAll("\\b\\s+\\b", "%20");
        try {
            pathformatted = URLDecoder.decode(pathformatted, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            log.error((Object)("Unsupported Encoding in the path :" + pathformatted));
        }
        return pathformatted.replace('\\', '/');
    }

    public static boolean hasLibs(List<Artifact.Dependency> deps) {
        for (Artifact.Dependency dep : deps) {
            Artifact artifact = dep.getArtifact();
            if (artifact == null) continue;
            if (artifact.getType().startsWith("lib/")) {
                return true;
            }
            if (!AppDeployerUtils.hasLibs(artifact.getDependencies())) continue;
            return true;
        }
        return false;
    }

    public static boolean areAllFeaturesInstalled(List<Feature> features) {
        for (Feature feature : features) {
            IQuery query = QueryUtil.createIUQuery((String)feature.getId(), (VersionRange)feature.getVersionRange());
            IInstallableUnit[] installableUnits = (IInstallableUnit[])ProvisioningUtils.getProfile().query(query, null).toArray(IInstallableUnit.class);
            if (installableUnits != null && installableUnits.length != 0) continue;
            return false;
        }
        return true;
    }

    public static Map<String, Boolean> buildAcceptanceList(Map<String, List<Feature>> features) {
        HashMap<String, Boolean> acceptanceList = new HashMap<String, Boolean>();
        for (Map.Entry<String, List<Feature>> entry : features.entrySet()) {
            if (entry.getValue() == null) continue;
            acceptanceList.put(entry.getKey(), AppDeployerUtils.areAllFeaturesInstalled(entry.getValue()));
        }
        return acceptanceList;
    }

    public static Map<String, List<Feature>> readRequiredFeaturs(OMElement featureSets) {
        if (featureSets == null) {
            return null;
        }
        HashMap<String, List<Feature>> reqFeatureMap = new HashMap<String, List<Feature>>();
        Iterator itr = featureSets.getChildrenWithLocalName("featureSet");
        while (itr.hasNext()) {
            OMElement fsElement = (OMElement)itr.next();
            String artifactType = AppDeployerUtils.readAttribute(fsElement, "artifactType");
            Iterator featureItr = fsElement.getChildrenWithLocalName("feature");
            ArrayList<Feature> featureList = new ArrayList<Feature>();
            while (featureItr.hasNext()) {
                OMElement featureElement = (OMElement)featureItr.next();
                Feature requiredFeature = new Feature();
                requiredFeature.setId(AppDeployerUtils.readAttribute(featureElement, "id"));
                requiredFeature.setVersionRange(AppDeployerUtils.readAttribute(featureElement, "version"));
                featureList.add(requiredFeature);
            }
            reqFeatureMap.put(artifactType, featureList);
        }
        return reqFeatureMap;
    }

    @Deprecated
    public static String getTenantIdString(AxisConfiguration axisConfig) {
        PrivilegedCarbonContext carbonContext = PrivilegedCarbonContext.getThreadLocalCarbonContext();
        return String.valueOf(carbonContext.getTenantId());
    }

    public static String getTenantIdString() {
        PrivilegedCarbonContext carbonContext = PrivilegedCarbonContext.getThreadLocalCarbonContext();
        return String.valueOf(carbonContext.getTenantId());
    }

    @Deprecated
    public static int getTenantId(AxisConfiguration axisConfig) {
        PrivilegedCarbonContext carbonContext = PrivilegedCarbonContext.getThreadLocalCarbonContext();
        return carbonContext.getTenantId();
    }

    public static int getTenantId() {
        PrivilegedCarbonContext carbonContext = PrivilegedCarbonContext.getThreadLocalCarbonContext();
        return carbonContext.getTenantId();
    }

    public static String getTenantIdLogString(int tenantId) {
        return tenantId != -1 && tenantId != -1234 ? " {tenant-" + tenantId + "}" : " {super-tenant}";
    }

    public static String computeResourcePath(String basePath, String resourceName) {
        String fullResourcePath = basePath.endsWith("/") ? basePath + resourceName : basePath + "/" + resourceName;
        return fullResourcePath;
    }

    private static void extract(String sourcePath, String destPath) throws IOException {
        ZipFile zipFile = new ZipFile(sourcePath);
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            if (entry.getName().startsWith("META-INF/")) continue;
            if (entry.isDirectory()) {
                AppDeployerUtils.createDir(destPath + entry.getName());
                continue;
            }
            AppDeployerUtils.copyInputStream(zipFile.getInputStream(entry), new BufferedOutputStream(new FileOutputStream(destPath + entry.getName())));
        }
        zipFile.close();
    }

    public static String readMediaType(String artifactExtractedPath, String fileName) {
        if (artifactExtractedPath == null || fileName == null) {
            return null;
        }
        String mediaType = null;
        String metaFilePath = artifactExtractedPath + File.separator + "resources" + File.separator + ".meta" + File.separator + "~" + fileName + ".xml";
        File metaFile = new File(metaFilePath);
        if (metaFile.exists()) {
            try (FileInputStream fis = new FileInputStream(metaFile);){
                OMElement docElement = new StAXOMBuilder((InputStream)fis).getDocumentElement();
                OMElement mediaTypeElement = docElement.getFirstChildWithName(new QName("mediaType"));
                if (mediaTypeElement != null) {
                    mediaType = mediaTypeElement.getText();
                }
            }
            catch (Exception e) {
                log.error((Object)("Error while reading meta file : " + metaFilePath), (Throwable)e);
            }
        }
        return mediaType;
    }

    public static void createDir(String path) {
        File temp = new File(path);
        if (!temp.exists() && !temp.mkdirs()) {
            log.error((Object)("Error while creating directory : " + path));
            return;
        }
    }

    private static void copyInputStream(InputStream in, OutputStream out) throws IOException {
        int len;
        byte[] buffer = new byte[40960];
        while ((len = in.read(buffer)) >= 0) {
            out.write(buffer, 0, len);
        }
        in.close();
        out.close();
    }

    public static Deployer getArtifactDeployer(AxisConfiguration axisConfig, String directory, String extension) {
        DeploymentEngine deploymentEngine = (DeploymentEngine)axisConfig.getConfigurator();
        return deploymentEngine.getDeployer(directory, extension);
    }

    static {
        isAppDirCreated = false;
        String javaTmpDir = System.getProperty("java.io.tmpdir");
        APP_UNZIP_DIR = javaTmpDir.endsWith(File.separator) ? javaTmpDir + "carbonapps" : javaTmpDir + File.separator + "carbonapps";
    }
}

