/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.application.deployer.handler;

import java.io.File;
import java.util.List;
import java.util.Map;
import org.apache.axis2.deployment.Deployer;
import org.apache.axis2.deployment.DeploymentEngine;
import org.apache.axis2.deployment.DeploymentException;
import org.apache.axis2.deployment.repository.util.DeploymentFileData;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.wso2.carbon.application.deployer.AppDeployerUtils;
import org.wso2.carbon.application.deployer.CarbonApplication;
import org.wso2.carbon.application.deployer.config.Artifact;
import org.wso2.carbon.application.deployer.config.CappFile;
import org.wso2.carbon.application.deployer.handler.AppDeploymentHandler;
import org.wso2.carbon.application.deployer.internal.AppDeployerServiceComponent;

public class DefaultAppDeployer
implements AppDeploymentHandler {
    private static final Log log = LogFactory.getLog(DefaultAppDeployer.class);
    public static final String AAR_TYPE = "service/axis2";
    public static final String DS_TYPE = "service/dataservice";
    public static final String BUNDLE_TYPE = "bundle";
    public static final String MEDIATOR_TYPE = "lib/synapse/mediator";
    public static final String DS_DIR = "dataservices";
    private Map<String, Boolean> acceptanceList = null;

    @Override
    public void deployArtifacts(CarbonApplication carbonApp, AxisConfiguration axisConfig) throws DeploymentException {
        List<Artifact.Dependency> dependencies = carbonApp.getAppConfig().getApplicationArtifact().getDependencies();
        this.deployRecursively(dependencies, axisConfig);
    }

    @Override
    public void undeployArtifacts(CarbonApplication carbonApp, AxisConfiguration axisConfig) {
        List<Artifact.Dependency> dependencies = carbonApp.getAppConfig().getApplicationArtifact().getDependencies();
        this.undeployRecursively(dependencies, axisConfig);
    }

    private void installBundle(String bundlePath) {
        String bundlePathFormatted = this.getFormattedBundlePath(bundlePath);
        log.info((Object)("OSGi bundle in " + bundlePathFormatted + " location is about to be installed to Carbon Server."));
        try {
            Bundle bundle = AppDeployerServiceComponent.getBundleContext().installBundle(bundlePathFormatted);
            if (bundle != null) {
                log.info((Object)("OSGi bundle " + bundle.getSymbolicName() + " installed to Carbon Server."));
                bundle.start();
                log.info((Object)("OSGi bundle " + bundle.getSymbolicName() + " successfully started on Carbon Server."));
            }
        }
        catch (BundleException e) {
            log.error((Object)("Error while installing bundle : " + bundlePathFormatted), (Throwable)e);
        }
    }

    private void uninstallBundle(String bundlePath) {
        String bundlePathFormatted = this.getFormattedBundlePath(bundlePath);
        log.info((Object)("OSGi bundle in " + bundlePathFormatted + " location is about to be uninstalled from Carbon Server."));
        try {
            Bundle bundle = AppDeployerServiceComponent.getBundleContext().getBundle(bundlePathFormatted);
            if (bundle != null) {
                log.info((Object)("Uninstalling the OSGi bundle " + bundle.getSymbolicName() + " from Carbon server."));
                bundle.uninstall();
                log.info((Object)("Sucessfully uninstalled the OSGi bundle " + bundle.getSymbolicName() + " from Carbon server."));
            }
        }
        catch (BundleException e) {
            log.error((Object)("Error while uninstalling bundle : " + bundlePathFormatted), (Throwable)e);
        }
    }

    private String getFormattedBundlePath(String bundlePath) {
        String bundlePathFormatted = AppDeployerUtils.formatPath(bundlePath);
        bundlePathFormatted = bundlePathFormatted.startsWith("/") ? "file://" + bundlePathFormatted : "file:///" + bundlePathFormatted;
        return bundlePathFormatted;
    }

    private void deployRecursively(List<Artifact.Dependency> deps, AxisConfiguration axisConfig) throws DeploymentException {
        for (Artifact.Dependency dependency : deps) {
            Artifact artifact = dependency.getArtifact();
            if (artifact == null) continue;
            if (!this.isAccepted(artifact.getType())) {
                log.warn((Object)("Can't deploy artifact : " + artifact.getName() + " of type : " + artifact.getType() + ". Required features are not installed in the system"));
                continue;
            }
            List<CappFile> files = artifact.getFiles();
            if (files.size() != 1) {
                log.error((Object)(artifact.getType() + " type must have a single file to " + "be deployed. But " + files.size() + " files found."));
                continue;
            }
            artifact.setDeploymentStatus("Pending");
            String fileName = artifact.getFiles().get(0).getName();
            String artifactPath = artifact.getExtractedPath() + File.separator + fileName;
            Deployer deployer = this.getDeployer(axisConfig, artifact.getType());
            if (deployer != null) {
                try {
                    deployer.deploy(new DeploymentFileData(new File(artifactPath), deployer));
                    artifact.setDeploymentStatus("Deployed");
                }
                catch (DeploymentException e) {
                    artifact.setDeploymentStatus("Failed");
                    throw e;
                }
            } else {
                if (MEDIATOR_TYPE.equals(artifact.getType())) continue;
                if ((artifact.getType().startsWith("lib/") || BUNDLE_TYPE.equals(artifact.getType())) && AppDeployerUtils.getTenantId() == -1234) {
                    this.installBundle(artifactPath);
                    artifact.setRuntimeObjectName(fileName);
                }
            }
            this.deployRecursively(artifact.getDependencies(), axisConfig);
        }
    }

    private boolean isAccepted(String serviceType) {
        Boolean acceptance;
        if (this.acceptanceList == null) {
            this.acceptanceList = AppDeployerUtils.buildAcceptanceList(AppDeployerServiceComponent.getRequiredFeatures());
        }
        return (acceptance = this.acceptanceList.get(serviceType)) == null || acceptance != false;
    }

    private void undeployRecursively(List<Artifact.Dependency> deps, AxisConfiguration axisConfig) {
        for (Artifact.Dependency dependency : deps) {
            Artifact artifact = dependency.getArtifact();
            if (artifact == null) continue;
            List<CappFile> files = artifact.getFiles();
            if (files.size() != 1) {
                log.error((Object)(artifact.getType() + " type must have a single file. But " + files.size() + " files found."));
                continue;
            }
            String fileName = artifact.getFiles().get(0).getName();
            String artifactPath = artifact.getExtractedPath() + File.separator + fileName;
            Deployer deployer = this.getDeployer(axisConfig, artifact.getType());
            if (deployer != null && "Deployed".equals(artifact.getDeploymentStatus())) {
                try {
                    deployer.undeploy(artifactPath);
                    artifact.setDeploymentStatus("Pending");
                    File artifactFile = new File(artifactPath);
                    if (artifactFile.exists() && !artifactFile.delete()) {
                        log.warn((Object)("Couldn't delete artifact file : " + artifactPath));
                    }
                }
                catch (DeploymentException e) {
                    artifact.setDeploymentStatus("Failed");
                    log.error((Object)("Error while undeploying artifact : " + artifactPath), (Throwable)e);
                }
            } else {
                if (MEDIATOR_TYPE.equals(artifact.getType()) || artifact.getType() == null || !artifact.getType().startsWith("lib/") && !BUNDLE_TYPE.equals(artifact.getType()) || AppDeployerUtils.getTenantId() != -1234) continue;
                this.uninstallBundle(artifactPath);
            }
            this.undeployRecursively(artifact.getDependencies(), axisConfig);
        }
    }

    private Deployer getDeployer(AxisConfiguration axisConfig, String artifactType) {
        DeploymentEngine deploymentEngine = (DeploymentEngine)axisConfig.getConfigurator();
        Deployer deployer = null;
        if (AAR_TYPE.equals(artifactType)) {
            deployer = deploymentEngine.getDeployer("axis2services", "aar");
            if (deployer == null) {
                deployer = deploymentEngine.getServiceDeployer();
            }
        } else if (DS_TYPE.equals(artifactType)) {
            deployer = deploymentEngine.getDeployer(DS_DIR, "dbs");
        } else if ("carbon/application".equals(artifactType)) {
            deployer = deploymentEngine.getDeployer("carbonapps", "car");
        }
        return deployer;
    }
}

