/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.base;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.StringTokenizer;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xerces.util.SecurityManager;
import org.w3c.dom.Element;
import org.wso2.carbon.base.CarbonBaseUtils;
import org.wso2.carbon.base.ServerConfigurationException;
import org.wso2.carbon.base.api.ServerConfigurationService;
import org.wso2.carbon.securevault.SecretManagerInitializer;
import org.wso2.securevault.SecretResolver;
import org.wso2.securevault.SecretResolverFactory;

public class ServerConfiguration
implements ServerConfigurationService {
    private static final List<String> ALLOWED_CLASSES = Arrays.asList(ServerConfigurationService.class.getName(), "org.wso2.carbon.utils.CarbonUtils", "org.wso2.carbon.registry.core.utils.RegistryUtils", "org.wso2.carbon.utils.logging.TenantAwarePatternLayout$TenantAwarePatternParser$ServiceNamePatternConverter");
    public static final String AXIS2_CONFIG_REPO_LOCATION = "Axis2Config.RepositoryLocation";
    public static final String HTTP_PORT = "HTTP.Port";
    private static final int ENTITY_EXPANSION_LIMIT = 0;
    public static final String COMMAND_LISTENER_PORT = "CommandListener.Port";
    private static Log log = LogFactory.getLog(ServerConfigurationService.class);
    private Map<String, List<String>> configuration = new HashMap<String, List<String>>();
    private boolean isInitialized;
    private boolean isLoadedConfigurationPreserved = false;
    private String documentXML;
    private SecretResolver secretResolver;
    private static ServerConfiguration instance = new ServerConfiguration();

    public static ServerConfiguration getInstance() {
        CarbonBaseUtils.checkSecurity();
        return instance;
    }

    private ServerConfiguration() {
    }

    public synchronized void init(InputStream xmlInputStream) throws ServerConfigurationException {
        if (this.isInitialized) {
            return;
        }
        if (!this.isLoadedConfigurationPreserved) {
            this.configuration.clear();
        }
        try {
            OMElement documentElement = new StAXOMBuilder(xmlInputStream).getDocumentElement();
            SecretManagerInitializer secretManagerInitializer = new SecretManagerInitializer();
            secretManagerInitializer.init();
            this.secretResolver = SecretResolverFactory.create((OMElement)documentElement, (boolean)true);
            Stack<String> nameStack = new Stack<String>();
            this.readChildElements(documentElement, nameStack);
            this.isInitialized = true;
            this.isLoadedConfigurationPreserved = false;
            this.documentXML = documentElement.toStringWithConsume();
        }
        catch (XMLStreamException e) {
            log.fatal((Object)"Problem in parsing the configuration file ", (Throwable)e);
            throw new ServerConfigurationException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void init(String configurationXMLLocation) throws ServerConfigurationException {
        if (this.isInitialized) {
            return;
        }
        if (configurationXMLLocation == null) {
            String configPath = System.getProperty("carbon.config.dir.path");
            if (configPath == null) {
                configurationXMLLocation = Paths.get("conf", "carbon.xml").toString();
            } else {
                String relativeConfDirPath = Paths.get(System.getProperty("carbon.home"), new String[0]).relativize(Paths.get(configPath, new String[0])).toString();
                configurationXMLLocation = Paths.get(relativeConfDirPath, "carbon.xml").toString();
            }
        }
        InputStream xmlInputStream = null;
        try {
            try {
                URL urlXMLLocation = new URL(configurationXMLLocation);
                xmlInputStream = urlXMLLocation.openStream();
            }
            catch (MalformedURLException e) {
                File f = new File(configurationXMLLocation);
                try {
                    xmlInputStream = new FileInputStream(f);
                }
                catch (FileNotFoundException e1) {
                    ClassLoader cl = ServerConfigurationService.class.getClassLoader();
                    xmlInputStream = cl.getResourceAsStream(configurationXMLLocation);
                    if (xmlInputStream == null) {
                        String msg = "Configuration File cannot be loaded from " + configurationXMLLocation;
                        log.fatal((Object)msg, (Throwable)e1);
                        throw new ServerConfigurationException(msg, e1);
                    }
                }
            }
            catch (IOException e) {
                log.fatal((Object)("Configuration File cannot be loaded from " + configurationXMLLocation), (Throwable)e);
                throw new ServerConfigurationException(e);
            }
            this.init(xmlInputStream);
        }
        finally {
            if (xmlInputStream != null) {
                try {
                    xmlInputStream.close();
                }
                catch (IOException e) {
                    log.warn((Object)"Cannot close input stream", (Throwable)e);
                }
            }
        }
    }

    public synchronized void forceInit(InputStream xmlInputStream) throws ServerConfigurationException {
        this.isInitialized = false;
        this.init(xmlInputStream);
    }

    public synchronized void forceInit(String configurationXMLLocation) throws ServerConfigurationException {
        this.isInitialized = false;
        this.init(configurationXMLLocation);
    }

    public synchronized void forceInit(String configurationXMLLocation, boolean isLoadedConfigurationPreserved) throws ServerConfigurationException {
        this.isInitialized = false;
        this.isLoadedConfigurationPreserved = isLoadedConfigurationPreserved;
        this.init(configurationXMLLocation);
    }

    private void readChildElements(OMElement serverConfig, Stack<String> nameStack) {
        Iterator childElements = serverConfig.getChildElements();
        while (childElements.hasNext()) {
            OMElement element = (OMElement)childElements.next();
            nameStack.push(element.getLocalName());
            if (this.elementHasText(element)) {
                String key = this.getKey(nameStack);
                String value = this.replaceSystemProperty(element.getText());
                if (this.isProtectedToken(key)) {
                    value = this.getProtectedValue(key);
                }
                this.addToConfiguration(key, value);
            }
            this.readChildElements(element, nameStack);
            nameStack.pop();
        }
    }

    private void addToConfiguration(String key, String value) {
        List<String> list = this.configuration.get(key);
        if (list == null) {
            list = new ArrayList<String>();
            list.add(value);
            this.configuration.put(key, list);
        } else if (!list.contains(value)) {
            list.add(value);
        }
    }

    private void overrideConfiguration(String key, String value) {
        ArrayList<String> list = new ArrayList<String>();
        list.add(value);
        this.configuration.put(key, list);
    }

    private String replaceSystemProperty(String text) {
        int indexOfClosingBrace;
        int indexOfStartingChars = -1;
        while (indexOfStartingChars < text.indexOf("${") && (indexOfStartingChars = text.indexOf("${")) != -1 && (indexOfClosingBrace = text.indexOf(125)) != -1) {
            String sysProp = text.substring(indexOfStartingChars + 2, indexOfClosingBrace);
            String propValue = System.getProperty(sysProp);
            if (propValue == null) {
                propValue = System.getenv(sysProp);
            }
            if (propValue != null) {
                text = text.substring(0, indexOfStartingChars) + propValue + text.substring(indexOfClosingBrace + 1);
            }
            if (!sysProp.equals("carbon.home") || propValue == null || !propValue.equals(".")) continue;
            text = new File(".").getAbsolutePath() + File.separator + text;
        }
        return text;
    }

    @Override
    public void setConfigurationProperty(String key, String value) {
        this.addToConfiguration(key, value);
        StringTokenizer tokenizer = new StringTokenizer(key, ".");
        OMElement ele = this.getDocumentElementInternal();
        String token = "";
        while (tokenizer.hasMoreTokens()) {
            token = tokenizer.nextToken();
            if (ele == null) break;
            ele = ele.getFirstChildWithName(new QName("", token, ""));
        }
        if (ele != null) {
            ele.getFirstOMChild().detach();
            ele.setText(token);
        }
    }

    @Override
    public void overrideConfigurationProperty(String key, String value) {
        this.overrideConfiguration(key, value);
        StringTokenizer tokenizer = new StringTokenizer(key, ".");
        OMElement ele = this.getDocumentElementInternal();
        String token = "";
        while (tokenizer.hasMoreTokens()) {
            token = tokenizer.nextToken();
            if (ele == null) break;
            ele = ele.getFirstChildWithName(new QName("", token, ""));
        }
        if (ele != null) {
            ele.getFirstOMChild().detach();
            ele.setText(token);
        }
    }

    private String getKey(Stack<String> nameStack) {
        StringBuffer key = new StringBuffer();
        for (int i = 0; i < nameStack.size(); ++i) {
            String name = (String)nameStack.elementAt(i);
            key.append(name).append(".");
        }
        key.deleteCharAt(key.lastIndexOf("."));
        return key.toString();
    }

    private boolean elementHasText(OMElement element) {
        String text = element.getText();
        return text != null && text.trim().length() != 0;
    }

    @Override
    public String getFirstProperty(String key) {
        List<String> value = this.configuration.get(key);
        if (value == null) {
            return null;
        }
        return value.get(0);
    }

    @Override
    public String[] getProperties(String key) {
        List<String> values = this.configuration.get(key);
        if (values == null) {
            return new String[0];
        }
        return values.toArray(new String[values.size()]);
    }

    @Override
    public Element getDocumentElement() {
        try {
            return ServerConfiguration.toDOM(this.getDocumentElementInternal());
        }
        catch (Exception e) {
            log.error((Object)"Cannot get ServerConfiguration document element", (Throwable)e);
            return null;
        }
    }

    private OMElement getDocumentElementInternal() {
        try {
            return new StAXOMBuilder((InputStream)new ByteArrayInputStream(this.documentXML.getBytes())).getDocumentElement();
        }
        catch (XMLStreamException e) {
            log.error((Object)"Cannot get ServerConfiguration document element", (Throwable)e);
            return null;
        }
    }

    private static Element toDOM(OMElement element) throws Exception {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        element.serialize((OutputStream)outputStream);
        ByteArrayInputStream inputStream = new ByteArrayInputStream(outputStream.toByteArray());
        DocumentBuilderFactory factory = ServerConfiguration.getSecuredDocumentBuilder();
        factory.setNamespaceAware(true);
        return factory.newDocumentBuilder().parse(inputStream).getDocumentElement();
    }

    private static DocumentBuilderFactory getSecuredDocumentBuilder() {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        dbf.setXIncludeAware(false);
        dbf.setExpandEntityReferences(false);
        try {
            dbf.setFeature("http://xml.org/sax/features/external-general-entities", false);
            dbf.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            dbf.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        }
        catch (ParserConfigurationException e) {
            log.error((Object)"Failed to load XML Processor Feature external-general-entities or external-parameter-entities or nonvalidating/load-external-dtd");
        }
        SecurityManager securityManager = new SecurityManager();
        securityManager.setEntityExpansionLimit(0);
        dbf.setAttribute("http://apache.org/xml/properties/security-manager", securityManager);
        return dbf;
    }

    protected boolean isProtectedToken(String key) {
        return this.secretResolver != null && this.secretResolver.isInitialized() && this.secretResolver.isTokenProtected("Carbon." + key);
    }

    protected String getProtectedValue(String key) {
        return this.secretResolver.resolve("Carbon." + key);
    }
}

