/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.ui;

import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.wso2.carbon.authenticator.proxy.AuthenticationAdminClient;
import org.wso2.carbon.core.common.AuthenticationException;
import org.wso2.carbon.ui.AbstractCarbonUIAuthenticator;
import org.wso2.carbon.ui.CarbonUIUtil;
import org.wso2.carbon.ui.DefaultAuthenticatorCredentials;
import org.wso2.carbon.ui.util.CarbonUIAuthenticationUtil;
import org.wso2.carbon.utils.CarbonUtils;

public class BasicAuthUIAuthenticator
extends AbstractCarbonUIAuthenticator {
    private static final String AUTHENTICATOR_NAME = "BasicAuthUIAuthenticator";

    @Override
    public boolean canHandle(HttpServletRequest request) {
        String userName = request.getParameter("username");
        String password = request.getParameter("password");
        if (CarbonUtils.isRunningOnLocalTransportMode()) {
            return false;
        }
        if (userName != null && password != null) {
            return true;
        }
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!cookie.getName().equals("wso2.carbon.rememberme")) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void authenticate(HttpServletRequest request) throws AuthenticationException {
        String userName = request.getParameter("username");
        String password = request.getParameter("password");
        String value = request.getParameter("rememberMe");
        boolean isRememberMe = false;
        if (userName == null || password == null) {
            throw new AuthenticationException("Invalid username or password provided.");
        }
        if (value != null && value.equals("rememberMe")) {
            isRememberMe = true;
        }
        String userNameWithDomain = userName;
        String domainName = (String)request.getAttribute("tenantDomain");
        if (domainName != null) {
            userNameWithDomain = userNameWithDomain + "@" + domainName;
        }
        if (userNameWithDomain != null) {
            userNameWithDomain = userNameWithDomain.trim();
        }
        DefaultAuthenticatorCredentials credentials = new DefaultAuthenticatorCredentials(userNameWithDomain, password);
        this.handleSecurity(credentials, isRememberMe, request);
    }

    @Override
    public void authenticateWithCookie(HttpServletRequest request) throws AuthenticationException {
        Cookie[] cookies;
        for (Cookie cookie : cookies = request.getCookies()) {
            if (!cookie.getName().equals("wso2.carbon.rememberme")) continue;
            DefaultAuthenticatorCredentials credentials = new DefaultAuthenticatorCredentials(null, null);
            this.handleSecurity(credentials, true, request);
        }
    }

    @Override
    public String doAuthentication(Object credentials, boolean isRememberMe, ServiceClient client, HttpServletRequest request) throws AuthenticationException {
        DefaultAuthenticatorCredentials defaultCredentials = (DefaultAuthenticatorCredentials)credentials;
        if (isRememberMe && defaultCredentials.getUserName() == null && defaultCredentials.getPassword() == null) {
            Cookie[] cookies = request.getCookies();
            if (cookies != null) {
                for (Cookie cookie : cookies) {
                    if (!cookie.getName().equals("wso2.carbon.rememberme")) continue;
                    CarbonUIAuthenticationUtil.setCookieHeaders(cookie, client);
                    String cookieValue = cookie.getValue();
                    return BasicAuthUIAuthenticator.getUserNameFromCookie(cookieValue);
                }
            }
        } else {
            CarbonUtils.setBasicAccessSecurityHeaders((String)defaultCredentials.getUserName(), (String)defaultCredentials.getPassword(), (boolean)isRememberMe, (ServiceClient)client);
            return defaultCredentials.getUserName();
        }
        throw new AuthenticationException("Invalid user credentials.");
    }

    @Override
    public void handleRememberMe(Map transportHeaders, HttpServletRequest httpServletRequest) throws AuthenticationException {
        if (transportHeaders != null) {
            String cookieValue = (String)transportHeaders.get("RememberMeCookieValue");
            String cookieAge = (String)transportHeaders.get("RememberMeCookieAge");
            if (cookieValue == null || cookieAge == null) {
                throw new AuthenticationException("Unable to load remember me date from response. Cookie value or cookie age or both are null");
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Cookie value returned " + cookieValue + " cookie age " + cookieAge));
            }
            httpServletRequest.setAttribute("wso2.carbon.rememberme.value", (Object)cookieValue);
            httpServletRequest.setAttribute("wso2.carbon.rememberme.age", (Object)cookieAge);
        }
    }

    @Override
    public void unauthenticate(Object object) throws Exception {
        try {
            this.getAuthenticationAdminCient((HttpServletRequest)object).logout();
        }
        catch (AxisFault axisFault) {
            String msg = "Failed to authenticate ";
            log.error((Object)msg, (Throwable)axisFault);
            throw new Exception(msg, axisFault);
        }
    }

    protected AuthenticationAdminClient getAuthenticationAdminCient(HttpServletRequest request) throws AxisFault {
        HttpSession session = request.getSession();
        ServletContext servletContext = session.getServletContext();
        String backendServerURL = request.getParameter("backendURL");
        if (backendServerURL == null) {
            backendServerURL = CarbonUIUtil.getServerURL(servletContext, request.getSession());
        }
        session.setAttribute("ServerURL", (Object)backendServerURL);
        ConfigurationContext configContext = (ConfigurationContext)servletContext.getAttribute("ConfigurationContext");
        String cookie = (String)session.getAttribute("wso2carbon.admin.service.cookie");
        return new AuthenticationAdminClient(configContext, backendServerURL, cookie, session, true);
    }

    @Override
    public String getAuthenticatorName() {
        return AUTHENTICATOR_NAME;
    }
}

