/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.ui;

import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.ServiceClient;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.authenticator.proxy.AuthenticationAdminClient;
import org.wso2.carbon.authenticator.stub.RememberMeData;
import org.wso2.carbon.core.common.AuthenticationException;
import org.wso2.carbon.ui.BasicAuthUIAuthenticator;
import org.wso2.carbon.ui.DefaultAuthenticatorCredentials;
import org.wso2.carbon.utils.CarbonUtils;

public class DefaultCarbonAuthenticator
extends BasicAuthUIAuthenticator {
    protected static final Log log = LogFactory.getLog(DefaultCarbonAuthenticator.class);
    private static final String AUTHENTICATOR_NAME = "DefaultCarbonAuthenticator";

    @Override
    public boolean canHandle(HttpServletRequest request) {
        String userName = request.getParameter("username");
        String password = request.getParameter("password");
        if (!CarbonUtils.isRunningOnLocalTransportMode()) {
            return false;
        }
        if (userName != null && password != null) {
            return true;
        }
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!cookie.getName().equals("wso2.carbon.rememberme")) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public String doAuthentication(Object credentials, boolean isRememberMe, ServiceClient client, HttpServletRequest request) throws AuthenticationException {
        DefaultAuthenticatorCredentials defaultCredentials = (DefaultAuthenticatorCredentials)credentials;
        try {
            AuthenticationAdminClient authClient = this.getAuthenticationAdminCient(request);
            boolean isAutenticated = false;
            if (isRememberMe && defaultCredentials.getUserName() != null && defaultCredentials.getPassword() != null) {
                RememberMeData rememberMe = authClient.loginWithRememberMeOption(defaultCredentials.getUserName(), defaultCredentials.getPassword(), "127.0.0.1");
                isAutenticated = rememberMe.getAuthenticated();
                if (isAutenticated) {
                    request.setAttribute("wso2.carbon.rememberme.value", (Object)rememberMe.getValue());
                    request.setAttribute("wso2.carbon.rememberme.age", (Object)new Integer(rememberMe.getMaxAge()).toString());
                    return defaultCredentials.getUserName();
                }
            } else if (isRememberMe) {
                Cookie[] cookies = request.getCookies();
                if (cookies != null) {
                    for (Cookie cookie : cookies) {
                        if (!cookie.getName().equals("wso2.carbon.rememberme") || !(isAutenticated = authClient.loginWithRememberMeCookie(cookie.getValue()))) continue;
                        String cookieValue = cookie.getValue();
                        return DefaultCarbonAuthenticator.getUserNameFromCookie(cookieValue);
                    }
                }
            } else {
                isAutenticated = authClient.login(defaultCredentials.getUserName(), defaultCredentials.getPassword(), "127.0.0.1");
                if (isAutenticated) {
                    return defaultCredentials.getUserName();
                }
            }
            throw new AuthenticationException("Invalid user credentials.");
        }
        catch (AxisFault e) {
            throw new AuthenticationException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void unauthenticate(Object object) throws Exception {
        super.unauthenticate(object);
    }

    @Override
    public String getAuthenticatorName() {
        return AUTHENTICATOR_NAME;
    }

    @Override
    public void handleRememberMe(Map transportHeaders, HttpServletRequest httpServletRequest) throws AuthenticationException {
    }
}

