/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.ui;

import java.net.URL;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.wso2.carbon.ui.util.UIResourceProvider;

public class UIResourceRegistry
implements UIResourceProvider,
ServiceListener {
    private UIResourceProvider defaultUIResourceProvider;
    private Set<UIResourceProvider> resourceProviderSet;
    private BundleContext bundleContext;

    public void initialize(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
        this.resourceProviderSet = new HashSet<UIResourceProvider>();
        try {
            bundleContext.addServiceListener((ServiceListener)this, "(objectClass=" + UIResourceProvider.class.getName() + ")");
            ServiceReference[] references = bundleContext.getServiceReferences((String)null, "(objectClass=" + UIResourceProvider.class.getName() + ")");
            if (references != null && references.length > 0) {
                for (ServiceReference reference : references) {
                    UIResourceProvider uiResourceProvider = (UIResourceProvider)bundleContext.getService(reference);
                    if (uiResourceProvider == null) continue;
                    this.resourceProviderSet.add(uiResourceProvider);
                }
            }
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            // empty catch block
        }
    }

    @Override
    public URL getUIResource(String path) {
        URL url;
        block1: {
            UIResourceProvider resourceProvider;
            url = this.defaultUIResourceProvider.getUIResource(path);
            if (url != null) break block1;
            Iterator<UIResourceProvider> i$ = this.resourceProviderSet.iterator();
            while (i$.hasNext() && (url = (resourceProvider = i$.next()).getUIResource(path)) == null) {
            }
        }
        return url;
    }

    @Override
    public Set<String> getUIResourcePaths(String path) {
        Set<String> resourcePathSet;
        block1: {
            UIResourceProvider resourceProvider;
            resourcePathSet = this.defaultUIResourceProvider.getUIResourcePaths(path);
            if (!resourcePathSet.isEmpty()) break block1;
            Iterator<UIResourceProvider> i$ = this.resourceProviderSet.iterator();
            while (i$.hasNext() && (resourcePathSet = (resourceProvider = i$.next()).getUIResourcePaths(path)).isEmpty()) {
            }
        }
        return resourcePathSet;
    }

    public void setDefaultUIResourceProvider(UIResourceProvider defaultUIResourceProvider) {
        this.defaultUIResourceProvider = defaultUIResourceProvider;
    }

    public void serviceChanged(ServiceEvent serviceEvent) {
        if (serviceEvent.getType() == 1) {
            UIResourceProvider uiResourceProvider = (UIResourceProvider)this.bundleContext.getService(serviceEvent.getServiceReference());
            this.resourceProviderSet.add(uiResourceProvider);
        } else if (serviceEvent.getType() == 4) {
            UIResourceProvider uiResourceProvider = (UIResourceProvider)this.bundleContext.getService(serviceEvent.getServiceReference());
            this.resourceProviderSet.remove(uiResourceProvider);
        }
    }
}

