/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.ui;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;
import org.wso2.carbon.base.api.ServerConfigurationService;
import org.wso2.carbon.tomcat.api.CarbonTomcatService;
import org.wso2.carbon.ui.deployment.beans.Menu;
import org.wso2.carbon.ui.internal.CarbonUIServiceComponent;
import org.wso2.carbon.utils.CarbonUtils;
import org.wso2.carbon.utils.ConfigurationContextService;
import org.wso2.carbon.utils.NetworkUtils;
import org.wso2.carbon.utils.multitenancy.MultitenantConstants;

public class CarbonUIUtil {
    public static final String QUERY_PARAM_LOCALE = "locale";
    public static final String SESSION_PARAM_LOCALE = "custom_locale";
    private static Log log = LogFactory.getLog(CarbonUIUtil.class);
    private static BundleContext bundleContext = null;
    private static HashMap productParams = new HashMap();

    public static Object getServerProxy(Object clientClassObject, Class osgiObjectClass, HttpSession session) {
        return clientClassObject;
    }

    public static void setBundleContext(BundleContext context) {
        bundleContext = context;
    }

    public static BundleContext getBundleContext() {
        return bundleContext;
    }

    public static String getIndexPageURL(ServerConfigurationService serverConfig) {
        return serverConfig.getFirstProperty("IndexPageURL");
    }

    public static String getIndexPageURL(ServletContext servletContext, HttpSession httpSession) {
        Object obj = httpSession.getAttribute("IndexPageURL");
        String url = obj != null && obj instanceof String ? (String)obj : (String)servletContext.getAttribute("IndexPageURL");
        return url;
    }

    public static String getServerURL(ServerConfigurationService serverConfig) {
        ConfigurationContext serverCfgCtx = CarbonUIServiceComponent.getConfigurationContextService().getServerConfigContext();
        return CarbonUtils.getServerURL((ServerConfigurationService)serverConfig, (ConfigurationContext)serverCfgCtx);
    }

    public static String getServerURL(ServletContext servletContext, HttpSession httpSession) {
        return CarbonUtils.getServerURL((ServletContext)servletContext, (HttpSession)httpSession, (ConfigurationContext)CarbonUIServiceComponent.getConfigurationContextService().getServerConfigContext());
    }

    public static boolean isSuperTenant(HttpServletRequest request) {
        return request.getSession().getAttribute(MultitenantConstants.IS_SUPER_TENANT) != null && request.getSession().getAttribute(MultitenantConstants.IS_SUPER_TENANT).equals(Boolean.toString(true));
    }

    public static String https2httpURL(String url) {
        if (url.indexOf("${carbon.https.port}") != -1) {
            String httpPort = CarbonUtils.getTransportPort((ConfigurationContextService)CarbonUIServiceComponent.getConfigurationContextService(), (String)"http") + "";
            url = url.replace("${carbon.https.port}", httpPort);
        } else {
            url = url.replace("https", "http");
            String httpsPort = CarbonUtils.getTransportPort((ConfigurationContextService)CarbonUIServiceComponent.getConfigurationContextService(), (String)"https") + "";
            String httpPort = CarbonUtils.getTransportPort((ConfigurationContextService)CarbonUIServiceComponent.getConfigurationContextService(), (String)"http") + "";
            url = url.replace(httpsPort, httpPort);
        }
        return url;
    }

    public static String getAdminConsoleURL(HttpServletRequest request) {
        String hostName = "localhost";
        try {
            hostName = NetworkUtils.getMgtHostName();
        }
        catch (Exception ignored) {
            // empty catch block
        }
        String mgtConsoleTransport = CarbonUtils.getManagementTransport();
        ConfigurationContextService configContextService = CarbonUIServiceComponent.getConfigurationContextService();
        int httpsPort = CarbonUtils.getTransportPort((ConfigurationContextService)configContextService, (String)mgtConsoleTransport);
        int httpsProxyPort = CarbonUtils.getTransportProxyPort((ConfigurationContext)configContextService.getServerConfigContext(), (String)mgtConsoleTransport);
        String context = request.getContextPath();
        if ("/".equals(context)) {
            context = "";
        }
        String proxyContextPath = CarbonUtils.getProxyContextPath((boolean)false);
        if (httpsPort == -1) {
            return null;
        }
        String adminConsoleURL = null;
        String enableHTTPAdminConsole = CarbonUIServiceComponent.getServerConfiguration().getFirstProperty("EnableHTTPAdminConsole");
        if (enableHTTPAdminConsole != null && "true".equalsIgnoreCase(enableHTTPAdminConsole.trim())) {
            int httpPort = CarbonUtils.getTransportPort((ConfigurationContextService)CarbonUIServiceComponent.getConfigurationContextService(), (String)"http");
            adminConsoleURL = "http://" + hostName + ":" + httpPort + proxyContextPath + context + "/carbon/";
        } else {
            adminConsoleURL = "https://" + hostName + ":" + (httpsProxyPort != -1 ? httpsProxyPort : httpsPort) + proxyContextPath + context + "/carbon/";
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Generated admin console URL: " + adminConsoleURL));
        }
        return adminConsoleURL;
    }

    public static String getAdminConsoleURL(String context) {
        int httpsProxyPort;
        int httpsPort;
        String hostName = "localhost";
        try {
            hostName = NetworkUtils.getMgtHostName();
        }
        catch (Exception ignored) {
            // empty catch block
        }
        String mgtConsoleTransport = CarbonUtils.getManagementTransport();
        ConfigurationContextService configContextService = CarbonUIServiceComponent.getConfigurationContextService();
        String isRandomPort = System.getProperty("tomcat.random.port.enable");
        if (isRandomPort != null && isRandomPort.equals("true")) {
            CarbonTomcatService tomcatService = CarbonUIServiceComponent.getCarbonTomcatService();
            if (tomcatService != null) {
                httpsPort = tomcatService.getPort(mgtConsoleTransport);
                httpsProxyPort = tomcatService.getProxyPort(mgtConsoleTransport);
            } else {
                httpsPort = CarbonUtils.getTransportPort((ConfigurationContextService)configContextService, (String)mgtConsoleTransport);
                httpsProxyPort = CarbonUtils.getTransportProxyPort((ConfigurationContext)configContextService.getServerConfigContext(), (String)mgtConsoleTransport);
            }
        } else {
            httpsPort = CarbonUtils.getTransportPort((ConfigurationContextService)configContextService, (String)mgtConsoleTransport);
            httpsProxyPort = CarbonUtils.getTransportProxyPort((ConfigurationContext)configContextService.getServerConfigContext(), (String)mgtConsoleTransport);
        }
        if ("/".equals(context)) {
            context = "";
        }
        String proxyContextPath = CarbonUtils.getProxyContextPath((boolean)false);
        String adminConsoleURL = "https://" + hostName + ":" + (httpsProxyPort != -1 ? httpsProxyPort : httpsPort) + proxyContextPath + context + "/carbon/";
        if (log.isDebugEnabled()) {
            log.debug((Object)("Generated admin console URL: " + adminConsoleURL));
        }
        return adminConsoleURL;
    }

    public static String getServerConfigurationProperty(String propertyName) {
        try {
            ServerConfigurationService serverConfig = CarbonUIServiceComponent.getServerConfiguration();
            return serverConfig.getFirstProperty(propertyName);
        }
        catch (Exception e) {
            String msg = "ServerConfiguration Service not available";
            log.error((Object)msg, (Throwable)e);
            return null;
        }
    }

    public static boolean isContextRegistered(ServletConfig config, String context) {
        URL url;
        try {
            url = config.getServletContext().getResource(context);
        }
        catch (MalformedURLException e) {
            return false;
        }
        if (url == null) {
            return false;
        }
        return url.toString().indexOf(context) != -1;
    }

    public static Locale toLocale(String localeQuery) {
        Locale locale;
        String[] localeInfo = localeQuery.split("_");
        int size = localeInfo.length;
        switch (size) {
            case 2: {
                locale = new Locale(localeInfo[0], localeInfo[1]);
                break;
            }
            case 3: {
                locale = new Locale(localeInfo[0], localeInfo[1], localeInfo[2]);
                break;
            }
            default: {
                locale = new Locale(localeInfo[0]);
            }
        }
        return locale;
    }

    public static void setLocaleToSession(HttpServletRequest request) {
        if (request.getParameter(QUERY_PARAM_LOCALE) != null) {
            request.getSession().setAttribute(SESSION_PARAM_LOCALE, (Object)request.getParameter(QUERY_PARAM_LOCALE));
        }
    }

    public static Locale getLocaleFromSession(HttpServletRequest request) {
        if (request.getSession().getAttribute(SESSION_PARAM_LOCALE) != null) {
            String custom_locale = request.getSession().getAttribute(SESSION_PARAM_LOCALE).toString();
            return CarbonUIUtil.toLocale(custom_locale);
        }
        return request.getLocale();
    }

    public static String geti18nString(String key, String i18nBundle, String language) {
        Locale locale = new Locale(language);
        String text = CarbonUIUtil.geti18nString(key, i18nBundle, locale);
        return text;
    }

    public static String geti18nString(String key, String i18nBundle, Locale locale) {
        ResourceBundle resourceBundle;
        block7: {
            resourceBundle = null;
            if (i18nBundle != null) {
                try {
                    resourceBundle = ResourceBundle.getBundle(i18nBundle, locale);
                }
                catch (MissingResourceException e) {
                    if (!log.isDebugEnabled()) break block7;
                    log.debug((Object)("Cannot find resource bundle : " + i18nBundle + " for locale : " + locale));
                }
            }
        }
        String text = key;
        if (resourceBundle != null) {
            String tmp;
            block8: {
                tmp = null;
                try {
                    tmp = resourceBundle.getString(key);
                }
                catch (MissingResourceException e) {
                    if (!log.isDebugEnabled()) break block8;
                    log.debug((Object)("Cannot find resource for key :" + key));
                }
            }
            if (tmp != null) {
                text = tmp;
            }
        }
        return text;
    }

    public static void removeMenuDefinition(String menuId, HttpServletRequest request) {
        ArrayList<Menu> modifiedMenuDefs = new ArrayList<Menu>();
        Menu[] currentMenus = (Menu[])request.getSession().getAttribute("UserMenuItems");
        boolean modified = false;
        if (currentMenus != null && menuId != null && menuId.trim().length() > 0) {
            for (int a = 0; a < currentMenus.length; ++a) {
                Menu menu = currentMenus[a];
                if (menu == null) continue;
                if (!menuId.equals(menu.getId())) {
                    modifiedMenuDefs.add(menu);
                    modified = true;
                    continue;
                }
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Removing menu item : " + menuId));
            }
            if (modified) {
                Menu[] newMenuDefs = new Menu[modifiedMenuDefs.size()];
                newMenuDefs = modifiedMenuDefs.toArray(newMenuDefs);
                request.getSession().setAttribute("UserMenuItems", (Object)newMenuDefs);
            }
        }
    }

    public static String getBundleResourcePath(String resourceName) {
        if (resourceName == null || resourceName.length() == 0) {
            return null;
        }
        String resourcePath = resourceName;
        resourcePath = resourcePath.startsWith("/") ? resourcePath.substring(1) : resourcePath;
        resourcePath = resourcePath.lastIndexOf(47) != -1 ? resourcePath.substring(0, resourcePath.indexOf(47)) : resourcePath;
        return resourcePath;
    }

    public static boolean isUserAuthorized(HttpServletRequest request, String resource) {
        boolean isAuthorized = false;
        List permissions = (List)request.getSession().getAttribute("user-permissions");
        if (permissions == null) {
            return false;
        }
        for (String permission : permissions) {
            if (!resource.startsWith(permission)) continue;
            isAuthorized = true;
            break;
        }
        return isAuthorized;
    }

    public static Object getProductParam(String key) {
        return productParams.get(key);
    }

    public static void setProductParam(String key, Object value) {
        productParams.put(key, value);
    }

    public static String getHomePage() {
        Object homePage = CarbonUIUtil.getDefaultHomePageProductParam();
        if (homePage != null) {
            String homePageLocation = (String)homePage;
            if (!homePageLocation.startsWith("/")) {
                homePageLocation = "../../" + homePageLocation;
            }
            return homePageLocation;
        }
        return "../admin/index.jsp";
    }

    public static String removeTenantSpecificStringsFromURL(String requestURL) {
        if (requestURL.contains("/t/")) {
            int tenantPrefixIndex = requestURL.lastIndexOf("/t/");
            requestURL = requestURL.substring(tenantPrefixIndex + "t".length() + 2);
            int pageUrlIndex = requestURL.indexOf(47);
            requestURL = requestURL.substring(pageUrlIndex);
        }
        return requestURL;
    }

    private static Object getDefaultHomePageProductParam() {
        return CarbonUIUtil.getProductParam("WSO2CarbondefaultHomePage");
    }
}

