/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.utils.logging;

import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.apache.log4j.Category;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.log4j.spi.ThrowableInformation;
import org.wso2.carbon.utils.logging.TenantAwareLoggingEvent;

public class LoggingUtils {
    public static LoggingEvent getLogEvent(LogRecord record) {
        org.apache.log4j.Level level = LoggingUtils.getLogLevel(record.getLevel());
        return new LoggingEvent(record.getSourceClassName(), (Category)Logger.getLogger((String)record.getSourceClassName()), (Priority)level, (Object)record.getMessage(), record.getThrown());
    }

    public static TenantAwareLoggingEvent getTenantAwareLogEvent(LoggingEvent loggingEvent, int tenantId, String serviceName) {
        Logger logger = Logger.getLogger((String)loggingEvent.getLoggerName());
        ThrowableInformation throwableInformation = loggingEvent.getThrowableInformation();
        Throwable throwable = null == throwableInformation ? null : throwableInformation.getThrowable();
        TenantAwareLoggingEvent tenantAwareLoggingEvent = new TenantAwareLoggingEvent(loggingEvent.fqnOfCategoryClass, (Category)logger, loggingEvent.timeStamp, (Priority)loggingEvent.getLevel(), loggingEvent.getMessage(), throwable);
        tenantAwareLoggingEvent.setTenantId(Integer.toString(tenantId));
        tenantAwareLoggingEvent.setServiceName(serviceName);
        return tenantAwareLoggingEvent;
    }

    public static org.apache.log4j.Level getLogLevel(Level level) {
        if (level == Level.OFF) {
            return org.apache.log4j.Level.OFF;
        }
        if (level == Level.SEVERE) {
            return org.apache.log4j.Level.ERROR;
        }
        if (level == Level.WARNING) {
            return org.apache.log4j.Level.WARN;
        }
        if (level == Level.INFO) {
            return org.apache.log4j.Level.INFO;
        }
        if (level == Level.CONFIG || level == Level.FINE) {
            return org.apache.log4j.Level.DEBUG;
        }
        return org.apache.log4j.Level.TRACE;
    }
}

