/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.utils.logging.appenders;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.logging.LogRecord;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.spi.LoggingEvent;
import org.wso2.carbon.bootstrap.logging.LoggingBridge;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.utils.logging.LoggingUtils;
import org.wso2.carbon.utils.logging.TenantAwareLoggingEvent;

public class CarbonConsoleAppender
extends ConsoleAppender
implements LoggingBridge {
    public void push(LogRecord record) {
        LoggingEvent loggingEvent = LoggingUtils.getLogEvent(record);
        this.doAppend(loggingEvent);
    }

    protected void subAppend(LoggingEvent loggingEvent) {
        int tenantId = AccessController.doPrivileged(new PrivilegedAction<Integer>(){

            @Override
            public Integer run() {
                return CarbonContext.getThreadLocalCarbonContext().getTenantId();
            }
        });
        String serviceName = CarbonContext.getThreadLocalCarbonContext().getApplicationName();
        TenantAwareLoggingEvent tenantAwareLoggingEvent = LoggingUtils.getTenantAwareLogEvent(loggingEvent, tenantId, serviceName);
        super.subAppend((LoggingEvent)tenantAwareLoggingEvent);
    }
}

