/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.utils;

import java.io.File;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xerces.util.SecurityManager;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.wso2.carbon.utils.CarbonUtils;
import org.wso2.carbon.utils.dbcreator.DatabaseCreator;

public final class DBUtils {
    private static Log log = LogFactory.getLog(DBUtils.class);
    private static final int ENTITY_EXPANSION_LIMIT = 0;

    private DBUtils() {
    }

    public static String getConvertedAutoGeneratedColumnName(String dbProductName, String columnName) {
        String autoGeneratedColumnName = columnName;
        if ("PostgreSQL".equals(dbProductName)) {
            autoGeneratedColumnName = columnName.toLowerCase();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Database product name is PostgreSQL. Converting column name " + columnName + " to lowercase (" + autoGeneratedColumnName + ")."));
            }
        }
        return autoGeneratedColumnName;
    }

    public static boolean canReturnGeneratedKeys(String dbProductName) {
        return !dbProductName.equals("OpenEdge RDBMS");
    }

    public static String getRegistryDBConfig() throws Exception {
        return DBUtils.extractDBConfigFromXMLConfigFile(CarbonUtils.getRegistryXMLPath());
    }

    public static String getUserManagerDBConfig() throws Exception {
        return DBUtils.extractDBConfigFromXMLConfigFile(CarbonUtils.getUserMgtXMLPath());
    }

    private static String extractDBConfigFromXMLConfigFile(String path) throws Exception {
        String dbConfigInfo = null;
        if (path != null) {
            File file = new File(path);
            Document doc = null;
            try {
                DocumentBuilderFactory docBuilderFactory = DBUtils.getSecuredDocumentBuilder();
                doc = docBuilderFactory.newDocumentBuilder().parse(file);
            }
            catch (Exception e) {
                log.error((Object)("Failed pasring config file " + path + ". "), (Throwable)e);
                throw e;
            }
            NodeList dbConfig = doc.getElementsByTagName("dbConfig");
            Element inner = (Element)dbConfig.item(0);
            NodeList urlFinder = inner.getElementsByTagName("url");
            String urlValue = urlFinder.item(0).getTextContent();
            try {
                dbConfigInfo = DatabaseCreator.getDatabaseType(urlValue);
            }
            catch (Exception e) {
                log.error((Object)("Failed to extract database type for config file " + path + ". "), (Throwable)e);
                throw e;
            }
        }
        log.error((Object)"Cannot find config file; Invalide path: null");
        return dbConfigInfo;
    }

    private static DocumentBuilderFactory getSecuredDocumentBuilder() {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        dbf.setXIncludeAware(false);
        dbf.setExpandEntityReferences(false);
        try {
            dbf.setFeature("http://xml.org/sax/features/external-general-entities", false);
            dbf.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            dbf.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            dbf.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        }
        catch (ParserConfigurationException e) {
            log.error((Object)"Failed to load XML Processor Feature external-general-entities or external-parameter-entities or nonvalidating/load-external-dtd");
        }
        SecurityManager securityManager = new SecurityManager();
        securityManager.setEntityExpansionLimit(0);
        dbf.setAttribute("http://apache.org/xml/properties/security-manager", securityManager);
        return dbf;
    }
}

