/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.utils.logging.appenders;

import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Layout;
import org.apache.log4j.helpers.CyclicBuffer;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.helpers.OptionConverter;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.log4j.spi.TriggeringEventEvaluator;
import org.jivesoftware.smack.Chat;
import org.jivesoftware.smack.ConnectionConfiguration;
import org.jivesoftware.smack.MessageListener;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smackx.muc.MultiUserChat;
import org.wso2.carbon.utils.logging.DefaultEvaluator;

public class IMAppender
extends AppenderSkeleton {
    private static final int BUFFER_SIZE = 16;
    private static final int PORT = 5222;
    private String host;
    private int port = 5222;
    private String username;
    private String password;
    private String recipient;
    private boolean chatroom = false;
    private String nickname;
    private boolean enableSSL = false;
    private int bufferSize = 16;
    private TriggeringEventEvaluator evaluator;
    private CyclicBuffer cb;
    private XMPPConnection con;
    private Chat chat;
    private MultiUserChat groupchat;

    public IMAppender() {
        this(new DefaultEvaluator());
    }

    public IMAppender(TriggeringEventEvaluator evaluator) {
        this.evaluator = evaluator;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getRecipient() {
        return this.recipient;
    }

    public void setRecipient(String recipient) {
        this.recipient = recipient;
    }

    public boolean isChatroom() {
        return this.chatroom;
    }

    public void setChatroom(boolean chatroom) {
        this.chatroom = chatroom;
    }

    public String getNickname() {
        return this.nickname;
    }

    public void setNickname(String nickname) {
        this.nickname = nickname;
    }

    public boolean isSSL() {
        return this.enableSSL;
    }

    public void setSSL(boolean enableSSL) {
        this.enableSSL = enableSSL;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    public void setEvaluatorClass(String value) {
        this.evaluator = (TriggeringEventEvaluator)OptionConverter.instantiateByClassName((String)value, TriggeringEventEvaluator.class, (Object)this.evaluator);
    }

    public String getEvaluatorClass() {
        return this.evaluator == null ? null : this.evaluator.getClass().getName();
    }

    public void activateOptions() {
        try {
            this.cb = new CyclicBuffer(this.bufferSize);
            LogLog.debug((String)"Stablishing connection with XMPP server");
            ConnectionConfiguration xmppConf = new ConnectionConfiguration(this.host, this.port);
            if (this.enableSSL) {
                xmppConf.setSecurityMode(ConnectionConfiguration.SecurityMode.enabled);
            } else {
                xmppConf.setSecurityMode(ConnectionConfiguration.SecurityMode.disabled);
            }
            this.con = new XMPPConnection(xmppConf);
            LogLog.debug((String)("About to login as [" + this.username + "/" + this.password + "]"));
            this.con.login(this.username, this.password);
            if (this.chatroom) {
                LogLog.debug((String)"About to create ChatGroup");
                this.groupchat = new MultiUserChat(this.con, this.recipient);
                LogLog.debug((String)"About to join room");
                this.groupchat.join(this.nickname != null ? this.nickname : this.username);
            } else {
                this.chat = this.con.getChatManager().createChat(this.recipient, new MessageListener(){

                    public void processMessage(Chat chat, Message message) {
                    }
                });
            }
        }
        catch (Exception e) {
            this.errorHandler.error("Error while activating options for appender named [" + this.name + "]", e, 0);
        }
    }

    public synchronized void close() {
        if (this.closed) {
            return;
        }
        LogLog.debug((String)("Closing appender [" + this.name + "]"));
        this.closed = true;
        if (this.con != null) {
            this.con.disconnect();
        }
        this.con = null;
        this.chat = null;
        this.groupchat = null;
    }

    public void append(LoggingEvent event) {
        if (!this.checkEntryConditions()) {
            return;
        }
        this.cb.add(event);
        if (this.evaluator.isTriggeringEvent(event)) {
            this.sendBuffer();
        }
    }

    protected void sendBuffer() {
        try {
            StringBuffer buf = new StringBuffer();
            int len = this.cb.length();
            for (int i = 0; i < len; ++i) {
                String[] s;
                LoggingEvent event = this.cb.get();
                buf.append(this.layout.format(event));
                if (!this.layout.ignoresThrowable() || (s = event.getThrowableStrRep()) == null) continue;
                for (int j = 0; j < s.length; ++j) {
                    buf.append(Layout.LINE_SEP);
                    buf.append(s[j]);
                }
            }
            if (this.chatroom) {
                this.groupchat.sendMessage(buf.toString());
            } else {
                this.chat.sendMessage(buf.toString());
            }
        }
        catch (Exception e) {
            this.errorHandler.error("Could not send message in IMAppender [" + this.name + "]", e, 0);
        }
    }

    protected boolean checkEntryConditions() {
        if (this.chat == null && this.groupchat == null) {
            this.errorHandler.error("Chat object not configured");
            return false;
        }
        if (this.layout == null) {
            this.errorHandler.error("No layout set for appender named [" + this.name + "]");
            return false;
        }
        return true;
    }

    public boolean requiresLayout() {
        return true;
    }
}

