/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.utils.logging.appenders;

import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.spi.LoggingEvent;
import org.wso2.carbon.utils.logging.CircularBuffer;

public class MemoryAppender
extends AppenderSkeleton {
    private CircularBuffer<LoggingEvent> circularBuffer;
    private int bufferSize = -1;

    public MemoryAppender() {
    }

    public MemoryAppender(CircularBuffer<LoggingEvent> circularBuffer) {
        this.circularBuffer = circularBuffer;
    }

    protected void append(LoggingEvent loggingEvent) {
        if (this.circularBuffer != null) {
            this.circularBuffer.append(new LoggingEvent(loggingEvent.getFQNOfLoggerClass(), loggingEvent.getLogger(), loggingEvent.getTimeStamp(), loggingEvent.getLevel(), (Object)MemoryAppender.getSanitizedLoggingMessage(loggingEvent.getMessage()), loggingEvent.getThreadName(), loggingEvent.getThrowableInformation(), loggingEvent.getNDC(), loggingEvent.getLocationInformation(), loggingEvent.getProperties()));
        }
    }

    public void close() {
    }

    public boolean requiresLayout() {
        return true;
    }

    public CircularBuffer<LoggingEvent> getCircularQueue() {
        return this.circularBuffer;
    }

    public void setCircularBuffer(CircularBuffer<LoggingEvent> circularBuffer) {
        this.circularBuffer = circularBuffer;
    }

    public void activateOptions() {
        if (this.bufferSize < 0) {
            if (this.circularBuffer == null) {
                this.circularBuffer = new CircularBuffer();
            }
        } else {
            this.circularBuffer = new CircularBuffer(this.bufferSize);
        }
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    private static String getSanitizedLoggingMessage(Object message) {
        String sanitizedMessage;
        String string = sanitizedMessage = message == null ? null : message.toString();
        if (sanitizedMessage != null && !sanitizedMessage.isEmpty()) {
            boolean sanitized = false;
            int index = sanitizedMessage.indexOf(13);
            if (index >= 0) {
                sanitizedMessage = sanitizedMessage.replace('\r', '_');
                sanitized = true;
            }
            if ((index = sanitizedMessage.indexOf(10)) >= 0) {
                sanitizedMessage = sanitizedMessage.replace('\n', '_');
                sanitized = true;
            }
            if (sanitized) {
                sanitizedMessage = sanitizedMessage.concat(" (Sanitized)");
            }
        }
        return sanitizedMessage;
    }
}

