/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.extension.string;

import org.wso2.siddhi.core.config.ExecutionPlanContext;
import org.wso2.siddhi.core.exception.ExecutionPlanRuntimeException;
import org.wso2.siddhi.core.executor.ExpressionExecutor;
import org.wso2.siddhi.core.executor.function.FunctionExecutor;
import org.wso2.siddhi.query.api.definition.Attribute;
import org.wso2.siddhi.query.api.exception.ExecutionPlanValidationException;

public class HexFunctionExtension
extends FunctionExecutor {
    protected void init(ExpressionExecutor[] attributeExpressionExecutors, ExecutionPlanContext executionPlanContext) {
        if (attributeExpressionExecutors.length != 1) {
            throw new ExecutionPlanValidationException("Invalid no of arguments passed to str:hex() function, required 1, but found " + attributeExpressionExecutors.length);
        }
        Attribute.Type attributeType = attributeExpressionExecutors[0].getReturnType();
        if (attributeType != Attribute.Type.STRING) {
            throw new ExecutionPlanValidationException("Invalid parameter type found for the argument of str:hex() function, required " + Attribute.Type.STRING + "but found " + attributeType.toString());
        }
    }

    protected Object execute(Object[] data) {
        return null;
    }

    protected Object execute(Object data) {
        if (data != null) {
            char[] chars = ((String)data).toCharArray();
            StringBuilder sb = new StringBuilder();
            for (char c : chars) {
                sb.append(Integer.toHexString(c));
            }
            return sb.toString();
        }
        throw new ExecutionPlanRuntimeException("Input to the str:hex() function cannot be null");
    }

    public void start() {
    }

    public void stop() {
    }

    public Attribute.Type getReturnType() {
        return Attribute.Type.STRING;
    }

    public Object[] currentState() {
        return null;
    }

    public void restoreState(Object[] state) {
    }
}

