/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.extensions.processor.css;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.isdc.wro.WroRuntimeException;
import ro.isdc.wro.extensions.processor.support.yui.YuiCssCompressor;
import ro.isdc.wro.model.group.processor.Minimize;
import ro.isdc.wro.model.resource.Resource;
import ro.isdc.wro.model.resource.ResourceType;
import ro.isdc.wro.model.resource.SupportedResourceType;
import ro.isdc.wro.model.resource.processor.ResourcePostProcessor;
import ro.isdc.wro.model.resource.processor.ResourcePreProcessor;

@Minimize
@SupportedResourceType(value=ResourceType.CSS)
public class YUICssCompressorProcessor
implements ResourcePostProcessor,
ResourcePreProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(YUICssCompressorProcessor.class);
    public static final String ALIAS = "yuiCssMin";
    private static final int linebreakpos = -1;

    public void process(Reader reader, Writer writer) throws IOException {
        this.process(null, reader, writer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(Resource resource, Reader reader, Writer writer) throws IOException {
        try {
            YuiCssCompressor compressor = new YuiCssCompressor(reader);
            compressor.compress(writer, -1);
        }
        catch (Exception e) {
            LOG.error("Exception occured while processing resource: " + resource + " using processor: yuiCssMin");
            this.onException(e);
        }
        finally {
            reader.close();
            writer.close();
        }
    }

    protected void onException(Exception e) {
        throw WroRuntimeException.wrap((Exception)e);
    }
}

