/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apigateway.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Request a new export of a RestApi for a particular Stage.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetExportRequest extends ApiGatewayRequest implements
        ToCopyableBuilder<GetExportRequest.Builder, GetExportRequest> {
    private static final SdkField<String> REST_API_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("restApiId").getter(getter(GetExportRequest::restApiId)).setter(setter(Builder::restApiId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("restapi_id").build()).build();

    private static final SdkField<String> STAGE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("stageName").getter(getter(GetExportRequest::stageName)).setter(setter(Builder::stageName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("stage_name").build()).build();

    private static final SdkField<String> EXPORT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("exportType").getter(getter(GetExportRequest::exportType)).setter(setter(Builder::exportType))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("export_type").build()).build();

    private static final SdkField<Map<String, String>> PARAMETERS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("parameters")
            .getter(getter(GetExportRequest::parameters))
            .setter(setter(Builder::parameters))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("parameters").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> ACCEPTS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("accepts")
            .getter(getter(GetExportRequest::accepts)).setter(setter(Builder::accepts))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Accept").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REST_API_ID_FIELD,
            STAGE_NAME_FIELD, EXPORT_TYPE_FIELD, PARAMETERS_FIELD, ACCEPTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String restApiId;

    private final String stageName;

    private final String exportType;

    private final Map<String, String> parameters;

    private final String accepts;

    private GetExportRequest(BuilderImpl builder) {
        super(builder);
        this.restApiId = builder.restApiId;
        this.stageName = builder.stageName;
        this.exportType = builder.exportType;
        this.parameters = builder.parameters;
        this.accepts = builder.accepts;
    }

    /**
     * <p>
     * The string identifier of the associated RestApi.
     * </p>
     * 
     * @return The string identifier of the associated RestApi.
     */
    public final String restApiId() {
        return restApiId;
    }

    /**
     * <p>
     * The name of the Stage that will be exported.
     * </p>
     * 
     * @return The name of the Stage that will be exported.
     */
    public final String stageName() {
        return stageName;
    }

    /**
     * <p>
     * The type of export. Acceptable values are 'oas30' for OpenAPI 3.0.x and 'swagger' for Swagger/OpenAPI 2.0.
     * </p>
     * 
     * @return The type of export. Acceptable values are 'oas30' for OpenAPI 3.0.x and 'swagger' for Swagger/OpenAPI
     *         2.0.
     */
    public final String exportType() {
        return exportType;
    }

    /**
     * For responses, this returns true if the service returned a value for the Parameters property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasParameters() {
        return parameters != null && !(parameters instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A key-value map of query string parameters that specify properties of the export, depending on the requested
     * <code>exportType</code>. For <code>exportType</code> <code>oas30</code> and <code>swagger</code>, any combination
     * of the following parameters are supported: <code>extensions='integrations'</code> or
     * <code>extensions='apigateway'</code> will export the API with x-amazon-apigateway-integration extensions.
     * <code>extensions='authorizers'</code> will export the API with x-amazon-apigateway-authorizer extensions.
     * <code>postman</code> will export the API with Postman extensions, allowing for import to the Postman tool
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasParameters} method.
     * </p>
     * 
     * @return A key-value map of query string parameters that specify properties of the export, depending on the
     *         requested <code>exportType</code>. For <code>exportType</code> <code>oas30</code> and
     *         <code>swagger</code>, any combination of the following parameters are supported:
     *         <code>extensions='integrations'</code> or <code>extensions='apigateway'</code> will export the API with
     *         x-amazon-apigateway-integration extensions. <code>extensions='authorizers'</code> will export the API
     *         with x-amazon-apigateway-authorizer extensions. <code>postman</code> will export the API with Postman
     *         extensions, allowing for import to the Postman tool
     */
    public final Map<String, String> parameters() {
        return parameters;
    }

    /**
     * <p>
     * The content-type of the export, for example <code>application/json</code>. Currently
     * <code>application/json</code> and <code>application/yaml</code> are supported for <code>exportType</code> of
     * <code>oas30</code> and <code>swagger</code>. This should be specified in the <code>Accept</code> header for
     * direct API requests.
     * </p>
     * 
     * @return The content-type of the export, for example <code>application/json</code>. Currently
     *         <code>application/json</code> and <code>application/yaml</code> are supported for <code>exportType</code>
     *         of<code>oas30</code> and <code>swagger</code>. This should be specified in the <code>Accept</code> header
     *         for direct API requests.
     */
    public final String accepts() {
        return accepts;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(restApiId());
        hashCode = 31 * hashCode + Objects.hashCode(stageName());
        hashCode = 31 * hashCode + Objects.hashCode(exportType());
        hashCode = 31 * hashCode + Objects.hashCode(hasParameters() ? parameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(accepts());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetExportRequest)) {
            return false;
        }
        GetExportRequest other = (GetExportRequest) obj;
        return Objects.equals(restApiId(), other.restApiId()) && Objects.equals(stageName(), other.stageName())
                && Objects.equals(exportType(), other.exportType()) && hasParameters() == other.hasParameters()
                && Objects.equals(parameters(), other.parameters()) && Objects.equals(accepts(), other.accepts());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetExportRequest").add("RestApiId", restApiId()).add("StageName", stageName())
                .add("ExportType", exportType()).add("Parameters", hasParameters() ? parameters() : null)
                .add("Accepts", accepts()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "restApiId":
            return Optional.ofNullable(clazz.cast(restApiId()));
        case "stageName":
            return Optional.ofNullable(clazz.cast(stageName()));
        case "exportType":
            return Optional.ofNullable(clazz.cast(exportType()));
        case "parameters":
            return Optional.ofNullable(clazz.cast(parameters()));
        case "accepts":
            return Optional.ofNullable(clazz.cast(accepts()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("restapi_id", REST_API_ID_FIELD);
        map.put("stage_name", STAGE_NAME_FIELD);
        map.put("export_type", EXPORT_TYPE_FIELD);
        map.put("parameters", PARAMETERS_FIELD);
        map.put("Accept", ACCEPTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetExportRequest, T> g) {
        return obj -> g.apply((GetExportRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ApiGatewayRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetExportRequest> {
        /**
         * <p>
         * The string identifier of the associated RestApi.
         * </p>
         * 
         * @param restApiId
         *        The string identifier of the associated RestApi.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder restApiId(String restApiId);

        /**
         * <p>
         * The name of the Stage that will be exported.
         * </p>
         * 
         * @param stageName
         *        The name of the Stage that will be exported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stageName(String stageName);

        /**
         * <p>
         * The type of export. Acceptable values are 'oas30' for OpenAPI 3.0.x and 'swagger' for Swagger/OpenAPI 2.0.
         * </p>
         * 
         * @param exportType
         *        The type of export. Acceptable values are 'oas30' for OpenAPI 3.0.x and 'swagger' for Swagger/OpenAPI
         *        2.0.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exportType(String exportType);

        /**
         * <p>
         * A key-value map of query string parameters that specify properties of the export, depending on the requested
         * <code>exportType</code>. For <code>exportType</code> <code>oas30</code> and <code>swagger</code>, any
         * combination of the following parameters are supported: <code>extensions='integrations'</code> or
         * <code>extensions='apigateway'</code> will export the API with x-amazon-apigateway-integration extensions.
         * <code>extensions='authorizers'</code> will export the API with x-amazon-apigateway-authorizer extensions.
         * <code>postman</code> will export the API with Postman extensions, allowing for import to the Postman tool
         * </p>
         * 
         * @param parameters
         *        A key-value map of query string parameters that specify properties of the export, depending on the
         *        requested <code>exportType</code>. For <code>exportType</code> <code>oas30</code> and
         *        <code>swagger</code>, any combination of the following parameters are supported:
         *        <code>extensions='integrations'</code> or <code>extensions='apigateway'</code> will export the API
         *        with x-amazon-apigateway-integration extensions. <code>extensions='authorizers'</code> will export the
         *        API with x-amazon-apigateway-authorizer extensions. <code>postman</code> will export the API with
         *        Postman extensions, allowing for import to the Postman tool
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameters(Map<String, String> parameters);

        /**
         * <p>
         * The content-type of the export, for example <code>application/json</code>. Currently
         * <code>application/json</code> and <code>application/yaml</code> are supported for <code>exportType</code> of
         * <code>oas30</code> and <code>swagger</code>. This should be specified in the <code>Accept</code> header for
         * direct API requests.
         * </p>
         * 
         * @param accepts
         *        The content-type of the export, for example <code>application/json</code>. Currently
         *        <code>application/json</code> and <code>application/yaml</code> are supported for
         *        <code>exportType</code> of<code>oas30</code> and <code>swagger</code>. This should be specified in the
         *        <code>Accept</code> header for direct API requests.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accepts(String accepts);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ApiGatewayRequest.BuilderImpl implements Builder {
        private String restApiId;

        private String stageName;

        private String exportType;

        private Map<String, String> parameters = DefaultSdkAutoConstructMap.getInstance();

        private String accepts;

        private BuilderImpl() {
        }

        private BuilderImpl(GetExportRequest model) {
            super(model);
            restApiId(model.restApiId);
            stageName(model.stageName);
            exportType(model.exportType);
            parameters(model.parameters);
            accepts(model.accepts);
        }

        public final String getRestApiId() {
            return restApiId;
        }

        public final void setRestApiId(String restApiId) {
            this.restApiId = restApiId;
        }

        @Override
        public final Builder restApiId(String restApiId) {
            this.restApiId = restApiId;
            return this;
        }

        public final String getStageName() {
            return stageName;
        }

        public final void setStageName(String stageName) {
            this.stageName = stageName;
        }

        @Override
        public final Builder stageName(String stageName) {
            this.stageName = stageName;
            return this;
        }

        public final String getExportType() {
            return exportType;
        }

        public final void setExportType(String exportType) {
            this.exportType = exportType;
        }

        @Override
        public final Builder exportType(String exportType) {
            this.exportType = exportType;
            return this;
        }

        public final Map<String, String> getParameters() {
            if (parameters instanceof SdkAutoConstructMap) {
                return null;
            }
            return parameters;
        }

        public final void setParameters(Map<String, String> parameters) {
            this.parameters = MapOfStringToStringCopier.copy(parameters);
        }

        @Override
        public final Builder parameters(Map<String, String> parameters) {
            this.parameters = MapOfStringToStringCopier.copy(parameters);
            return this;
        }

        public final String getAccepts() {
            return accepts;
        }

        public final void setAccepts(String accepts) {
            this.accepts = accepts;
        }

        @Override
        public final Builder accepts(String accepts) {
            this.accepts = accepts;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetExportRequest build() {
            return new GetExportRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
