/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apigateway.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Request to add a MethodResponse to an existing Method resource.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutMethodResponseRequest extends ApiGatewayRequest implements
        ToCopyableBuilder<PutMethodResponseRequest.Builder, PutMethodResponseRequest> {
    private static final SdkField<String> REST_API_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("restApiId").getter(getter(PutMethodResponseRequest::restApiId)).setter(setter(Builder::restApiId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("restapi_id").build()).build();

    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resourceId").getter(getter(PutMethodResponseRequest::resourceId)).setter(setter(Builder::resourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("resource_id").build()).build();

    private static final SdkField<String> HTTP_METHOD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("httpMethod").getter(getter(PutMethodResponseRequest::httpMethod)).setter(setter(Builder::httpMethod))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("http_method").build()).build();

    private static final SdkField<String> STATUS_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("statusCode").getter(getter(PutMethodResponseRequest::statusCode)).setter(setter(Builder::statusCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("status_code").build()).build();

    private static final SdkField<Map<String, Boolean>> RESPONSE_PARAMETERS_FIELD = SdkField
            .<Map<String, Boolean>> builder(MarshallingType.MAP)
            .memberName("responseParameters")
            .getter(getter(PutMethodResponseRequest::responseParameters))
            .setter(setter(Builder::responseParameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("responseParameters").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Map<String, String>> RESPONSE_MODELS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("responseModels")
            .getter(getter(PutMethodResponseRequest::responseModels))
            .setter(setter(Builder::responseModels))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("responseModels").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REST_API_ID_FIELD,
            RESOURCE_ID_FIELD, HTTP_METHOD_FIELD, STATUS_CODE_FIELD, RESPONSE_PARAMETERS_FIELD, RESPONSE_MODELS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String restApiId;

    private final String resourceId;

    private final String httpMethod;

    private final String statusCodeValue;

    private final Map<String, Boolean> responseParameters;

    private final Map<String, String> responseModels;

    private PutMethodResponseRequest(BuilderImpl builder) {
        super(builder);
        this.restApiId = builder.restApiId;
        this.resourceId = builder.resourceId;
        this.httpMethod = builder.httpMethod;
        this.statusCodeValue = builder.statusCodeValue;
        this.responseParameters = builder.responseParameters;
        this.responseModels = builder.responseModels;
    }

    /**
     * <p>
     * The string identifier of the associated RestApi.
     * </p>
     * 
     * @return The string identifier of the associated RestApi.
     */
    public final String restApiId() {
        return restApiId;
    }

    /**
     * <p>
     * The Resource identifier for the Method resource.
     * </p>
     * 
     * @return The Resource identifier for the Method resource.
     */
    public final String resourceId() {
        return resourceId;
    }

    /**
     * <p>
     * The HTTP verb of the Method resource.
     * </p>
     * 
     * @return The HTTP verb of the Method resource.
     */
    public final String httpMethod() {
        return httpMethod;
    }

    /**
     * <p>
     * The method response's status code.
     * </p>
     * 
     * @return The method response's status code.
     */
    public final String statusCode() {
        return statusCodeValue;
    }

    /**
     * For responses, this returns true if the service returned a value for the ResponseParameters property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasResponseParameters() {
        return responseParameters != null && !(responseParameters instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A key-value map specifying required or optional response parameters that API Gateway can send back to the caller.
     * A key defines a method response header name and the associated value is a Boolean flag indicating whether the
     * method response parameter is required or not. The method response header names must match the pattern of
     * <code>method.response.header.{name}</code>, where <code>name</code> is a valid and unique header name. The
     * response parameter names defined here are available in the integration response to be mapped from an integration
     * response header expressed in <code>integration.response.header.{name}</code>, a static value enclosed within a
     * pair of single quotes (e.g., <code>'application/json'</code>), or a JSON expression from the back-end response
     * payload in the form of <code>integration.response.body.{JSON-expression}</code>, where
     * <code>JSON-expression</code> is a valid JSON expression without the <code>$</code> prefix.)
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasResponseParameters} method.
     * </p>
     * 
     * @return A key-value map specifying required or optional response parameters that API Gateway can send back to the
     *         caller. A key defines a method response header name and the associated value is a Boolean flag indicating
     *         whether the method response parameter is required or not. The method response header names must match the
     *         pattern of <code>method.response.header.{name}</code>, where <code>name</code> is a valid and unique
     *         header name. The response parameter names defined here are available in the integration response to be
     *         mapped from an integration response header expressed in <code>integration.response.header.{name}</code>,
     *         a static value enclosed within a pair of single quotes (e.g., <code>'application/json'</code>), or a JSON
     *         expression from the back-end response payload in the form of
     *         <code>integration.response.body.{JSON-expression}</code>, where <code>JSON-expression</code> is a valid
     *         JSON expression without the <code>$</code> prefix.)
     */
    public final Map<String, Boolean> responseParameters() {
        return responseParameters;
    }

    /**
     * For responses, this returns true if the service returned a value for the ResponseModels property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasResponseModels() {
        return responseModels != null && !(responseModels instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Specifies the Model resources used for the response's content type. Response models are represented as a
     * key/value map, with a content type as the key and a Model name as the value.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasResponseModels} method.
     * </p>
     * 
     * @return Specifies the Model resources used for the response's content type. Response models are represented as a
     *         key/value map, with a content type as the key and a Model name as the value.
     */
    public final Map<String, String> responseModels() {
        return responseModels;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(restApiId());
        hashCode = 31 * hashCode + Objects.hashCode(resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(httpMethod());
        hashCode = 31 * hashCode + Objects.hashCode(statusCode());
        hashCode = 31 * hashCode + Objects.hashCode(hasResponseParameters() ? responseParameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasResponseModels() ? responseModels() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutMethodResponseRequest)) {
            return false;
        }
        PutMethodResponseRequest other = (PutMethodResponseRequest) obj;
        return Objects.equals(restApiId(), other.restApiId()) && Objects.equals(resourceId(), other.resourceId())
                && Objects.equals(httpMethod(), other.httpMethod()) && Objects.equals(statusCode(), other.statusCode())
                && hasResponseParameters() == other.hasResponseParameters()
                && Objects.equals(responseParameters(), other.responseParameters())
                && hasResponseModels() == other.hasResponseModels() && Objects.equals(responseModels(), other.responseModels());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutMethodResponseRequest").add("RestApiId", restApiId()).add("ResourceId", resourceId())
                .add("HttpMethod", httpMethod()).add("StatusCode", statusCode())
                .add("ResponseParameters", hasResponseParameters() ? responseParameters() : null)
                .add("ResponseModels", hasResponseModels() ? responseModels() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "restApiId":
            return Optional.ofNullable(clazz.cast(restApiId()));
        case "resourceId":
            return Optional.ofNullable(clazz.cast(resourceId()));
        case "httpMethod":
            return Optional.ofNullable(clazz.cast(httpMethod()));
        case "statusCode":
            return Optional.ofNullable(clazz.cast(statusCode()));
        case "responseParameters":
            return Optional.ofNullable(clazz.cast(responseParameters()));
        case "responseModels":
            return Optional.ofNullable(clazz.cast(responseModels()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("restapi_id", REST_API_ID_FIELD);
        map.put("resource_id", RESOURCE_ID_FIELD);
        map.put("http_method", HTTP_METHOD_FIELD);
        map.put("status_code", STATUS_CODE_FIELD);
        map.put("responseParameters", RESPONSE_PARAMETERS_FIELD);
        map.put("responseModels", RESPONSE_MODELS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PutMethodResponseRequest, T> g) {
        return obj -> g.apply((PutMethodResponseRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ApiGatewayRequest.Builder, SdkPojo, CopyableBuilder<Builder, PutMethodResponseRequest> {
        /**
         * <p>
         * The string identifier of the associated RestApi.
         * </p>
         * 
         * @param restApiId
         *        The string identifier of the associated RestApi.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder restApiId(String restApiId);

        /**
         * <p>
         * The Resource identifier for the Method resource.
         * </p>
         * 
         * @param resourceId
         *        The Resource identifier for the Method resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceId(String resourceId);

        /**
         * <p>
         * The HTTP verb of the Method resource.
         * </p>
         * 
         * @param httpMethod
         *        The HTTP verb of the Method resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder httpMethod(String httpMethod);

        /**
         * <p>
         * The method response's status code.
         * </p>
         * 
         * @param statusCodeValue
         *        The method response's status code.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusCode(String statusCodeValue);

        /**
         * <p>
         * A key-value map specifying required or optional response parameters that API Gateway can send back to the
         * caller. A key defines a method response header name and the associated value is a Boolean flag indicating
         * whether the method response parameter is required or not. The method response header names must match the
         * pattern of <code>method.response.header.{name}</code>, where <code>name</code> is a valid and unique header
         * name. The response parameter names defined here are available in the integration response to be mapped from
         * an integration response header expressed in <code>integration.response.header.{name}</code>, a static value
         * enclosed within a pair of single quotes (e.g., <code>'application/json'</code>), or a JSON expression from
         * the back-end response payload in the form of <code>integration.response.body.{JSON-expression}</code>, where
         * <code>JSON-expression</code> is a valid JSON expression without the <code>$</code> prefix.)
         * </p>
         * 
         * @param responseParameters
         *        A key-value map specifying required or optional response parameters that API Gateway can send back to
         *        the caller. A key defines a method response header name and the associated value is a Boolean flag
         *        indicating whether the method response parameter is required or not. The method response header names
         *        must match the pattern of <code>method.response.header.{name}</code>, where <code>name</code> is a
         *        valid and unique header name. The response parameter names defined here are available in the
         *        integration response to be mapped from an integration response header expressed in
         *        <code>integration.response.header.{name}</code>, a static value enclosed within a pair of single
         *        quotes (e.g., <code>'application/json'</code>), or a JSON expression from the back-end response
         *        payload in the form of <code>integration.response.body.{JSON-expression}</code>, where
         *        <code>JSON-expression</code> is a valid JSON expression without the <code>$</code> prefix.)
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder responseParameters(Map<String, Boolean> responseParameters);

        /**
         * <p>
         * Specifies the Model resources used for the response's content type. Response models are represented as a
         * key/value map, with a content type as the key and a Model name as the value.
         * </p>
         * 
         * @param responseModels
         *        Specifies the Model resources used for the response's content type. Response models are represented as
         *        a key/value map, with a content type as the key and a Model name as the value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder responseModels(Map<String, String> responseModels);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ApiGatewayRequest.BuilderImpl implements Builder {
        private String restApiId;

        private String resourceId;

        private String httpMethod;

        private String statusCodeValue;

        private Map<String, Boolean> responseParameters = DefaultSdkAutoConstructMap.getInstance();

        private Map<String, String> responseModels = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PutMethodResponseRequest model) {
            super(model);
            restApiId(model.restApiId);
            resourceId(model.resourceId);
            httpMethod(model.httpMethod);
            statusCode(model.statusCodeValue);
            responseParameters(model.responseParameters);
            responseModels(model.responseModels);
        }

        public final String getRestApiId() {
            return restApiId;
        }

        public final void setRestApiId(String restApiId) {
            this.restApiId = restApiId;
        }

        @Override
        public final Builder restApiId(String restApiId) {
            this.restApiId = restApiId;
            return this;
        }

        public final String getResourceId() {
            return resourceId;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final String getHttpMethod() {
            return httpMethod;
        }

        public final void setHttpMethod(String httpMethod) {
            this.httpMethod = httpMethod;
        }

        @Override
        public final Builder httpMethod(String httpMethod) {
            this.httpMethod = httpMethod;
            return this;
        }

        public final String getStatusCode() {
            return statusCodeValue;
        }

        public final void setStatusCode(String statusCodeValue) {
            this.statusCodeValue = statusCodeValue;
        }

        @Override
        public final Builder statusCode(String statusCodeValue) {
            this.statusCodeValue = statusCodeValue;
            return this;
        }

        public final Map<String, Boolean> getResponseParameters() {
            if (responseParameters instanceof SdkAutoConstructMap) {
                return null;
            }
            return responseParameters;
        }

        public final void setResponseParameters(Map<String, Boolean> responseParameters) {
            this.responseParameters = MapOfStringToBooleanCopier.copy(responseParameters);
        }

        @Override
        public final Builder responseParameters(Map<String, Boolean> responseParameters) {
            this.responseParameters = MapOfStringToBooleanCopier.copy(responseParameters);
            return this;
        }

        public final Map<String, String> getResponseModels() {
            if (responseModels instanceof SdkAutoConstructMap) {
                return null;
            }
            return responseModels;
        }

        public final void setResponseModels(Map<String, String> responseModels) {
            this.responseModels = MapOfStringToStringCopier.copy(responseModels);
        }

        @Override
        public final Builder responseModels(Map<String, String> responseModels) {
            this.responseModels = MapOfStringToStringCopier.copy(responseModels);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutMethodResponseRequest build() {
            return new PutMethodResponseRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
