/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DisableKinesisStreamingDestinationResponse extends DynamoDbResponse implements
        ToCopyableBuilder<DisableKinesisStreamingDestinationResponse.Builder, DisableKinesisStreamingDestinationResponse> {
    private static final SdkField<String> TABLE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TableName").getter(getter(DisableKinesisStreamingDestinationResponse::tableName))
            .setter(setter(Builder::tableName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableName").build()).build();

    private static final SdkField<String> STREAM_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StreamArn").getter(getter(DisableKinesisStreamingDestinationResponse::streamArn))
            .setter(setter(Builder::streamArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamArn").build()).build();

    private static final SdkField<String> DESTINATION_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DestinationStatus")
            .getter(getter(DisableKinesisStreamingDestinationResponse::destinationStatusAsString))
            .setter(setter(Builder::destinationStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationStatus").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TABLE_NAME_FIELD,
            STREAM_ARN_FIELD, DESTINATION_STATUS_FIELD));

    private final String tableName;

    private final String streamArn;

    private final String destinationStatus;

    private DisableKinesisStreamingDestinationResponse(BuilderImpl builder) {
        super(builder);
        this.tableName = builder.tableName;
        this.streamArn = builder.streamArn;
        this.destinationStatus = builder.destinationStatus;
    }

    /**
     * <p>
     * The name of the table being modified.
     * </p>
     * 
     * @return The name of the table being modified.
     */
    public final String tableName() {
        return tableName;
    }

    /**
     * <p>
     * The ARN for the specific Kinesis data stream.
     * </p>
     * 
     * @return The ARN for the specific Kinesis data stream.
     */
    public final String streamArn() {
        return streamArn;
    }

    /**
     * <p>
     * The current status of the replication.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #destinationStatus}
     * will return {@link DestinationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #destinationStatusAsString}.
     * </p>
     * 
     * @return The current status of the replication.
     * @see DestinationStatus
     */
    public final DestinationStatus destinationStatus() {
        return DestinationStatus.fromValue(destinationStatus);
    }

    /**
     * <p>
     * The current status of the replication.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #destinationStatus}
     * will return {@link DestinationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #destinationStatusAsString}.
     * </p>
     * 
     * @return The current status of the replication.
     * @see DestinationStatus
     */
    public final String destinationStatusAsString() {
        return destinationStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(tableName());
        hashCode = 31 * hashCode + Objects.hashCode(streamArn());
        hashCode = 31 * hashCode + Objects.hashCode(destinationStatusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DisableKinesisStreamingDestinationResponse)) {
            return false;
        }
        DisableKinesisStreamingDestinationResponse other = (DisableKinesisStreamingDestinationResponse) obj;
        return Objects.equals(tableName(), other.tableName()) && Objects.equals(streamArn(), other.streamArn())
                && Objects.equals(destinationStatusAsString(), other.destinationStatusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DisableKinesisStreamingDestinationResponse").add("TableName", tableName())
                .add("StreamArn", streamArn()).add("DestinationStatus", destinationStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TableName":
            return Optional.ofNullable(clazz.cast(tableName()));
        case "StreamArn":
            return Optional.ofNullable(clazz.cast(streamArn()));
        case "DestinationStatus":
            return Optional.ofNullable(clazz.cast(destinationStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DisableKinesisStreamingDestinationResponse, T> g) {
        return obj -> g.apply((DisableKinesisStreamingDestinationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DynamoDbResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DisableKinesisStreamingDestinationResponse> {
        /**
         * <p>
         * The name of the table being modified.
         * </p>
         * 
         * @param tableName
         *        The name of the table being modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tableName(String tableName);

        /**
         * <p>
         * The ARN for the specific Kinesis data stream.
         * </p>
         * 
         * @param streamArn
         *        The ARN for the specific Kinesis data stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamArn(String streamArn);

        /**
         * <p>
         * The current status of the replication.
         * </p>
         * 
         * @param destinationStatus
         *        The current status of the replication.
         * @see DestinationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DestinationStatus
         */
        Builder destinationStatus(String destinationStatus);

        /**
         * <p>
         * The current status of the replication.
         * </p>
         * 
         * @param destinationStatus
         *        The current status of the replication.
         * @see DestinationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DestinationStatus
         */
        Builder destinationStatus(DestinationStatus destinationStatus);
    }

    static final class BuilderImpl extends DynamoDbResponse.BuilderImpl implements Builder {
        private String tableName;

        private String streamArn;

        private String destinationStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(DisableKinesisStreamingDestinationResponse model) {
            super(model);
            tableName(model.tableName);
            streamArn(model.streamArn);
            destinationStatus(model.destinationStatus);
        }

        public final String getTableName() {
            return tableName;
        }

        public final void setTableName(String tableName) {
            this.tableName = tableName;
        }

        @Override
        public final Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public final String getStreamArn() {
            return streamArn;
        }

        public final void setStreamArn(String streamArn) {
            this.streamArn = streamArn;
        }

        @Override
        public final Builder streamArn(String streamArn) {
            this.streamArn = streamArn;
            return this;
        }

        public final String getDestinationStatus() {
            return destinationStatus;
        }

        public final void setDestinationStatus(String destinationStatus) {
            this.destinationStatus = destinationStatus;
        }

        @Override
        public final Builder destinationStatus(String destinationStatus) {
            this.destinationStatus = destinationStatus;
            return this;
        }

        @Override
        public final Builder destinationStatus(DestinationStatus destinationStatus) {
            this.destinationStatus(destinationStatus == null ? null : destinationStatus.toString());
            return this;
        }

        @Override
        public DisableKinesisStreamingDestinationResponse build() {
            return new DisableKinesisStreamingDestinationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
