/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kafka.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 *
 * <p>
 * Returns information about a provisioned cluster operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ClusterOperationV2Provisioned implements SdkPojo, Serializable,
        ToCopyableBuilder<ClusterOperationV2Provisioned.Builder, ClusterOperationV2Provisioned> {
    private static final SdkField<List<ClusterOperationStep>> OPERATION_STEPS_FIELD = SdkField
            .<List<ClusterOperationStep>> builder(MarshallingType.LIST)
            .memberName("OperationSteps")
            .getter(getter(ClusterOperationV2Provisioned::operationSteps))
            .setter(setter(Builder::operationSteps))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("operationSteps").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ClusterOperationStep> builder(MarshallingType.SDK_POJO)
                                            .constructor(ClusterOperationStep::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<MutableClusterInfo> SOURCE_CLUSTER_INFO_FIELD = SdkField
            .<MutableClusterInfo> builder(MarshallingType.SDK_POJO).memberName("SourceClusterInfo")
            .getter(getter(ClusterOperationV2Provisioned::sourceClusterInfo)).setter(setter(Builder::sourceClusterInfo))
            .constructor(MutableClusterInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceClusterInfo").build()).build();

    private static final SdkField<MutableClusterInfo> TARGET_CLUSTER_INFO_FIELD = SdkField
            .<MutableClusterInfo> builder(MarshallingType.SDK_POJO).memberName("TargetClusterInfo")
            .getter(getter(ClusterOperationV2Provisioned::targetClusterInfo)).setter(setter(Builder::targetClusterInfo))
            .constructor(MutableClusterInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetClusterInfo").build()).build();

    private static final SdkField<VpcConnectionInfo> VPC_CONNECTION_INFO_FIELD = SdkField
            .<VpcConnectionInfo> builder(MarshallingType.SDK_POJO).memberName("VpcConnectionInfo")
            .getter(getter(ClusterOperationV2Provisioned::vpcConnectionInfo)).setter(setter(Builder::vpcConnectionInfo))
            .constructor(VpcConnectionInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpcConnectionInfo").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OPERATION_STEPS_FIELD,
            SOURCE_CLUSTER_INFO_FIELD, TARGET_CLUSTER_INFO_FIELD, VPC_CONNECTION_INFO_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<ClusterOperationStep> operationSteps;

    private final MutableClusterInfo sourceClusterInfo;

    private final MutableClusterInfo targetClusterInfo;

    private final VpcConnectionInfo vpcConnectionInfo;

    private ClusterOperationV2Provisioned(BuilderImpl builder) {
        this.operationSteps = builder.operationSteps;
        this.sourceClusterInfo = builder.sourceClusterInfo;
        this.targetClusterInfo = builder.targetClusterInfo;
        this.vpcConnectionInfo = builder.vpcConnectionInfo;
    }

    /**
     * For responses, this returns true if the service returned a value for the OperationSteps property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasOperationSteps() {
        return operationSteps != null && !(operationSteps instanceof SdkAutoConstructList);
    }

    /**
     *
     * <p>
     * Steps completed during the operation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOperationSteps} method.
     * </p>
     * 
     * @return <p>
     *         Steps completed during the operation.
     *         </p>
     */
    public final List<ClusterOperationStep> operationSteps() {
        return operationSteps;
    }

    /**
     *
     * <p>
     * Information about cluster attributes before a cluster is updated.
     * </p>
     * 
     * @return <p>
     *         Information about cluster attributes before a cluster is updated.
     *         </p>
     */
    public final MutableClusterInfo sourceClusterInfo() {
        return sourceClusterInfo;
    }

    /**
     *
     * <p>
     * Information about cluster attributes after a cluster is updated.
     * </p>
     * 
     * @return <p>
     *         Information about cluster attributes after a cluster is updated.
     *         </p>
     */
    public final MutableClusterInfo targetClusterInfo() {
        return targetClusterInfo;
    }

    /**
     *
     * <p>
     * Description of the VPC connection for CreateVpcConnection and DeleteVpcConnection operations.
     * </p>
     * 
     * @return <p>
     *         Description of the VPC connection for CreateVpcConnection and DeleteVpcConnection operations.
     *         </p>
     */
    public final VpcConnectionInfo vpcConnectionInfo() {
        return vpcConnectionInfo;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasOperationSteps() ? operationSteps() : null);
        hashCode = 31 * hashCode + Objects.hashCode(sourceClusterInfo());
        hashCode = 31 * hashCode + Objects.hashCode(targetClusterInfo());
        hashCode = 31 * hashCode + Objects.hashCode(vpcConnectionInfo());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClusterOperationV2Provisioned)) {
            return false;
        }
        ClusterOperationV2Provisioned other = (ClusterOperationV2Provisioned) obj;
        return hasOperationSteps() == other.hasOperationSteps() && Objects.equals(operationSteps(), other.operationSteps())
                && Objects.equals(sourceClusterInfo(), other.sourceClusterInfo())
                && Objects.equals(targetClusterInfo(), other.targetClusterInfo())
                && Objects.equals(vpcConnectionInfo(), other.vpcConnectionInfo());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ClusterOperationV2Provisioned")
                .add("OperationSteps", hasOperationSteps() ? operationSteps() : null)
                .add("SourceClusterInfo", sourceClusterInfo()).add("TargetClusterInfo", targetClusterInfo())
                .add("VpcConnectionInfo", vpcConnectionInfo()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OperationSteps":
            return Optional.ofNullable(clazz.cast(operationSteps()));
        case "SourceClusterInfo":
            return Optional.ofNullable(clazz.cast(sourceClusterInfo()));
        case "TargetClusterInfo":
            return Optional.ofNullable(clazz.cast(targetClusterInfo()));
        case "VpcConnectionInfo":
            return Optional.ofNullable(clazz.cast(vpcConnectionInfo()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("operationSteps", OPERATION_STEPS_FIELD);
        map.put("sourceClusterInfo", SOURCE_CLUSTER_INFO_FIELD);
        map.put("targetClusterInfo", TARGET_CLUSTER_INFO_FIELD);
        map.put("vpcConnectionInfo", VPC_CONNECTION_INFO_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ClusterOperationV2Provisioned, T> g) {
        return obj -> g.apply((ClusterOperationV2Provisioned) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ClusterOperationV2Provisioned> {
        /**
         *
         * <p>
         * Steps completed during the operation.
         * </p>
         * 
         * @param operationSteps
         *        <p>
         *        Steps completed during the operation.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder operationSteps(Collection<ClusterOperationStep> operationSteps);

        /**
         *
         * <p>
         * Steps completed during the operation.
         * </p>
         * 
         * @param operationSteps
         *        <p>
         *        Steps completed during the operation.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder operationSteps(ClusterOperationStep... operationSteps);

        /**
         *
         * <p>
         * Steps completed during the operation.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.kafka.model.ClusterOperationStep.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.kafka.model.ClusterOperationStep#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.kafka.model.ClusterOperationStep.Builder#build()} is called
         * immediately and its result is passed to {@link #operationSteps(List<ClusterOperationStep>)}.
         * 
         * @param operationSteps
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.kafka.model.ClusterOperationStep.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #operationSteps(java.util.Collection<ClusterOperationStep>)
         */
        Builder operationSteps(Consumer<ClusterOperationStep.Builder>... operationSteps);

        /**
         *
         * <p>
         * Information about cluster attributes before a cluster is updated.
         * </p>
         * 
         * @param sourceClusterInfo
         *        <p>
         *        Information about cluster attributes before a cluster is updated.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceClusterInfo(MutableClusterInfo sourceClusterInfo);

        /**
         *
         * <p>
         * Information about cluster attributes before a cluster is updated.
         * </p>
         * This is a convenience method that creates an instance of the {@link MutableClusterInfo.Builder} avoiding the
         * need to create one manually via {@link MutableClusterInfo#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MutableClusterInfo.Builder#build()} is called immediately and its
         * result is passed to {@link #sourceClusterInfo(MutableClusterInfo)}.
         * 
         * @param sourceClusterInfo
         *        a consumer that will call methods on {@link MutableClusterInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sourceClusterInfo(MutableClusterInfo)
         */
        default Builder sourceClusterInfo(Consumer<MutableClusterInfo.Builder> sourceClusterInfo) {
            return sourceClusterInfo(MutableClusterInfo.builder().applyMutation(sourceClusterInfo).build());
        }

        /**
         *
         * <p>
         * Information about cluster attributes after a cluster is updated.
         * </p>
         * 
         * @param targetClusterInfo
         *        <p>
         *        Information about cluster attributes after a cluster is updated.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetClusterInfo(MutableClusterInfo targetClusterInfo);

        /**
         *
         * <p>
         * Information about cluster attributes after a cluster is updated.
         * </p>
         * This is a convenience method that creates an instance of the {@link MutableClusterInfo.Builder} avoiding the
         * need to create one manually via {@link MutableClusterInfo#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MutableClusterInfo.Builder#build()} is called immediately and its
         * result is passed to {@link #targetClusterInfo(MutableClusterInfo)}.
         * 
         * @param targetClusterInfo
         *        a consumer that will call methods on {@link MutableClusterInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #targetClusterInfo(MutableClusterInfo)
         */
        default Builder targetClusterInfo(Consumer<MutableClusterInfo.Builder> targetClusterInfo) {
            return targetClusterInfo(MutableClusterInfo.builder().applyMutation(targetClusterInfo).build());
        }

        /**
         *
         * <p>
         * Description of the VPC connection for CreateVpcConnection and DeleteVpcConnection operations.
         * </p>
         * 
         * @param vpcConnectionInfo
         *        <p>
         *        Description of the VPC connection for CreateVpcConnection and DeleteVpcConnection operations.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcConnectionInfo(VpcConnectionInfo vpcConnectionInfo);

        /**
         *
         * <p>
         * Description of the VPC connection for CreateVpcConnection and DeleteVpcConnection operations.
         * </p>
         * This is a convenience method that creates an instance of the {@link VpcConnectionInfo.Builder} avoiding the
         * need to create one manually via {@link VpcConnectionInfo#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VpcConnectionInfo.Builder#build()} is called immediately and its
         * result is passed to {@link #vpcConnectionInfo(VpcConnectionInfo)}.
         * 
         * @param vpcConnectionInfo
         *        a consumer that will call methods on {@link VpcConnectionInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vpcConnectionInfo(VpcConnectionInfo)
         */
        default Builder vpcConnectionInfo(Consumer<VpcConnectionInfo.Builder> vpcConnectionInfo) {
            return vpcConnectionInfo(VpcConnectionInfo.builder().applyMutation(vpcConnectionInfo).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private List<ClusterOperationStep> operationSteps = DefaultSdkAutoConstructList.getInstance();

        private MutableClusterInfo sourceClusterInfo;

        private MutableClusterInfo targetClusterInfo;

        private VpcConnectionInfo vpcConnectionInfo;

        private BuilderImpl() {
        }

        private BuilderImpl(ClusterOperationV2Provisioned model) {
            operationSteps(model.operationSteps);
            sourceClusterInfo(model.sourceClusterInfo);
            targetClusterInfo(model.targetClusterInfo);
            vpcConnectionInfo(model.vpcConnectionInfo);
        }

        public final List<ClusterOperationStep.Builder> getOperationSteps() {
            List<ClusterOperationStep.Builder> result = ___listOfClusterOperationStepCopier.copyToBuilder(this.operationSteps);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOperationSteps(Collection<ClusterOperationStep.BuilderImpl> operationSteps) {
            this.operationSteps = ___listOfClusterOperationStepCopier.copyFromBuilder(operationSteps);
        }

        @Override
        public final Builder operationSteps(Collection<ClusterOperationStep> operationSteps) {
            this.operationSteps = ___listOfClusterOperationStepCopier.copy(operationSteps);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder operationSteps(ClusterOperationStep... operationSteps) {
            operationSteps(Arrays.asList(operationSteps));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder operationSteps(Consumer<ClusterOperationStep.Builder>... operationSteps) {
            operationSteps(Stream.of(operationSteps).map(c -> ClusterOperationStep.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final MutableClusterInfo.Builder getSourceClusterInfo() {
            return sourceClusterInfo != null ? sourceClusterInfo.toBuilder() : null;
        }

        public final void setSourceClusterInfo(MutableClusterInfo.BuilderImpl sourceClusterInfo) {
            this.sourceClusterInfo = sourceClusterInfo != null ? sourceClusterInfo.build() : null;
        }

        @Override
        public final Builder sourceClusterInfo(MutableClusterInfo sourceClusterInfo) {
            this.sourceClusterInfo = sourceClusterInfo;
            return this;
        }

        public final MutableClusterInfo.Builder getTargetClusterInfo() {
            return targetClusterInfo != null ? targetClusterInfo.toBuilder() : null;
        }

        public final void setTargetClusterInfo(MutableClusterInfo.BuilderImpl targetClusterInfo) {
            this.targetClusterInfo = targetClusterInfo != null ? targetClusterInfo.build() : null;
        }

        @Override
        public final Builder targetClusterInfo(MutableClusterInfo targetClusterInfo) {
            this.targetClusterInfo = targetClusterInfo;
            return this;
        }

        public final VpcConnectionInfo.Builder getVpcConnectionInfo() {
            return vpcConnectionInfo != null ? vpcConnectionInfo.toBuilder() : null;
        }

        public final void setVpcConnectionInfo(VpcConnectionInfo.BuilderImpl vpcConnectionInfo) {
            this.vpcConnectionInfo = vpcConnectionInfo != null ? vpcConnectionInfo.build() : null;
        }

        @Override
        public final Builder vpcConnectionInfo(VpcConnectionInfo vpcConnectionInfo) {
            this.vpcConnectionInfo = vpcConnectionInfo;
            return this;
        }

        @Override
        public ClusterOperationV2Provisioned build() {
            return new ClusterOperationV2Provisioned(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
