/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kafka.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 *
 * <p>
 * Contains source Apache Kafka versions and compatible target Apache Kafka versions.
 * </p>
 * 
 */
@Generated("software.amazon.awssdk:codegen")
public final class CompatibleKafkaVersion implements SdkPojo, Serializable,
        ToCopyableBuilder<CompatibleKafkaVersion.Builder, CompatibleKafkaVersion> {
    private static final SdkField<String> SOURCE_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceVersion").getter(getter(CompatibleKafkaVersion::sourceVersion))
            .setter(setter(Builder::sourceVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceVersion").build()).build();

    private static final SdkField<List<String>> TARGET_VERSIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("TargetVersions")
            .getter(getter(CompatibleKafkaVersion::targetVersions))
            .setter(setter(Builder::targetVersions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetVersions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_VERSION_FIELD,
            TARGET_VERSIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String sourceVersion;

    private final List<String> targetVersions;

    private CompatibleKafkaVersion(BuilderImpl builder) {
        this.sourceVersion = builder.sourceVersion;
        this.targetVersions = builder.targetVersions;
    }

    /**
     *
     * <p>
     * An Apache Kafka version.
     * </p>
     * 
     * @return <p>
     *         An Apache Kafka version.
     *         </p>
     */
    public final String sourceVersion() {
        return sourceVersion;
    }

    /**
     * For responses, this returns true if the service returned a value for the TargetVersions property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTargetVersions() {
        return targetVersions != null && !(targetVersions instanceof SdkAutoConstructList);
    }

    /**
     *
     * <p>
     * A list of Apache Kafka versions.
     * </p>
     * 
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTargetVersions} method.
     * </p>
     * 
     * @return <p>
     *         A list of Apache Kafka versions.
     *         </p>
     */
    public final List<String> targetVersions() {
        return targetVersions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(sourceVersion());
        hashCode = 31 * hashCode + Objects.hashCode(hasTargetVersions() ? targetVersions() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CompatibleKafkaVersion)) {
            return false;
        }
        CompatibleKafkaVersion other = (CompatibleKafkaVersion) obj;
        return Objects.equals(sourceVersion(), other.sourceVersion()) && hasTargetVersions() == other.hasTargetVersions()
                && Objects.equals(targetVersions(), other.targetVersions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CompatibleKafkaVersion").add("SourceVersion", sourceVersion())
                .add("TargetVersions", hasTargetVersions() ? targetVersions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SourceVersion":
            return Optional.ofNullable(clazz.cast(sourceVersion()));
        case "TargetVersions":
            return Optional.ofNullable(clazz.cast(targetVersions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("sourceVersion", SOURCE_VERSION_FIELD);
        map.put("targetVersions", TARGET_VERSIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CompatibleKafkaVersion, T> g) {
        return obj -> g.apply((CompatibleKafkaVersion) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CompatibleKafkaVersion> {
        /**
         *
         * <p>
         * An Apache Kafka version.
         * </p>
         * 
         * @param sourceVersion
         *        <p>
         *        An Apache Kafka version.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceVersion(String sourceVersion);

        /**
         *
         * <p>
         * A list of Apache Kafka versions.
         * </p>
         * 
         * @param targetVersions
         *        <p>
         *        A list of Apache Kafka versions.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetVersions(Collection<String> targetVersions);

        /**
         *
         * <p>
         * A list of Apache Kafka versions.
         * </p>
         * 
         * @param targetVersions
         *        <p>
         *        A list of Apache Kafka versions.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetVersions(String... targetVersions);
    }

    static final class BuilderImpl implements Builder {
        private String sourceVersion;

        private List<String> targetVersions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CompatibleKafkaVersion model) {
            sourceVersion(model.sourceVersion);
            targetVersions(model.targetVersions);
        }

        public final String getSourceVersion() {
            return sourceVersion;
        }

        public final void setSourceVersion(String sourceVersion) {
            this.sourceVersion = sourceVersion;
        }

        @Override
        public final Builder sourceVersion(String sourceVersion) {
            this.sourceVersion = sourceVersion;
            return this;
        }

        public final Collection<String> getTargetVersions() {
            if (targetVersions instanceof SdkAutoConstructList) {
                return null;
            }
            return targetVersions;
        }

        public final void setTargetVersions(Collection<String> targetVersions) {
            this.targetVersions = ___listOf__stringCopier.copy(targetVersions);
        }

        @Override
        public final Builder targetVersions(Collection<String> targetVersions) {
            this.targetVersions = ___listOf__stringCopier.copy(targetVersions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetVersions(String... targetVersions) {
            targetVersions(Arrays.asList(targetVersions));
            return this;
        }

        @Override
        public CompatibleKafkaVersion build() {
            return new CompatibleKafkaVersion(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
