/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kafka.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details about consumer group replication.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ConsumerGroupReplication implements SdkPojo, Serializable,
        ToCopyableBuilder<ConsumerGroupReplication.Builder, ConsumerGroupReplication> {
    private static final SdkField<List<String>> CONSUMER_GROUPS_TO_EXCLUDE_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ConsumerGroupsToExclude")
            .getter(getter(ConsumerGroupReplication::consumerGroupsToExclude))
            .setter(setter(Builder::consumerGroupsToExclude))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("consumerGroupsToExclude").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> CONSUMER_GROUPS_TO_REPLICATE_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ConsumerGroupsToReplicate")
            .getter(getter(ConsumerGroupReplication::consumerGroupsToReplicate))
            .setter(setter(Builder::consumerGroupsToReplicate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("consumerGroupsToReplicate").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> DETECT_AND_COPY_NEW_CONSUMER_GROUPS_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DetectAndCopyNewConsumerGroups")
            .getter(getter(ConsumerGroupReplication::detectAndCopyNewConsumerGroups))
            .setter(setter(Builder::detectAndCopyNewConsumerGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("detectAndCopyNewConsumerGroups")
                    .build()).build();

    private static final SdkField<Boolean> SYNCHRONISE_CONSUMER_GROUP_OFFSETS_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("SynchroniseConsumerGroupOffsets")
            .getter(getter(ConsumerGroupReplication::synchroniseConsumerGroupOffsets))
            .setter(setter(Builder::synchroniseConsumerGroupOffsets))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("synchroniseConsumerGroupOffsets")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CONSUMER_GROUPS_TO_EXCLUDE_FIELD, CONSUMER_GROUPS_TO_REPLICATE_FIELD, DETECT_AND_COPY_NEW_CONSUMER_GROUPS_FIELD,
            SYNCHRONISE_CONSUMER_GROUP_OFFSETS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<String> consumerGroupsToExclude;

    private final List<String> consumerGroupsToReplicate;

    private final Boolean detectAndCopyNewConsumerGroups;

    private final Boolean synchroniseConsumerGroupOffsets;

    private ConsumerGroupReplication(BuilderImpl builder) {
        this.consumerGroupsToExclude = builder.consumerGroupsToExclude;
        this.consumerGroupsToReplicate = builder.consumerGroupsToReplicate;
        this.detectAndCopyNewConsumerGroups = builder.detectAndCopyNewConsumerGroups;
        this.synchroniseConsumerGroupOffsets = builder.synchroniseConsumerGroupOffsets;
    }

    /**
     * For responses, this returns true if the service returned a value for the ConsumerGroupsToExclude property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasConsumerGroupsToExclude() {
        return consumerGroupsToExclude != null && !(consumerGroupsToExclude instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of regular expression patterns indicating the consumer groups that should not be replicated.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasConsumerGroupsToExclude} method.
     * </p>
     * 
     * @return List of regular expression patterns indicating the consumer groups that should not be replicated.
     */
    public final List<String> consumerGroupsToExclude() {
        return consumerGroupsToExclude;
    }

    /**
     * For responses, this returns true if the service returned a value for the ConsumerGroupsToReplicate property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasConsumerGroupsToReplicate() {
        return consumerGroupsToReplicate != null && !(consumerGroupsToReplicate instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of regular expression patterns indicating the consumer groups to copy.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasConsumerGroupsToReplicate} method.
     * </p>
     * 
     * @return List of regular expression patterns indicating the consumer groups to copy.
     */
    public final List<String> consumerGroupsToReplicate() {
        return consumerGroupsToReplicate;
    }

    /**
     * <p>
     * Enables synchronization of consumer groups to target cluster.
     * </p>
     * 
     * @return Enables synchronization of consumer groups to target cluster.
     */
    public final Boolean detectAndCopyNewConsumerGroups() {
        return detectAndCopyNewConsumerGroups;
    }

    /**
     * <p>
     * Enables synchronization of consumer group offsets to target cluster. The translated offsets will be written to
     * topic __consumer_offsets.
     * </p>
     * 
     * @return Enables synchronization of consumer group offsets to target cluster. The translated offsets will be
     *         written to topic __consumer_offsets.
     */
    public final Boolean synchroniseConsumerGroupOffsets() {
        return synchroniseConsumerGroupOffsets;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasConsumerGroupsToExclude() ? consumerGroupsToExclude() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasConsumerGroupsToReplicate() ? consumerGroupsToReplicate() : null);
        hashCode = 31 * hashCode + Objects.hashCode(detectAndCopyNewConsumerGroups());
        hashCode = 31 * hashCode + Objects.hashCode(synchroniseConsumerGroupOffsets());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConsumerGroupReplication)) {
            return false;
        }
        ConsumerGroupReplication other = (ConsumerGroupReplication) obj;
        return hasConsumerGroupsToExclude() == other.hasConsumerGroupsToExclude()
                && Objects.equals(consumerGroupsToExclude(), other.consumerGroupsToExclude())
                && hasConsumerGroupsToReplicate() == other.hasConsumerGroupsToReplicate()
                && Objects.equals(consumerGroupsToReplicate(), other.consumerGroupsToReplicate())
                && Objects.equals(detectAndCopyNewConsumerGroups(), other.detectAndCopyNewConsumerGroups())
                && Objects.equals(synchroniseConsumerGroupOffsets(), other.synchroniseConsumerGroupOffsets());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ConsumerGroupReplication")
                .add("ConsumerGroupsToExclude", hasConsumerGroupsToExclude() ? consumerGroupsToExclude() : null)
                .add("ConsumerGroupsToReplicate", hasConsumerGroupsToReplicate() ? consumerGroupsToReplicate() : null)
                .add("DetectAndCopyNewConsumerGroups", detectAndCopyNewConsumerGroups())
                .add("SynchroniseConsumerGroupOffsets", synchroniseConsumerGroupOffsets()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConsumerGroupsToExclude":
            return Optional.ofNullable(clazz.cast(consumerGroupsToExclude()));
        case "ConsumerGroupsToReplicate":
            return Optional.ofNullable(clazz.cast(consumerGroupsToReplicate()));
        case "DetectAndCopyNewConsumerGroups":
            return Optional.ofNullable(clazz.cast(detectAndCopyNewConsumerGroups()));
        case "SynchroniseConsumerGroupOffsets":
            return Optional.ofNullable(clazz.cast(synchroniseConsumerGroupOffsets()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("consumerGroupsToExclude", CONSUMER_GROUPS_TO_EXCLUDE_FIELD);
        map.put("consumerGroupsToReplicate", CONSUMER_GROUPS_TO_REPLICATE_FIELD);
        map.put("detectAndCopyNewConsumerGroups", DETECT_AND_COPY_NEW_CONSUMER_GROUPS_FIELD);
        map.put("synchroniseConsumerGroupOffsets", SYNCHRONISE_CONSUMER_GROUP_OFFSETS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ConsumerGroupReplication, T> g) {
        return obj -> g.apply((ConsumerGroupReplication) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ConsumerGroupReplication> {
        /**
         * <p>
         * List of regular expression patterns indicating the consumer groups that should not be replicated.
         * </p>
         * 
         * @param consumerGroupsToExclude
         *        List of regular expression patterns indicating the consumer groups that should not be replicated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder consumerGroupsToExclude(Collection<String> consumerGroupsToExclude);

        /**
         * <p>
         * List of regular expression patterns indicating the consumer groups that should not be replicated.
         * </p>
         * 
         * @param consumerGroupsToExclude
         *        List of regular expression patterns indicating the consumer groups that should not be replicated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder consumerGroupsToExclude(String... consumerGroupsToExclude);

        /**
         * <p>
         * List of regular expression patterns indicating the consumer groups to copy.
         * </p>
         * 
         * @param consumerGroupsToReplicate
         *        List of regular expression patterns indicating the consumer groups to copy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder consumerGroupsToReplicate(Collection<String> consumerGroupsToReplicate);

        /**
         * <p>
         * List of regular expression patterns indicating the consumer groups to copy.
         * </p>
         * 
         * @param consumerGroupsToReplicate
         *        List of regular expression patterns indicating the consumer groups to copy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder consumerGroupsToReplicate(String... consumerGroupsToReplicate);

        /**
         * <p>
         * Enables synchronization of consumer groups to target cluster.
         * </p>
         * 
         * @param detectAndCopyNewConsumerGroups
         *        Enables synchronization of consumer groups to target cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder detectAndCopyNewConsumerGroups(Boolean detectAndCopyNewConsumerGroups);

        /**
         * <p>
         * Enables synchronization of consumer group offsets to target cluster. The translated offsets will be written
         * to topic __consumer_offsets.
         * </p>
         * 
         * @param synchroniseConsumerGroupOffsets
         *        Enables synchronization of consumer group offsets to target cluster. The translated offsets will be
         *        written to topic __consumer_offsets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder synchroniseConsumerGroupOffsets(Boolean synchroniseConsumerGroupOffsets);
    }

    static final class BuilderImpl implements Builder {
        private List<String> consumerGroupsToExclude = DefaultSdkAutoConstructList.getInstance();

        private List<String> consumerGroupsToReplicate = DefaultSdkAutoConstructList.getInstance();

        private Boolean detectAndCopyNewConsumerGroups;

        private Boolean synchroniseConsumerGroupOffsets;

        private BuilderImpl() {
        }

        private BuilderImpl(ConsumerGroupReplication model) {
            consumerGroupsToExclude(model.consumerGroupsToExclude);
            consumerGroupsToReplicate(model.consumerGroupsToReplicate);
            detectAndCopyNewConsumerGroups(model.detectAndCopyNewConsumerGroups);
            synchroniseConsumerGroupOffsets(model.synchroniseConsumerGroupOffsets);
        }

        public final Collection<String> getConsumerGroupsToExclude() {
            if (consumerGroupsToExclude instanceof SdkAutoConstructList) {
                return null;
            }
            return consumerGroupsToExclude;
        }

        public final void setConsumerGroupsToExclude(Collection<String> consumerGroupsToExclude) {
            this.consumerGroupsToExclude = ___listOf__stringMax256Copier.copy(consumerGroupsToExclude);
        }

        @Override
        public final Builder consumerGroupsToExclude(Collection<String> consumerGroupsToExclude) {
            this.consumerGroupsToExclude = ___listOf__stringMax256Copier.copy(consumerGroupsToExclude);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder consumerGroupsToExclude(String... consumerGroupsToExclude) {
            consumerGroupsToExclude(Arrays.asList(consumerGroupsToExclude));
            return this;
        }

        public final Collection<String> getConsumerGroupsToReplicate() {
            if (consumerGroupsToReplicate instanceof SdkAutoConstructList) {
                return null;
            }
            return consumerGroupsToReplicate;
        }

        public final void setConsumerGroupsToReplicate(Collection<String> consumerGroupsToReplicate) {
            this.consumerGroupsToReplicate = ___listOf__stringMax256Copier.copy(consumerGroupsToReplicate);
        }

        @Override
        public final Builder consumerGroupsToReplicate(Collection<String> consumerGroupsToReplicate) {
            this.consumerGroupsToReplicate = ___listOf__stringMax256Copier.copy(consumerGroupsToReplicate);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder consumerGroupsToReplicate(String... consumerGroupsToReplicate) {
            consumerGroupsToReplicate(Arrays.asList(consumerGroupsToReplicate));
            return this;
        }

        public final Boolean getDetectAndCopyNewConsumerGroups() {
            return detectAndCopyNewConsumerGroups;
        }

        public final void setDetectAndCopyNewConsumerGroups(Boolean detectAndCopyNewConsumerGroups) {
            this.detectAndCopyNewConsumerGroups = detectAndCopyNewConsumerGroups;
        }

        @Override
        public final Builder detectAndCopyNewConsumerGroups(Boolean detectAndCopyNewConsumerGroups) {
            this.detectAndCopyNewConsumerGroups = detectAndCopyNewConsumerGroups;
            return this;
        }

        public final Boolean getSynchroniseConsumerGroupOffsets() {
            return synchroniseConsumerGroupOffsets;
        }

        public final void setSynchroniseConsumerGroupOffsets(Boolean synchroniseConsumerGroupOffsets) {
            this.synchroniseConsumerGroupOffsets = synchroniseConsumerGroupOffsets;
        }

        @Override
        public final Builder synchroniseConsumerGroupOffsets(Boolean synchroniseConsumerGroupOffsets) {
            this.synchroniseConsumerGroupOffsets = synchroniseConsumerGroupOffsets;
            return this;
        }

        @Override
        public ConsumerGroupReplication build() {
            return new ConsumerGroupReplication(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
