/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kafka.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Creates a replicator using the specified configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateReplicatorRequest extends KafkaRequest implements
        ToCopyableBuilder<CreateReplicatorRequest.Builder, CreateReplicatorRequest> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(CreateReplicatorRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<List<KafkaCluster>> KAFKA_CLUSTERS_FIELD = SdkField
            .<List<KafkaCluster>> builder(MarshallingType.LIST)
            .memberName("KafkaClusters")
            .getter(getter(CreateReplicatorRequest::kafkaClusters))
            .setter(setter(Builder::kafkaClusters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kafkaClusters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<KafkaCluster> builder(MarshallingType.SDK_POJO)
                                            .constructor(KafkaCluster::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<ReplicationInfo>> REPLICATION_INFO_LIST_FIELD = SdkField
            .<List<ReplicationInfo>> builder(MarshallingType.LIST)
            .memberName("ReplicationInfoList")
            .getter(getter(CreateReplicatorRequest::replicationInfoList))
            .setter(setter(Builder::replicationInfoList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("replicationInfoList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ReplicationInfo> builder(MarshallingType.SDK_POJO)
                                            .constructor(ReplicationInfo::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> REPLICATOR_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ReplicatorName").getter(getter(CreateReplicatorRequest::replicatorName))
            .setter(setter(Builder::replicatorName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("replicatorName").build()).build();

    private static final SdkField<String> SERVICE_EXECUTION_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ServiceExecutionRoleArn").getter(getter(CreateReplicatorRequest::serviceExecutionRoleArn))
            .setter(setter(Builder::serviceExecutionRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceExecutionRoleArn").build())
            .build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(CreateReplicatorRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD,
            KAFKA_CLUSTERS_FIELD, REPLICATION_INFO_LIST_FIELD, REPLICATOR_NAME_FIELD, SERVICE_EXECUTION_ROLE_ARN_FIELD,
            TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String description;

    private final List<KafkaCluster> kafkaClusters;

    private final List<ReplicationInfo> replicationInfoList;

    private final String replicatorName;

    private final String serviceExecutionRoleArn;

    private final Map<String, String> tags;

    private CreateReplicatorRequest(BuilderImpl builder) {
        super(builder);
        this.description = builder.description;
        this.kafkaClusters = builder.kafkaClusters;
        this.replicationInfoList = builder.replicationInfoList;
        this.replicatorName = builder.replicatorName;
        this.serviceExecutionRoleArn = builder.serviceExecutionRoleArn;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * A summary description of the replicator.
     * </p>
     * 
     * @return A summary description of the replicator.
     */
    public final String description() {
        return description;
    }

    /**
     * For responses, this returns true if the service returned a value for the KafkaClusters property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasKafkaClusters() {
        return kafkaClusters != null && !(kafkaClusters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Kafka Clusters to use in setting up sources / targets for replication.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasKafkaClusters} method.
     * </p>
     * 
     * @return Kafka Clusters to use in setting up sources / targets for replication.
     */
    public final List<KafkaCluster> kafkaClusters() {
        return kafkaClusters;
    }

    /**
     * For responses, this returns true if the service returned a value for the ReplicationInfoList property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasReplicationInfoList() {
        return replicationInfoList != null && !(replicationInfoList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of replication configurations, where each configuration targets a given source cluster to target cluster
     * replication flow.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasReplicationInfoList} method.
     * </p>
     * 
     * @return A list of replication configurations, where each configuration targets a given source cluster to target
     *         cluster replication flow.
     */
    public final List<ReplicationInfo> replicationInfoList() {
        return replicationInfoList;
    }

    /**
     * <p>
     * The name of the replicator. Alpha-numeric characters with '-' are allowed.
     * </p>
     * 
     * @return The name of the replicator. Alpha-numeric characters with '-' are allowed.
     */
    public final String replicatorName() {
        return replicatorName;
    }

    /**
     * <p>
     * The ARN of the IAM role used by the replicator to access resources in the customer's account (e.g source and
     * target clusters)
     * </p>
     * 
     * @return The ARN of the IAM role used by the replicator to access resources in the customer's account (e.g source
     *         and target clusters)
     */
    public final String serviceExecutionRoleArn() {
        return serviceExecutionRoleArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * List of tags to attach to created Replicator.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return List of tags to attach to created Replicator.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(hasKafkaClusters() ? kafkaClusters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasReplicationInfoList() ? replicationInfoList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(replicatorName());
        hashCode = 31 * hashCode + Objects.hashCode(serviceExecutionRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateReplicatorRequest)) {
            return false;
        }
        CreateReplicatorRequest other = (CreateReplicatorRequest) obj;
        return Objects.equals(description(), other.description()) && hasKafkaClusters() == other.hasKafkaClusters()
                && Objects.equals(kafkaClusters(), other.kafkaClusters())
                && hasReplicationInfoList() == other.hasReplicationInfoList()
                && Objects.equals(replicationInfoList(), other.replicationInfoList())
                && Objects.equals(replicatorName(), other.replicatorName())
                && Objects.equals(serviceExecutionRoleArn(), other.serviceExecutionRoleArn()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateReplicatorRequest").add("Description", description())
                .add("KafkaClusters", hasKafkaClusters() ? kafkaClusters() : null)
                .add("ReplicationInfoList", hasReplicationInfoList() ? replicationInfoList() : null)
                .add("ReplicatorName", replicatorName()).add("ServiceExecutionRoleArn", serviceExecutionRoleArn())
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "KafkaClusters":
            return Optional.ofNullable(clazz.cast(kafkaClusters()));
        case "ReplicationInfoList":
            return Optional.ofNullable(clazz.cast(replicationInfoList()));
        case "ReplicatorName":
            return Optional.ofNullable(clazz.cast(replicatorName()));
        case "ServiceExecutionRoleArn":
            return Optional.ofNullable(clazz.cast(serviceExecutionRoleArn()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("description", DESCRIPTION_FIELD);
        map.put("kafkaClusters", KAFKA_CLUSTERS_FIELD);
        map.put("replicationInfoList", REPLICATION_INFO_LIST_FIELD);
        map.put("replicatorName", REPLICATOR_NAME_FIELD);
        map.put("serviceExecutionRoleArn", SERVICE_EXECUTION_ROLE_ARN_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateReplicatorRequest, T> g) {
        return obj -> g.apply((CreateReplicatorRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends KafkaRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateReplicatorRequest> {
        /**
         * <p>
         * A summary description of the replicator.
         * </p>
         * 
         * @param description
         *        A summary description of the replicator.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Kafka Clusters to use in setting up sources / targets for replication.
         * </p>
         * 
         * @param kafkaClusters
         *        Kafka Clusters to use in setting up sources / targets for replication.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kafkaClusters(Collection<KafkaCluster> kafkaClusters);

        /**
         * <p>
         * Kafka Clusters to use in setting up sources / targets for replication.
         * </p>
         * 
         * @param kafkaClusters
         *        Kafka Clusters to use in setting up sources / targets for replication.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kafkaClusters(KafkaCluster... kafkaClusters);

        /**
         * <p>
         * Kafka Clusters to use in setting up sources / targets for replication.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.kafka.model.KafkaCluster.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.kafka.model.KafkaCluster#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.kafka.model.KafkaCluster.Builder#build()} is called immediately and
         * its result is passed to {@link #kafkaClusters(List<KafkaCluster>)}.
         * 
         * @param kafkaClusters
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.kafka.model.KafkaCluster.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #kafkaClusters(java.util.Collection<KafkaCluster>)
         */
        Builder kafkaClusters(Consumer<KafkaCluster.Builder>... kafkaClusters);

        /**
         * <p>
         * A list of replication configurations, where each configuration targets a given source cluster to target
         * cluster replication flow.
         * </p>
         * 
         * @param replicationInfoList
         *        A list of replication configurations, where each configuration targets a given source cluster to
         *        target cluster replication flow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicationInfoList(Collection<ReplicationInfo> replicationInfoList);

        /**
         * <p>
         * A list of replication configurations, where each configuration targets a given source cluster to target
         * cluster replication flow.
         * </p>
         * 
         * @param replicationInfoList
         *        A list of replication configurations, where each configuration targets a given source cluster to
         *        target cluster replication flow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicationInfoList(ReplicationInfo... replicationInfoList);

        /**
         * <p>
         * A list of replication configurations, where each configuration targets a given source cluster to target
         * cluster replication flow.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.kafka.model.ReplicationInfo.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.kafka.model.ReplicationInfo#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.kafka.model.ReplicationInfo.Builder#build()} is called immediately and
         * its result is passed to {@link #replicationInfoList(List<ReplicationInfo>)}.
         * 
         * @param replicationInfoList
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.kafka.model.ReplicationInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #replicationInfoList(java.util.Collection<ReplicationInfo>)
         */
        Builder replicationInfoList(Consumer<ReplicationInfo.Builder>... replicationInfoList);

        /**
         * <p>
         * The name of the replicator. Alpha-numeric characters with '-' are allowed.
         * </p>
         * 
         * @param replicatorName
         *        The name of the replicator. Alpha-numeric characters with '-' are allowed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicatorName(String replicatorName);

        /**
         * <p>
         * The ARN of the IAM role used by the replicator to access resources in the customer's account (e.g source and
         * target clusters)
         * </p>
         * 
         * @param serviceExecutionRoleArn
         *        The ARN of the IAM role used by the replicator to access resources in the customer's account (e.g
         *        source and target clusters)
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceExecutionRoleArn(String serviceExecutionRoleArn);

        /**
         * <p>
         * List of tags to attach to created Replicator.
         * </p>
         * 
         * @param tags
         *        List of tags to attach to created Replicator.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends KafkaRequest.BuilderImpl implements Builder {
        private String description;

        private List<KafkaCluster> kafkaClusters = DefaultSdkAutoConstructList.getInstance();

        private List<ReplicationInfo> replicationInfoList = DefaultSdkAutoConstructList.getInstance();

        private String replicatorName;

        private String serviceExecutionRoleArn;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateReplicatorRequest model) {
            super(model);
            description(model.description);
            kafkaClusters(model.kafkaClusters);
            replicationInfoList(model.replicationInfoList);
            replicatorName(model.replicatorName);
            serviceExecutionRoleArn(model.serviceExecutionRoleArn);
            tags(model.tags);
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final List<KafkaCluster.Builder> getKafkaClusters() {
            List<KafkaCluster.Builder> result = ___listOfKafkaClusterCopier.copyToBuilder(this.kafkaClusters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setKafkaClusters(Collection<KafkaCluster.BuilderImpl> kafkaClusters) {
            this.kafkaClusters = ___listOfKafkaClusterCopier.copyFromBuilder(kafkaClusters);
        }

        @Override
        public final Builder kafkaClusters(Collection<KafkaCluster> kafkaClusters) {
            this.kafkaClusters = ___listOfKafkaClusterCopier.copy(kafkaClusters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder kafkaClusters(KafkaCluster... kafkaClusters) {
            kafkaClusters(Arrays.asList(kafkaClusters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder kafkaClusters(Consumer<KafkaCluster.Builder>... kafkaClusters) {
            kafkaClusters(Stream.of(kafkaClusters).map(c -> KafkaCluster.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<ReplicationInfo.Builder> getReplicationInfoList() {
            List<ReplicationInfo.Builder> result = ___listOfReplicationInfoCopier.copyToBuilder(this.replicationInfoList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setReplicationInfoList(Collection<ReplicationInfo.BuilderImpl> replicationInfoList) {
            this.replicationInfoList = ___listOfReplicationInfoCopier.copyFromBuilder(replicationInfoList);
        }

        @Override
        public final Builder replicationInfoList(Collection<ReplicationInfo> replicationInfoList) {
            this.replicationInfoList = ___listOfReplicationInfoCopier.copy(replicationInfoList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replicationInfoList(ReplicationInfo... replicationInfoList) {
            replicationInfoList(Arrays.asList(replicationInfoList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replicationInfoList(Consumer<ReplicationInfo.Builder>... replicationInfoList) {
            replicationInfoList(Stream.of(replicationInfoList).map(c -> ReplicationInfo.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getReplicatorName() {
            return replicatorName;
        }

        public final void setReplicatorName(String replicatorName) {
            this.replicatorName = replicatorName;
        }

        @Override
        public final Builder replicatorName(String replicatorName) {
            this.replicatorName = replicatorName;
            return this;
        }

        public final String getServiceExecutionRoleArn() {
            return serviceExecutionRoleArn;
        }

        public final void setServiceExecutionRoleArn(String serviceExecutionRoleArn) {
            this.serviceExecutionRoleArn = serviceExecutionRoleArn;
        }

        @Override
        public final Builder serviceExecutionRoleArn(String serviceExecutionRoleArn) {
            this.serviceExecutionRoleArn = serviceExecutionRoleArn;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = ___mapOf__stringCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = ___mapOf__stringCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateReplicatorRequest build() {
            return new CreateReplicatorRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
