/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kafka.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteVpcConnectionResponse extends KafkaResponse implements
        ToCopyableBuilder<DeleteVpcConnectionResponse.Builder, DeleteVpcConnectionResponse> {
    private static final SdkField<String> VPC_CONNECTION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VpcConnectionArn").getter(getter(DeleteVpcConnectionResponse::vpcConnectionArn))
            .setter(setter(Builder::vpcConnectionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpcConnectionArn").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("State")
            .getter(getter(DeleteVpcConnectionResponse::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VPC_CONNECTION_ARN_FIELD,
            STATE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String vpcConnectionArn;

    private final String state;

    private DeleteVpcConnectionResponse(BuilderImpl builder) {
        super(builder);
        this.vpcConnectionArn = builder.vpcConnectionArn;
        this.state = builder.state;
    }

    /**
     *
     * <p>
     * The Amazon Resource Name (ARN) that uniquely identifies an MSK VPC connection.
     * </p>
     * 
     * @return <p>
     *         The Amazon Resource Name (ARN) that uniquely identifies an MSK VPC connection.
     *         </p>
     */
    public final String vpcConnectionArn() {
        return vpcConnectionArn;
    }

    /**
     *
     * <p>
     * The state of the VPC connection.
     * </p>
     * 
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link VpcConnectionState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return <p>
     *         The state of the VPC connection.
     *         </p>
     * @see VpcConnectionState
     */
    public final VpcConnectionState state() {
        return VpcConnectionState.fromValue(state);
    }

    /**
     *
     * <p>
     * The state of the VPC connection.
     * </p>
     * 
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link VpcConnectionState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return <p>
     *         The state of the VPC connection.
     *         </p>
     * @see VpcConnectionState
     */
    public final String stateAsString() {
        return state;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(vpcConnectionArn());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteVpcConnectionResponse)) {
            return false;
        }
        DeleteVpcConnectionResponse other = (DeleteVpcConnectionResponse) obj;
        return Objects.equals(vpcConnectionArn(), other.vpcConnectionArn())
                && Objects.equals(stateAsString(), other.stateAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteVpcConnectionResponse").add("VpcConnectionArn", vpcConnectionArn())
                .add("State", stateAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VpcConnectionArn":
            return Optional.ofNullable(clazz.cast(vpcConnectionArn()));
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("vpcConnectionArn", VPC_CONNECTION_ARN_FIELD);
        map.put("state", STATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteVpcConnectionResponse, T> g) {
        return obj -> g.apply((DeleteVpcConnectionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends KafkaResponse.Builder, SdkPojo, CopyableBuilder<Builder, DeleteVpcConnectionResponse> {
        /**
         *
         * <p>
         * The Amazon Resource Name (ARN) that uniquely identifies an MSK VPC connection.
         * </p>
         * 
         * @param vpcConnectionArn
         *        <p>
         *        The Amazon Resource Name (ARN) that uniquely identifies an MSK VPC connection.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcConnectionArn(String vpcConnectionArn);

        /**
         *
         * <p>
         * The state of the VPC connection.
         * </p>
         * 
         * @param state
         *        <p>
         *        The state of the VPC connection.
         *        </p>
         * @see VpcConnectionState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VpcConnectionState
         */
        Builder state(String state);

        /**
         *
         * <p>
         * The state of the VPC connection.
         * </p>
         * 
         * @param state
         *        <p>
         *        The state of the VPC connection.
         *        </p>
         * @see VpcConnectionState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VpcConnectionState
         */
        Builder state(VpcConnectionState state);
    }

    static final class BuilderImpl extends KafkaResponse.BuilderImpl implements Builder {
        private String vpcConnectionArn;

        private String state;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteVpcConnectionResponse model) {
            super(model);
            vpcConnectionArn(model.vpcConnectionArn);
            state(model.state);
        }

        public final String getVpcConnectionArn() {
            return vpcConnectionArn;
        }

        public final void setVpcConnectionArn(String vpcConnectionArn) {
            this.vpcConnectionArn = vpcConnectionArn;
        }

        @Override
        public final Builder vpcConnectionArn(String vpcConnectionArn) {
            this.vpcConnectionArn = vpcConnectionArn;
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(VpcConnectionState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        @Override
        public DeleteVpcConnectionResponse build() {
            return new DeleteVpcConnectionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
