/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kafka.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListReplicatorsRequest extends KafkaRequest implements
        ToCopyableBuilder<ListReplicatorsRequest.Builder, ListReplicatorsRequest> {
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(ListReplicatorsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListReplicatorsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()).build();

    private static final SdkField<String> REPLICATOR_NAME_FILTER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ReplicatorNameFilter").getter(getter(ListReplicatorsRequest::replicatorNameFilter))
            .setter(setter(Builder::replicatorNameFilter))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("replicatorNameFilter").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAX_RESULTS_FIELD,
            NEXT_TOKEN_FIELD, REPLICATOR_NAME_FILTER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Integer maxResults;

    private final String nextToken;

    private final String replicatorNameFilter;

    private ListReplicatorsRequest(BuilderImpl builder) {
        super(builder);
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.replicatorNameFilter = builder.replicatorNameFilter;
    }

    /**
     * <p>
     * The maximum number of results to return in the response. If there are more results, the response includes a
     * NextToken parameter.
     * </p>
     * 
     * @return The maximum number of results to return in the response. If there are more results, the response includes
     *         a NextToken parameter.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * If the response of ListReplicators is truncated, it returns a NextToken in the response. This NextToken should be
     * sent in the subsequent request to ListReplicators.
     * </p>
     * 
     * @return If the response of ListReplicators is truncated, it returns a NextToken in the response. This NextToken
     *         should be sent in the subsequent request to ListReplicators.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * Returns replicators starting with given name.
     * </p>
     * 
     * @return Returns replicators starting with given name.
     */
    public final String replicatorNameFilter() {
        return replicatorNameFilter;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(replicatorNameFilter());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListReplicatorsRequest)) {
            return false;
        }
        ListReplicatorsRequest other = (ListReplicatorsRequest) obj;
        return Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(replicatorNameFilter(), other.replicatorNameFilter());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListReplicatorsRequest").add("MaxResults", maxResults()).add("NextToken", nextToken())
                .add("ReplicatorNameFilter", replicatorNameFilter()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "ReplicatorNameFilter":
            return Optional.ofNullable(clazz.cast(replicatorNameFilter()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("maxResults", MAX_RESULTS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("replicatorNameFilter", REPLICATOR_NAME_FILTER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListReplicatorsRequest, T> g) {
        return obj -> g.apply((ListReplicatorsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends KafkaRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListReplicatorsRequest> {
        /**
         * <p>
         * The maximum number of results to return in the response. If there are more results, the response includes a
         * NextToken parameter.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to return in the response. If there are more results, the response
         *        includes a NextToken parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * If the response of ListReplicators is truncated, it returns a NextToken in the response. This NextToken
         * should be sent in the subsequent request to ListReplicators.
         * </p>
         * 
         * @param nextToken
         *        If the response of ListReplicators is truncated, it returns a NextToken in the response. This
         *        NextToken should be sent in the subsequent request to ListReplicators.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * Returns replicators starting with given name.
         * </p>
         * 
         * @param replicatorNameFilter
         *        Returns replicators starting with given name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicatorNameFilter(String replicatorNameFilter);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends KafkaRequest.BuilderImpl implements Builder {
        private Integer maxResults;

        private String nextToken;

        private String replicatorNameFilter;

        private BuilderImpl() {
        }

        private BuilderImpl(ListReplicatorsRequest model) {
            super(model);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
            replicatorNameFilter(model.replicatorNameFilter);
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getReplicatorNameFilter() {
            return replicatorNameFilter;
        }

        public final void setReplicatorNameFilter(String replicatorNameFilter) {
            this.replicatorNameFilter = replicatorNameFilter;
        }

        @Override
        public final Builder replicatorNameFilter(String replicatorNameFilter) {
            this.replicatorNameFilter = replicatorNameFilter;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListReplicatorsRequest build() {
            return new ListReplicatorsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
