/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesis.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeStreamConsumerRequest extends KinesisRequest implements
        ToCopyableBuilder<DescribeStreamConsumerRequest.Builder, DescribeStreamConsumerRequest> {
    private static final SdkField<String> STREAM_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StreamARN").getter(getter(DescribeStreamConsumerRequest::streamARN)).setter(setter(Builder::streamARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamARN").build()).build();

    private static final SdkField<String> CONSUMER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConsumerName").getter(getter(DescribeStreamConsumerRequest::consumerName))
            .setter(setter(Builder::consumerName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConsumerName").build()).build();

    private static final SdkField<String> CONSUMER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConsumerARN").getter(getter(DescribeStreamConsumerRequest::consumerARN))
            .setter(setter(Builder::consumerARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConsumerARN").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STREAM_ARN_FIELD,
            CONSUMER_NAME_FIELD, CONSUMER_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String streamARN;

    private final String consumerName;

    private final String consumerARN;

    private DescribeStreamConsumerRequest(BuilderImpl builder) {
        super(builder);
        this.streamARN = builder.streamARN;
        this.consumerName = builder.consumerName;
        this.consumerARN = builder.consumerARN;
    }

    /**
     * <p>
     * The ARN of the Kinesis data stream that the consumer is registered with. For more information, see <a
     * href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#arn-syntax-kinesis-streams"
     * >Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a>.
     * </p>
     * 
     * @return The ARN of the Kinesis data stream that the consumer is registered with. For more information, see <a
     *         href
     *         ="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#arn-syntax-kinesis-streams"
     *         >Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a>.
     */
    public final String streamARN() {
        return streamARN;
    }

    /**
     * <p>
     * The name that you gave to the consumer.
     * </p>
     * 
     * @return The name that you gave to the consumer.
     */
    public final String consumerName() {
        return consumerName;
    }

    /**
     * <p>
     * The ARN returned by Kinesis Data Streams when you registered the consumer.
     * </p>
     * 
     * @return The ARN returned by Kinesis Data Streams when you registered the consumer.
     */
    public final String consumerARN() {
        return consumerARN;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(streamARN());
        hashCode = 31 * hashCode + Objects.hashCode(consumerName());
        hashCode = 31 * hashCode + Objects.hashCode(consumerARN());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeStreamConsumerRequest)) {
            return false;
        }
        DescribeStreamConsumerRequest other = (DescribeStreamConsumerRequest) obj;
        return Objects.equals(streamARN(), other.streamARN()) && Objects.equals(consumerName(), other.consumerName())
                && Objects.equals(consumerARN(), other.consumerARN());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeStreamConsumerRequest").add("StreamARN", streamARN())
                .add("ConsumerName", consumerName()).add("ConsumerARN", consumerARN()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StreamARN":
            return Optional.ofNullable(clazz.cast(streamARN()));
        case "ConsumerName":
            return Optional.ofNullable(clazz.cast(consumerName()));
        case "ConsumerARN":
            return Optional.ofNullable(clazz.cast(consumerARN()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("StreamARN", STREAM_ARN_FIELD);
        map.put("ConsumerName", CONSUMER_NAME_FIELD);
        map.put("ConsumerARN", CONSUMER_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeStreamConsumerRequest, T> g) {
        return obj -> g.apply((DescribeStreamConsumerRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends KinesisRequest.Builder, SdkPojo, CopyableBuilder<Builder, DescribeStreamConsumerRequest> {
        /**
         * <p>
         * The ARN of the Kinesis data stream that the consumer is registered with. For more information, see <a href=
         * "https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#arn-syntax-kinesis-streams"
         * >Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a>.
         * </p>
         * 
         * @param streamARN
         *        The ARN of the Kinesis data stream that the consumer is registered with. For more information, see <a
         *        href=
         *        "https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#arn-syntax-kinesis-streams"
         *        >Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamARN(String streamARN);

        /**
         * <p>
         * The name that you gave to the consumer.
         * </p>
         * 
         * @param consumerName
         *        The name that you gave to the consumer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder consumerName(String consumerName);

        /**
         * <p>
         * The ARN returned by Kinesis Data Streams when you registered the consumer.
         * </p>
         * 
         * @param consumerARN
         *        The ARN returned by Kinesis Data Streams when you registered the consumer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder consumerARN(String consumerARN);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends KinesisRequest.BuilderImpl implements Builder {
        private String streamARN;

        private String consumerName;

        private String consumerARN;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeStreamConsumerRequest model) {
            super(model);
            streamARN(model.streamARN);
            consumerName(model.consumerName);
            consumerARN(model.consumerARN);
        }

        public final String getStreamARN() {
            return streamARN;
        }

        public final void setStreamARN(String streamARN) {
            this.streamARN = streamARN;
        }

        @Override
        public final Builder streamARN(String streamARN) {
            this.streamARN = streamARN;
            return this;
        }

        public final String getConsumerName() {
            return consumerName;
        }

        public final void setConsumerName(String consumerName) {
            this.consumerName = consumerName;
        }

        @Override
        public final Builder consumerName(String consumerName) {
            this.consumerName = consumerName;
            return this;
        }

        public final String getConsumerARN() {
            return consumerARN;
        }

        public final void setConsumerARN(String consumerARN) {
            this.consumerARN = consumerARN;
        }

        @Override
        public final Builder consumerARN(String consumerARN) {
            this.consumerARN = consumerARN;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeStreamConsumerRequest build() {
            return new DescribeStreamConsumerRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
