/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesis.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the output for <a>EnableEnhancedMonitoring</a> and <a>DisableEnhancedMonitoring</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DisableEnhancedMonitoringResponse extends KinesisResponse implements
        ToCopyableBuilder<DisableEnhancedMonitoringResponse.Builder, DisableEnhancedMonitoringResponse> {
    private static final SdkField<String> STREAM_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StreamName").getter(getter(DisableEnhancedMonitoringResponse::streamName))
            .setter(setter(Builder::streamName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamName").build()).build();

    private static final SdkField<List<String>> CURRENT_SHARD_LEVEL_METRICS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("CurrentShardLevelMetrics")
            .getter(getter(DisableEnhancedMonitoringResponse::currentShardLevelMetricsAsStrings))
            .setter(setter(Builder::currentShardLevelMetricsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrentShardLevelMetrics").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> DESIRED_SHARD_LEVEL_METRICS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("DesiredShardLevelMetrics")
            .getter(getter(DisableEnhancedMonitoringResponse::desiredShardLevelMetricsAsStrings))
            .setter(setter(Builder::desiredShardLevelMetricsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DesiredShardLevelMetrics").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> STREAM_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StreamARN").getter(getter(DisableEnhancedMonitoringResponse::streamARN))
            .setter(setter(Builder::streamARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamARN").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STREAM_NAME_FIELD,
            CURRENT_SHARD_LEVEL_METRICS_FIELD, DESIRED_SHARD_LEVEL_METRICS_FIELD, STREAM_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String streamName;

    private final List<String> currentShardLevelMetrics;

    private final List<String> desiredShardLevelMetrics;

    private final String streamARN;

    private DisableEnhancedMonitoringResponse(BuilderImpl builder) {
        super(builder);
        this.streamName = builder.streamName;
        this.currentShardLevelMetrics = builder.currentShardLevelMetrics;
        this.desiredShardLevelMetrics = builder.desiredShardLevelMetrics;
        this.streamARN = builder.streamARN;
    }

    /**
     * <p>
     * The name of the Kinesis data stream.
     * </p>
     * 
     * @return The name of the Kinesis data stream.
     */
    public final String streamName() {
        return streamName;
    }

    /**
     * <p>
     * Represents the current state of the metrics that are in the enhanced state before the operation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCurrentShardLevelMetrics} method.
     * </p>
     * 
     * @return Represents the current state of the metrics that are in the enhanced state before the operation.
     */
    public final List<MetricsName> currentShardLevelMetrics() {
        return MetricsNameListCopier.copyStringToEnum(currentShardLevelMetrics);
    }

    /**
     * For responses, this returns true if the service returned a value for the CurrentShardLevelMetrics property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasCurrentShardLevelMetrics() {
        return currentShardLevelMetrics != null && !(currentShardLevelMetrics instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Represents the current state of the metrics that are in the enhanced state before the operation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCurrentShardLevelMetrics} method.
     * </p>
     * 
     * @return Represents the current state of the metrics that are in the enhanced state before the operation.
     */
    public final List<String> currentShardLevelMetricsAsStrings() {
        return currentShardLevelMetrics;
    }

    /**
     * <p>
     * Represents the list of all the metrics that would be in the enhanced state after the operation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDesiredShardLevelMetrics} method.
     * </p>
     * 
     * @return Represents the list of all the metrics that would be in the enhanced state after the operation.
     */
    public final List<MetricsName> desiredShardLevelMetrics() {
        return MetricsNameListCopier.copyStringToEnum(desiredShardLevelMetrics);
    }

    /**
     * For responses, this returns true if the service returned a value for the DesiredShardLevelMetrics property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasDesiredShardLevelMetrics() {
        return desiredShardLevelMetrics != null && !(desiredShardLevelMetrics instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Represents the list of all the metrics that would be in the enhanced state after the operation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDesiredShardLevelMetrics} method.
     * </p>
     * 
     * @return Represents the list of all the metrics that would be in the enhanced state after the operation.
     */
    public final List<String> desiredShardLevelMetricsAsStrings() {
        return desiredShardLevelMetrics;
    }

    /**
     * <p>
     * The ARN of the stream.
     * </p>
     * 
     * @return The ARN of the stream.
     */
    public final String streamARN() {
        return streamARN;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(streamName());
        hashCode = 31 * hashCode + Objects.hashCode(hasCurrentShardLevelMetrics() ? currentShardLevelMetricsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasDesiredShardLevelMetrics() ? desiredShardLevelMetricsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(streamARN());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DisableEnhancedMonitoringResponse)) {
            return false;
        }
        DisableEnhancedMonitoringResponse other = (DisableEnhancedMonitoringResponse) obj;
        return Objects.equals(streamName(), other.streamName())
                && hasCurrentShardLevelMetrics() == other.hasCurrentShardLevelMetrics()
                && Objects.equals(currentShardLevelMetricsAsStrings(), other.currentShardLevelMetricsAsStrings())
                && hasDesiredShardLevelMetrics() == other.hasDesiredShardLevelMetrics()
                && Objects.equals(desiredShardLevelMetricsAsStrings(), other.desiredShardLevelMetricsAsStrings())
                && Objects.equals(streamARN(), other.streamARN());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DisableEnhancedMonitoringResponse").add("StreamName", streamName())
                .add("CurrentShardLevelMetrics", hasCurrentShardLevelMetrics() ? currentShardLevelMetricsAsStrings() : null)
                .add("DesiredShardLevelMetrics", hasDesiredShardLevelMetrics() ? desiredShardLevelMetricsAsStrings() : null)
                .add("StreamARN", streamARN()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StreamName":
            return Optional.ofNullable(clazz.cast(streamName()));
        case "CurrentShardLevelMetrics":
            return Optional.ofNullable(clazz.cast(currentShardLevelMetricsAsStrings()));
        case "DesiredShardLevelMetrics":
            return Optional.ofNullable(clazz.cast(desiredShardLevelMetricsAsStrings()));
        case "StreamARN":
            return Optional.ofNullable(clazz.cast(streamARN()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("StreamName", STREAM_NAME_FIELD);
        map.put("CurrentShardLevelMetrics", CURRENT_SHARD_LEVEL_METRICS_FIELD);
        map.put("DesiredShardLevelMetrics", DESIRED_SHARD_LEVEL_METRICS_FIELD);
        map.put("StreamARN", STREAM_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DisableEnhancedMonitoringResponse, T> g) {
        return obj -> g.apply((DisableEnhancedMonitoringResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends KinesisResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DisableEnhancedMonitoringResponse> {
        /**
         * <p>
         * The name of the Kinesis data stream.
         * </p>
         * 
         * @param streamName
         *        The name of the Kinesis data stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamName(String streamName);

        /**
         * <p>
         * Represents the current state of the metrics that are in the enhanced state before the operation.
         * </p>
         * 
         * @param currentShardLevelMetrics
         *        Represents the current state of the metrics that are in the enhanced state before the operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currentShardLevelMetricsWithStrings(Collection<String> currentShardLevelMetrics);

        /**
         * <p>
         * Represents the current state of the metrics that are in the enhanced state before the operation.
         * </p>
         * 
         * @param currentShardLevelMetrics
         *        Represents the current state of the metrics that are in the enhanced state before the operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currentShardLevelMetricsWithStrings(String... currentShardLevelMetrics);

        /**
         * <p>
         * Represents the current state of the metrics that are in the enhanced state before the operation.
         * </p>
         * 
         * @param currentShardLevelMetrics
         *        Represents the current state of the metrics that are in the enhanced state before the operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currentShardLevelMetrics(Collection<MetricsName> currentShardLevelMetrics);

        /**
         * <p>
         * Represents the current state of the metrics that are in the enhanced state before the operation.
         * </p>
         * 
         * @param currentShardLevelMetrics
         *        Represents the current state of the metrics that are in the enhanced state before the operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currentShardLevelMetrics(MetricsName... currentShardLevelMetrics);

        /**
         * <p>
         * Represents the list of all the metrics that would be in the enhanced state after the operation.
         * </p>
         * 
         * @param desiredShardLevelMetrics
         *        Represents the list of all the metrics that would be in the enhanced state after the operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder desiredShardLevelMetricsWithStrings(Collection<String> desiredShardLevelMetrics);

        /**
         * <p>
         * Represents the list of all the metrics that would be in the enhanced state after the operation.
         * </p>
         * 
         * @param desiredShardLevelMetrics
         *        Represents the list of all the metrics that would be in the enhanced state after the operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder desiredShardLevelMetricsWithStrings(String... desiredShardLevelMetrics);

        /**
         * <p>
         * Represents the list of all the metrics that would be in the enhanced state after the operation.
         * </p>
         * 
         * @param desiredShardLevelMetrics
         *        Represents the list of all the metrics that would be in the enhanced state after the operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder desiredShardLevelMetrics(Collection<MetricsName> desiredShardLevelMetrics);

        /**
         * <p>
         * Represents the list of all the metrics that would be in the enhanced state after the operation.
         * </p>
         * 
         * @param desiredShardLevelMetrics
         *        Represents the list of all the metrics that would be in the enhanced state after the operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder desiredShardLevelMetrics(MetricsName... desiredShardLevelMetrics);

        /**
         * <p>
         * The ARN of the stream.
         * </p>
         * 
         * @param streamARN
         *        The ARN of the stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamARN(String streamARN);
    }

    static final class BuilderImpl extends KinesisResponse.BuilderImpl implements Builder {
        private String streamName;

        private List<String> currentShardLevelMetrics = DefaultSdkAutoConstructList.getInstance();

        private List<String> desiredShardLevelMetrics = DefaultSdkAutoConstructList.getInstance();

        private String streamARN;

        private BuilderImpl() {
        }

        private BuilderImpl(DisableEnhancedMonitoringResponse model) {
            super(model);
            streamName(model.streamName);
            currentShardLevelMetricsWithStrings(model.currentShardLevelMetrics);
            desiredShardLevelMetricsWithStrings(model.desiredShardLevelMetrics);
            streamARN(model.streamARN);
        }

        public final String getStreamName() {
            return streamName;
        }

        public final void setStreamName(String streamName) {
            this.streamName = streamName;
        }

        @Override
        public final Builder streamName(String streamName) {
            this.streamName = streamName;
            return this;
        }

        public final Collection<String> getCurrentShardLevelMetrics() {
            if (currentShardLevelMetrics instanceof SdkAutoConstructList) {
                return null;
            }
            return currentShardLevelMetrics;
        }

        public final void setCurrentShardLevelMetrics(Collection<String> currentShardLevelMetrics) {
            this.currentShardLevelMetrics = MetricsNameListCopier.copy(currentShardLevelMetrics);
        }

        @Override
        public final Builder currentShardLevelMetricsWithStrings(Collection<String> currentShardLevelMetrics) {
            this.currentShardLevelMetrics = MetricsNameListCopier.copy(currentShardLevelMetrics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder currentShardLevelMetricsWithStrings(String... currentShardLevelMetrics) {
            currentShardLevelMetricsWithStrings(Arrays.asList(currentShardLevelMetrics));
            return this;
        }

        @Override
        public final Builder currentShardLevelMetrics(Collection<MetricsName> currentShardLevelMetrics) {
            this.currentShardLevelMetrics = MetricsNameListCopier.copyEnumToString(currentShardLevelMetrics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder currentShardLevelMetrics(MetricsName... currentShardLevelMetrics) {
            currentShardLevelMetrics(Arrays.asList(currentShardLevelMetrics));
            return this;
        }

        public final Collection<String> getDesiredShardLevelMetrics() {
            if (desiredShardLevelMetrics instanceof SdkAutoConstructList) {
                return null;
            }
            return desiredShardLevelMetrics;
        }

        public final void setDesiredShardLevelMetrics(Collection<String> desiredShardLevelMetrics) {
            this.desiredShardLevelMetrics = MetricsNameListCopier.copy(desiredShardLevelMetrics);
        }

        @Override
        public final Builder desiredShardLevelMetricsWithStrings(Collection<String> desiredShardLevelMetrics) {
            this.desiredShardLevelMetrics = MetricsNameListCopier.copy(desiredShardLevelMetrics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder desiredShardLevelMetricsWithStrings(String... desiredShardLevelMetrics) {
            desiredShardLevelMetricsWithStrings(Arrays.asList(desiredShardLevelMetrics));
            return this;
        }

        @Override
        public final Builder desiredShardLevelMetrics(Collection<MetricsName> desiredShardLevelMetrics) {
            this.desiredShardLevelMetrics = MetricsNameListCopier.copyEnumToString(desiredShardLevelMetrics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder desiredShardLevelMetrics(MetricsName... desiredShardLevelMetrics) {
            desiredShardLevelMetrics(Arrays.asList(desiredShardLevelMetrics));
            return this;
        }

        public final String getStreamARN() {
            return streamARN;
        }

        public final void setStreamARN(String streamARN) {
            this.streamARN = streamARN;
        }

        @Override
        public final Builder streamARN(String streamARN) {
            this.streamARN = streamARN;
            return this;
        }

        @Override
        public DisableEnhancedMonitoringResponse build() {
            return new DisableEnhancedMonitoringResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
