/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesis.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.kinesis.model.KinesisRequest;
import software.amazon.awssdk.services.kinesis.model.StartingPosition;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SubscribeToShardRequest
extends KinesisRequest
implements ToCopyableBuilder<Builder, SubscribeToShardRequest> {
    private static final SdkField<String> CONSUMER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConsumerARN").getter(SubscribeToShardRequest.getter(SubscribeToShardRequest::consumerARN)).setter(SubscribeToShardRequest.setter(Builder::consumerARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConsumerARN").build()}).build();
    private static final SdkField<String> SHARD_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ShardId").getter(SubscribeToShardRequest.getter(SubscribeToShardRequest::shardId)).setter(SubscribeToShardRequest.setter(Builder::shardId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ShardId").build()}).build();
    private static final SdkField<StartingPosition> STARTING_POSITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("StartingPosition").getter(SubscribeToShardRequest.getter(SubscribeToShardRequest::startingPosition)).setter(SubscribeToShardRequest.setter(Builder::startingPosition)).constructor(StartingPosition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartingPosition").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONSUMER_ARN_FIELD, SHARD_ID_FIELD, STARTING_POSITION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SubscribeToShardRequest.memberNameToFieldInitializer();
    private final String consumerARN;
    private final String shardId;
    private final StartingPosition startingPosition;

    private SubscribeToShardRequest(BuilderImpl builder) {
        super(builder);
        this.consumerARN = builder.consumerARN;
        this.shardId = builder.shardId;
        this.startingPosition = builder.startingPosition;
    }

    public final String consumerARN() {
        return this.consumerARN;
    }

    public final String shardId() {
        return this.shardId;
    }

    public final StartingPosition startingPosition() {
        return this.startingPosition;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.consumerARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.shardId());
        hashCode = 31 * hashCode + Objects.hashCode(this.startingPosition());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SubscribeToShardRequest)) {
            return false;
        }
        SubscribeToShardRequest other = (SubscribeToShardRequest)((Object)obj);
        return Objects.equals(this.consumerARN(), other.consumerARN()) && Objects.equals(this.shardId(), other.shardId()) && Objects.equals(this.startingPosition(), other.startingPosition());
    }

    public final String toString() {
        return ToString.builder((String)"SubscribeToShardRequest").add("ConsumerARN", (Object)this.consumerARN()).add("ShardId", (Object)this.shardId()).add("StartingPosition", (Object)this.startingPosition()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ConsumerARN": {
                return Optional.ofNullable(clazz.cast(this.consumerARN()));
            }
            case "ShardId": {
                return Optional.ofNullable(clazz.cast(this.shardId()));
            }
            case "StartingPosition": {
                return Optional.ofNullable(clazz.cast(this.startingPosition()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ConsumerARN", CONSUMER_ARN_FIELD);
        map.put("ShardId", SHARD_ID_FIELD);
        map.put("StartingPosition", STARTING_POSITION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SubscribeToShardRequest, T> g) {
        return obj -> g.apply((SubscribeToShardRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends KinesisRequest.BuilderImpl
    implements Builder {
        private String consumerARN;
        private String shardId;
        private StartingPosition startingPosition;

        private BuilderImpl() {
        }

        private BuilderImpl(SubscribeToShardRequest model) {
            super(model);
            this.consumerARN(model.consumerARN);
            this.shardId(model.shardId);
            this.startingPosition(model.startingPosition);
        }

        public final String getConsumerARN() {
            return this.consumerARN;
        }

        public final void setConsumerARN(String consumerARN) {
            this.consumerARN = consumerARN;
        }

        @Override
        public final Builder consumerARN(String consumerARN) {
            this.consumerARN = consumerARN;
            return this;
        }

        public final String getShardId() {
            return this.shardId;
        }

        public final void setShardId(String shardId) {
            this.shardId = shardId;
        }

        @Override
        public final Builder shardId(String shardId) {
            this.shardId = shardId;
            return this;
        }

        public final StartingPosition.Builder getStartingPosition() {
            return this.startingPosition != null ? this.startingPosition.toBuilder() : null;
        }

        public final void setStartingPosition(StartingPosition.BuilderImpl startingPosition) {
            this.startingPosition = startingPosition != null ? startingPosition.build() : null;
        }

        @Override
        public final Builder startingPosition(StartingPosition startingPosition) {
            this.startingPosition = startingPosition;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SubscribeToShardRequest build() {
            return new SubscribeToShardRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends KinesisRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, SubscribeToShardRequest> {
        public Builder consumerARN(String var1);

        public Builder shardId(String var1);

        public Builder startingPosition(StartingPosition var1);

        default public Builder startingPosition(Consumer<StartingPosition.Builder> startingPosition) {
            return this.startingPosition((StartingPosition)((StartingPosition.Builder)StartingPosition.builder().applyMutation(startingPosition)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

