/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sns.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Input for <code>SetEndpointAttributes</code> action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SetEndpointAttributesRequest extends SnsRequest implements
        ToCopyableBuilder<SetEndpointAttributesRequest.Builder, SetEndpointAttributesRequest> {
    private static final SdkField<String> ENDPOINT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EndpointArn").getter(getter(SetEndpointAttributesRequest::endpointArn))
            .setter(setter(Builder::endpointArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointArn").build()).build();

    private static final SdkField<Map<String, String>> ATTRIBUTES_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Attributes")
            .getter(getter(SetEndpointAttributesRequest::attributes))
            .setter(setter(Builder::attributes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attributes").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENDPOINT_ARN_FIELD,
            ATTRIBUTES_FIELD));

    private final String endpointArn;

    private final Map<String, String> attributes;

    private SetEndpointAttributesRequest(BuilderImpl builder) {
        super(builder);
        this.endpointArn = builder.endpointArn;
        this.attributes = builder.attributes;
    }

    /**
     * <p>
     * EndpointArn used for <code>SetEndpointAttributes</code> action.
     * </p>
     * 
     * @return EndpointArn used for <code>SetEndpointAttributes</code> action.
     */
    public final String endpointArn() {
        return endpointArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the Attributes property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasAttributes() {
        return attributes != null && !(attributes instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A map of the endpoint attributes. Attributes in this map include the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CustomUserData</code> – arbitrary user data to associate with the endpoint. Amazon SNS does not use this
     * data. The data must be in UTF-8 format and less than 2KB.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Enabled</code> – flag that enables/disables delivery to the endpoint. Amazon SNS will set this to false
     * when a notification service indicates to Amazon SNS that the endpoint is invalid. Users can set it back to true,
     * typically after updating Token.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Token</code> – device token, also referred to as a registration id, for an app and mobile device. This is
     * returned from the notification service when an app and mobile device are registered with the notification
     * service.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAttributes} method.
     * </p>
     * 
     * @return A map of the endpoint attributes. Attributes in this map include the following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>CustomUserData</code> – arbitrary user data to associate with the endpoint. Amazon SNS does not use
     *         this data. The data must be in UTF-8 format and less than 2KB.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Enabled</code> – flag that enables/disables delivery to the endpoint. Amazon SNS will set this to
     *         false when a notification service indicates to Amazon SNS that the endpoint is invalid. Users can set it
     *         back to true, typically after updating Token.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Token</code> – device token, also referred to as a registration id, for an app and mobile device.
     *         This is returned from the notification service when an app and mobile device are registered with the
     *         notification service.
     *         </p>
     *         </li>
     */
    public final Map<String, String> attributes() {
        return attributes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(endpointArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasAttributes() ? attributes() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SetEndpointAttributesRequest)) {
            return false;
        }
        SetEndpointAttributesRequest other = (SetEndpointAttributesRequest) obj;
        return Objects.equals(endpointArn(), other.endpointArn()) && hasAttributes() == other.hasAttributes()
                && Objects.equals(attributes(), other.attributes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SetEndpointAttributesRequest").add("EndpointArn", endpointArn())
                .add("Attributes", hasAttributes() ? attributes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EndpointArn":
            return Optional.ofNullable(clazz.cast(endpointArn()));
        case "Attributes":
            return Optional.ofNullable(clazz.cast(attributes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SetEndpointAttributesRequest, T> g) {
        return obj -> g.apply((SetEndpointAttributesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SnsRequest.Builder, SdkPojo, CopyableBuilder<Builder, SetEndpointAttributesRequest> {
        /**
         * <p>
         * EndpointArn used for <code>SetEndpointAttributes</code> action.
         * </p>
         * 
         * @param endpointArn
         *        EndpointArn used for <code>SetEndpointAttributes</code> action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpointArn(String endpointArn);

        /**
         * <p>
         * A map of the endpoint attributes. Attributes in this map include the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>CustomUserData</code> – arbitrary user data to associate with the endpoint. Amazon SNS does not use
         * this data. The data must be in UTF-8 format and less than 2KB.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Enabled</code> – flag that enables/disables delivery to the endpoint. Amazon SNS will set this to false
         * when a notification service indicates to Amazon SNS that the endpoint is invalid. Users can set it back to
         * true, typically after updating Token.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Token</code> – device token, also referred to as a registration id, for an app and mobile device. This
         * is returned from the notification service when an app and mobile device are registered with the notification
         * service.
         * </p>
         * </li>
         * </ul>
         * 
         * @param attributes
         *        A map of the endpoint attributes. Attributes in this map include the following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>CustomUserData</code> – arbitrary user data to associate with the endpoint. Amazon SNS does not
         *        use this data. The data must be in UTF-8 format and less than 2KB.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Enabled</code> – flag that enables/disables delivery to the endpoint. Amazon SNS will set this
         *        to false when a notification service indicates to Amazon SNS that the endpoint is invalid. Users can
         *        set it back to true, typically after updating Token.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Token</code> – device token, also referred to as a registration id, for an app and mobile
         *        device. This is returned from the notification service when an app and mobile device are registered
         *        with the notification service.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributes(Map<String, String> attributes);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SnsRequest.BuilderImpl implements Builder {
        private String endpointArn;

        private Map<String, String> attributes = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SetEndpointAttributesRequest model) {
            super(model);
            endpointArn(model.endpointArn);
            attributes(model.attributes);
        }

        public final String getEndpointArn() {
            return endpointArn;
        }

        public final void setEndpointArn(String endpointArn) {
            this.endpointArn = endpointArn;
        }

        @Override
        public final Builder endpointArn(String endpointArn) {
            this.endpointArn = endpointArn;
            return this;
        }

        public final Map<String, String> getAttributes() {
            if (attributes instanceof SdkAutoConstructMap) {
                return null;
            }
            return attributes;
        }

        public final void setAttributes(Map<String, String> attributes) {
            this.attributes = MapStringToStringCopier.copy(attributes);
        }

        @Override
        public final Builder attributes(Map<String, String> attributes) {
            this.attributes = MapStringToStringCopier.copy(attributes);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SetEndpointAttributesRequest build() {
            return new SetEndpointAttributesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
