/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An SSM document required by the current document.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DocumentRequires implements SdkPojo, Serializable,
        ToCopyableBuilder<DocumentRequires.Builder, DocumentRequires> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(DocumentRequires::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Version")
            .getter(getter(DocumentRequires::version)).setter(setter(Builder::version))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Version").build()).build();

    private static final SdkField<String> REQUIRE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RequireType").getter(getter(DocumentRequires::requireType)).setter(setter(Builder::requireType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequireType").build()).build();

    private static final SdkField<String> VERSION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VersionName").getter(getter(DocumentRequires::versionName)).setter(setter(Builder::versionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VersionName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, VERSION_FIELD,
            REQUIRE_TYPE_FIELD, VERSION_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String version;

    private final String requireType;

    private final String versionName;

    private DocumentRequires(BuilderImpl builder) {
        this.name = builder.name;
        this.version = builder.version;
        this.requireType = builder.requireType;
        this.versionName = builder.versionName;
    }

    /**
     * <p>
     * The name of the required SSM document. The name can be an Amazon Resource Name (ARN).
     * </p>
     * 
     * @return The name of the required SSM document. The name can be an Amazon Resource Name (ARN).
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The document version required by the current document.
     * </p>
     * 
     * @return The document version required by the current document.
     */
    public final String version() {
        return version;
    }

    /**
     * <p>
     * The document type of the required SSM document.
     * </p>
     * 
     * @return The document type of the required SSM document.
     */
    public final String requireType() {
        return requireType;
    }

    /**
     * <p>
     * An optional field specifying the version of the artifact associated with the document. For example, 12.6. This
     * value is unique across all versions of a document, and can't be changed.
     * </p>
     * 
     * @return An optional field specifying the version of the artifact associated with the document. For example, 12.6.
     *         This value is unique across all versions of a document, and can't be changed.
     */
    public final String versionName() {
        return versionName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(version());
        hashCode = 31 * hashCode + Objects.hashCode(requireType());
        hashCode = 31 * hashCode + Objects.hashCode(versionName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DocumentRequires)) {
            return false;
        }
        DocumentRequires other = (DocumentRequires) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(version(), other.version())
                && Objects.equals(requireType(), other.requireType()) && Objects.equals(versionName(), other.versionName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DocumentRequires").add("Name", name()).add("Version", version())
                .add("RequireType", requireType()).add("VersionName", versionName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Version":
            return Optional.ofNullable(clazz.cast(version()));
        case "RequireType":
            return Optional.ofNullable(clazz.cast(requireType()));
        case "VersionName":
            return Optional.ofNullable(clazz.cast(versionName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Name", NAME_FIELD);
        map.put("Version", VERSION_FIELD);
        map.put("RequireType", REQUIRE_TYPE_FIELD);
        map.put("VersionName", VERSION_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DocumentRequires, T> g) {
        return obj -> g.apply((DocumentRequires) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DocumentRequires> {
        /**
         * <p>
         * The name of the required SSM document. The name can be an Amazon Resource Name (ARN).
         * </p>
         * 
         * @param name
         *        The name of the required SSM document. The name can be an Amazon Resource Name (ARN).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The document version required by the current document.
         * </p>
         * 
         * @param version
         *        The document version required by the current document.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder version(String version);

        /**
         * <p>
         * The document type of the required SSM document.
         * </p>
         * 
         * @param requireType
         *        The document type of the required SSM document.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requireType(String requireType);

        /**
         * <p>
         * An optional field specifying the version of the artifact associated with the document. For example, 12.6.
         * This value is unique across all versions of a document, and can't be changed.
         * </p>
         * 
         * @param versionName
         *        An optional field specifying the version of the artifact associated with the document. For example,
         *        12.6. This value is unique across all versions of a document, and can't be changed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder versionName(String versionName);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String version;

        private String requireType;

        private String versionName;

        private BuilderImpl() {
        }

        private BuilderImpl(DocumentRequires model) {
            name(model.name);
            version(model.version);
            requireType(model.requireType);
            versionName(model.versionName);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getVersion() {
            return version;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final String getRequireType() {
            return requireType;
        }

        public final void setRequireType(String requireType) {
            this.requireType = requireType;
        }

        @Override
        public final Builder requireType(String requireType) {
            this.requireType = requireType;
            return this;
        }

        public final String getVersionName() {
            return versionName;
        }

        public final void setVersionName(String versionName) {
            this.versionName = versionName;
        }

        @Override
        public final Builder versionName(String versionName) {
            this.versionName = versionName;
            return this;
        }

        @Override
        public DocumentRequires build() {
            return new DocumentRequires(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
