/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetAccessTokenResponse extends SsmResponse implements
        ToCopyableBuilder<GetAccessTokenResponse.Builder, GetAccessTokenResponse> {
    private static final SdkField<Credentials> CREDENTIALS_FIELD = SdkField.<Credentials> builder(MarshallingType.SDK_POJO)
            .memberName("Credentials").getter(getter(GetAccessTokenResponse::credentials)).setter(setter(Builder::credentials))
            .constructor(Credentials::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Credentials").build()).build();

    private static final SdkField<String> ACCESS_REQUEST_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AccessRequestStatus").getter(getter(GetAccessTokenResponse::accessRequestStatusAsString))
            .setter(setter(Builder::accessRequestStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessRequestStatus").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREDENTIALS_FIELD,
            ACCESS_REQUEST_STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Credentials credentials;

    private final String accessRequestStatus;

    private GetAccessTokenResponse(BuilderImpl builder) {
        super(builder);
        this.credentials = builder.credentials;
        this.accessRequestStatus = builder.accessRequestStatus;
    }

    /**
     * <p>
     * The temporary security credentials which can be used to start just-in-time node access sessions.
     * </p>
     * 
     * @return The temporary security credentials which can be used to start just-in-time node access sessions.
     */
    public final Credentials credentials() {
        return credentials;
    }

    /**
     * <p>
     * The status of the access request.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #accessRequestStatus} will return {@link AccessRequestStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #accessRequestStatusAsString}.
     * </p>
     * 
     * @return The status of the access request.
     * @see AccessRequestStatus
     */
    public final AccessRequestStatus accessRequestStatus() {
        return AccessRequestStatus.fromValue(accessRequestStatus);
    }

    /**
     * <p>
     * The status of the access request.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #accessRequestStatus} will return {@link AccessRequestStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #accessRequestStatusAsString}.
     * </p>
     * 
     * @return The status of the access request.
     * @see AccessRequestStatus
     */
    public final String accessRequestStatusAsString() {
        return accessRequestStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(credentials());
        hashCode = 31 * hashCode + Objects.hashCode(accessRequestStatusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAccessTokenResponse)) {
            return false;
        }
        GetAccessTokenResponse other = (GetAccessTokenResponse) obj;
        return Objects.equals(credentials(), other.credentials())
                && Objects.equals(accessRequestStatusAsString(), other.accessRequestStatusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetAccessTokenResponse").add("Credentials", credentials())
                .add("AccessRequestStatus", accessRequestStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Credentials":
            return Optional.ofNullable(clazz.cast(credentials()));
        case "AccessRequestStatus":
            return Optional.ofNullable(clazz.cast(accessRequestStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Credentials", CREDENTIALS_FIELD);
        map.put("AccessRequestStatus", ACCESS_REQUEST_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetAccessTokenResponse, T> g) {
        return obj -> g.apply((GetAccessTokenResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SsmResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetAccessTokenResponse> {
        /**
         * <p>
         * The temporary security credentials which can be used to start just-in-time node access sessions.
         * </p>
         * 
         * @param credentials
         *        The temporary security credentials which can be used to start just-in-time node access sessions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder credentials(Credentials credentials);

        /**
         * <p>
         * The temporary security credentials which can be used to start just-in-time node access sessions.
         * </p>
         * This is a convenience method that creates an instance of the {@link Credentials.Builder} avoiding the need to
         * create one manually via {@link Credentials#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Credentials.Builder#build()} is called immediately and its result
         * is passed to {@link #credentials(Credentials)}.
         * 
         * @param credentials
         *        a consumer that will call methods on {@link Credentials.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #credentials(Credentials)
         */
        default Builder credentials(Consumer<Credentials.Builder> credentials) {
            return credentials(Credentials.builder().applyMutation(credentials).build());
        }

        /**
         * <p>
         * The status of the access request.
         * </p>
         * 
         * @param accessRequestStatus
         *        The status of the access request.
         * @see AccessRequestStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AccessRequestStatus
         */
        Builder accessRequestStatus(String accessRequestStatus);

        /**
         * <p>
         * The status of the access request.
         * </p>
         * 
         * @param accessRequestStatus
         *        The status of the access request.
         * @see AccessRequestStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AccessRequestStatus
         */
        Builder accessRequestStatus(AccessRequestStatus accessRequestStatus);
    }

    static final class BuilderImpl extends SsmResponse.BuilderImpl implements Builder {
        private Credentials credentials;

        private String accessRequestStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(GetAccessTokenResponse model) {
            super(model);
            credentials(model.credentials);
            accessRequestStatus(model.accessRequestStatus);
        }

        public final Credentials.Builder getCredentials() {
            return credentials != null ? credentials.toBuilder() : null;
        }

        public final void setCredentials(Credentials.BuilderImpl credentials) {
            this.credentials = credentials != null ? credentials.build() : null;
        }

        @Override
        public final Builder credentials(Credentials credentials) {
            this.credentials = credentials;
            return this;
        }

        public final String getAccessRequestStatus() {
            return accessRequestStatus;
        }

        public final void setAccessRequestStatus(String accessRequestStatus) {
            this.accessRequestStatus = accessRequestStatus;
        }

        @Override
        public final Builder accessRequestStatus(String accessRequestStatus) {
            this.accessRequestStatus = accessRequestStatus;
            return this;
        }

        @Override
        public final Builder accessRequestStatus(AccessRequestStatus accessRequestStatus) {
            this.accessRequestStatus(accessRequestStatus == null ? null : accessRequestStatus.toString());
            return this;
        }

        @Override
        public GetAccessTokenResponse build() {
            return new GetAccessTokenResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
