/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.timestreamquery.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration settings for notifications related to account settings.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AccountSettingsNotificationConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<AccountSettingsNotificationConfiguration.Builder, AccountSettingsNotificationConfiguration> {
    private static final SdkField<SnsConfiguration> SNS_CONFIGURATION_FIELD = SdkField
            .<SnsConfiguration> builder(MarshallingType.SDK_POJO).memberName("SnsConfiguration")
            .getter(getter(AccountSettingsNotificationConfiguration::snsConfiguration)).setter(setter(Builder::snsConfiguration))
            .constructor(SnsConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnsConfiguration").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoleArn").getter(getter(AccountSettingsNotificationConfiguration::roleArn))
            .setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SNS_CONFIGURATION_FIELD,
            ROLE_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final SnsConfiguration snsConfiguration;

    private final String roleArn;

    private AccountSettingsNotificationConfiguration(BuilderImpl builder) {
        this.snsConfiguration = builder.snsConfiguration;
        this.roleArn = builder.roleArn;
    }

    /**
     * Returns the value of the SnsConfiguration property for this object.
     * 
     * @return The value of the SnsConfiguration property for this object.
     */
    public final SnsConfiguration snsConfiguration() {
        return snsConfiguration;
    }

    /**
     * <p>
     * An Amazon Resource Name (ARN) that grants Timestream permission to publish notifications. This field is only
     * visible if SNS Topic is provided when updating the account settings.
     * </p>
     * 
     * @return An Amazon Resource Name (ARN) that grants Timestream permission to publish notifications. This field is
     *         only visible if SNS Topic is provided when updating the account settings.
     */
    public final String roleArn() {
        return roleArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(snsConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AccountSettingsNotificationConfiguration)) {
            return false;
        }
        AccountSettingsNotificationConfiguration other = (AccountSettingsNotificationConfiguration) obj;
        return Objects.equals(snsConfiguration(), other.snsConfiguration()) && Objects.equals(roleArn(), other.roleArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AccountSettingsNotificationConfiguration").add("SnsConfiguration", snsConfiguration())
                .add("RoleArn", roleArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SnsConfiguration":
            return Optional.ofNullable(clazz.cast(snsConfiguration()));
        case "RoleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("SnsConfiguration", SNS_CONFIGURATION_FIELD);
        map.put("RoleArn", ROLE_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AccountSettingsNotificationConfiguration, T> g) {
        return obj -> g.apply((AccountSettingsNotificationConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AccountSettingsNotificationConfiguration> {
        /**
         * Sets the value of the SnsConfiguration property for this object.
         *
         * @param snsConfiguration
         *        The new value for the SnsConfiguration property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snsConfiguration(SnsConfiguration snsConfiguration);

        /**
         * Sets the value of the SnsConfiguration property for this object.
         *
         * This is a convenience method that creates an instance of the {@link SnsConfiguration.Builder} avoiding the
         * need to create one manually via {@link SnsConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SnsConfiguration.Builder#build()} is called immediately and its
         * result is passed to {@link #snsConfiguration(SnsConfiguration)}.
         * 
         * @param snsConfiguration
         *        a consumer that will call methods on {@link SnsConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #snsConfiguration(SnsConfiguration)
         */
        default Builder snsConfiguration(Consumer<SnsConfiguration.Builder> snsConfiguration) {
            return snsConfiguration(SnsConfiguration.builder().applyMutation(snsConfiguration).build());
        }

        /**
         * <p>
         * An Amazon Resource Name (ARN) that grants Timestream permission to publish notifications. This field is only
         * visible if SNS Topic is provided when updating the account settings.
         * </p>
         * 
         * @param roleArn
         *        An Amazon Resource Name (ARN) that grants Timestream permission to publish notifications. This field
         *        is only visible if SNS Topic is provided when updating the account settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);
    }

    static final class BuilderImpl implements Builder {
        private SnsConfiguration snsConfiguration;

        private String roleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(AccountSettingsNotificationConfiguration model) {
            snsConfiguration(model.snsConfiguration);
            roleArn(model.roleArn);
        }

        public final SnsConfiguration.Builder getSnsConfiguration() {
            return snsConfiguration != null ? snsConfiguration.toBuilder() : null;
        }

        public final void setSnsConfiguration(SnsConfiguration.BuilderImpl snsConfiguration) {
            this.snsConfiguration = snsConfiguration != null ? snsConfiguration.build() : null;
        }

        @Override
        public final Builder snsConfiguration(SnsConfiguration snsConfiguration) {
            this.snsConfiguration = snsConfiguration;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        @Override
        public AccountSettingsNotificationConfiguration build() {
            return new AccountSettingsNotificationConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
