/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.timestreamquery.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A request to update the provisioned capacity settings for querying data.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ProvisionedCapacityRequest implements SdkPojo, Serializable,
        ToCopyableBuilder<ProvisionedCapacityRequest.Builder, ProvisionedCapacityRequest> {
    private static final SdkField<Integer> TARGET_QUERY_TCU_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("TargetQueryTCU").getter(getter(ProvisionedCapacityRequest::targetQueryTCU))
            .setter(setter(Builder::targetQueryTCU))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetQueryTCU").build()).build();

    private static final SdkField<AccountSettingsNotificationConfiguration> NOTIFICATION_CONFIGURATION_FIELD = SdkField
            .<AccountSettingsNotificationConfiguration> builder(MarshallingType.SDK_POJO).memberName("NotificationConfiguration")
            .getter(getter(ProvisionedCapacityRequest::notificationConfiguration))
            .setter(setter(Builder::notificationConfiguration)).constructor(AccountSettingsNotificationConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotificationConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TARGET_QUERY_TCU_FIELD,
            NOTIFICATION_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer targetQueryTCU;

    private final AccountSettingsNotificationConfiguration notificationConfiguration;

    private ProvisionedCapacityRequest(BuilderImpl builder) {
        this.targetQueryTCU = builder.targetQueryTCU;
        this.notificationConfiguration = builder.notificationConfiguration;
    }

    /**
     * <p>
     * The target compute capacity for querying data, specified in Timestream Compute Units (TCUs).
     * </p>
     * 
     * @return The target compute capacity for querying data, specified in Timestream Compute Units (TCUs).
     */
    public final Integer targetQueryTCU() {
        return targetQueryTCU;
    }

    /**
     * <p>
     * Configuration settings for notifications related to the provisioned capacity update.
     * </p>
     * 
     * @return Configuration settings for notifications related to the provisioned capacity update.
     */
    public final AccountSettingsNotificationConfiguration notificationConfiguration() {
        return notificationConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(targetQueryTCU());
        hashCode = 31 * hashCode + Objects.hashCode(notificationConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProvisionedCapacityRequest)) {
            return false;
        }
        ProvisionedCapacityRequest other = (ProvisionedCapacityRequest) obj;
        return Objects.equals(targetQueryTCU(), other.targetQueryTCU())
                && Objects.equals(notificationConfiguration(), other.notificationConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ProvisionedCapacityRequest").add("TargetQueryTCU", targetQueryTCU())
                .add("NotificationConfiguration", notificationConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TargetQueryTCU":
            return Optional.ofNullable(clazz.cast(targetQueryTCU()));
        case "NotificationConfiguration":
            return Optional.ofNullable(clazz.cast(notificationConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("TargetQueryTCU", TARGET_QUERY_TCU_FIELD);
        map.put("NotificationConfiguration", NOTIFICATION_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ProvisionedCapacityRequest, T> g) {
        return obj -> g.apply((ProvisionedCapacityRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ProvisionedCapacityRequest> {
        /**
         * <p>
         * The target compute capacity for querying data, specified in Timestream Compute Units (TCUs).
         * </p>
         * 
         * @param targetQueryTCU
         *        The target compute capacity for querying data, specified in Timestream Compute Units (TCUs).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetQueryTCU(Integer targetQueryTCU);

        /**
         * <p>
         * Configuration settings for notifications related to the provisioned capacity update.
         * </p>
         * 
         * @param notificationConfiguration
         *        Configuration settings for notifications related to the provisioned capacity update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notificationConfiguration(AccountSettingsNotificationConfiguration notificationConfiguration);

        /**
         * <p>
         * Configuration settings for notifications related to the provisioned capacity update.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AccountSettingsNotificationConfiguration.Builder} avoiding the need to create one manually via
         * {@link AccountSettingsNotificationConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AccountSettingsNotificationConfiguration.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #notificationConfiguration(AccountSettingsNotificationConfiguration)}.
         * 
         * @param notificationConfiguration
         *        a consumer that will call methods on {@link AccountSettingsNotificationConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #notificationConfiguration(AccountSettingsNotificationConfiguration)
         */
        default Builder notificationConfiguration(
                Consumer<AccountSettingsNotificationConfiguration.Builder> notificationConfiguration) {
            return notificationConfiguration(AccountSettingsNotificationConfiguration.builder()
                    .applyMutation(notificationConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Integer targetQueryTCU;

        private AccountSettingsNotificationConfiguration notificationConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(ProvisionedCapacityRequest model) {
            targetQueryTCU(model.targetQueryTCU);
            notificationConfiguration(model.notificationConfiguration);
        }

        public final Integer getTargetQueryTCU() {
            return targetQueryTCU;
        }

        public final void setTargetQueryTCU(Integer targetQueryTCU) {
            this.targetQueryTCU = targetQueryTCU;
        }

        @Override
        public final Builder targetQueryTCU(Integer targetQueryTCU) {
            this.targetQueryTCU = targetQueryTCU;
            return this;
        }

        public final AccountSettingsNotificationConfiguration.Builder getNotificationConfiguration() {
            return notificationConfiguration != null ? notificationConfiguration.toBuilder() : null;
        }

        public final void setNotificationConfiguration(
                AccountSettingsNotificationConfiguration.BuilderImpl notificationConfiguration) {
            this.notificationConfiguration = notificationConfiguration != null ? notificationConfiguration.build() : null;
        }

        @Override
        public final Builder notificationConfiguration(AccountSettingsNotificationConfiguration notificationConfiguration) {
            this.notificationConfiguration = notificationConfiguration;
            return this;
        }

        @Override
        public ProvisionedCapacityRequest build() {
            return new ProvisionedCapacityRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
