/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.timestreamquery.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The response to a request to update the provisioned capacity settings for querying data.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ProvisionedCapacityResponse implements SdkPojo, Serializable,
        ToCopyableBuilder<ProvisionedCapacityResponse.Builder, ProvisionedCapacityResponse> {
    private static final SdkField<Integer> ACTIVE_QUERY_TCU_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ActiveQueryTCU").getter(getter(ProvisionedCapacityResponse::activeQueryTCU))
            .setter(setter(Builder::activeQueryTCU))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActiveQueryTCU").build()).build();

    private static final SdkField<AccountSettingsNotificationConfiguration> NOTIFICATION_CONFIGURATION_FIELD = SdkField
            .<AccountSettingsNotificationConfiguration> builder(MarshallingType.SDK_POJO).memberName("NotificationConfiguration")
            .getter(getter(ProvisionedCapacityResponse::notificationConfiguration))
            .setter(setter(Builder::notificationConfiguration)).constructor(AccountSettingsNotificationConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotificationConfiguration").build())
            .build();

    private static final SdkField<LastUpdate> LAST_UPDATE_FIELD = SdkField.<LastUpdate> builder(MarshallingType.SDK_POJO)
            .memberName("LastUpdate").getter(getter(ProvisionedCapacityResponse::lastUpdate)).setter(setter(Builder::lastUpdate))
            .constructor(LastUpdate::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdate").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTIVE_QUERY_TCU_FIELD,
            NOTIFICATION_CONFIGURATION_FIELD, LAST_UPDATE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer activeQueryTCU;

    private final AccountSettingsNotificationConfiguration notificationConfiguration;

    private final LastUpdate lastUpdate;

    private ProvisionedCapacityResponse(BuilderImpl builder) {
        this.activeQueryTCU = builder.activeQueryTCU;
        this.notificationConfiguration = builder.notificationConfiguration;
        this.lastUpdate = builder.lastUpdate;
    }

    /**
     * <p>
     * The number of Timestream Compute Units (TCUs) provisioned in the account. This field is only visible when the
     * compute mode is <code>PROVISIONED</code>.
     * </p>
     * 
     * @return The number of Timestream Compute Units (TCUs) provisioned in the account. This field is only visible when
     *         the compute mode is <code>PROVISIONED</code>.
     */
    public final Integer activeQueryTCU() {
        return activeQueryTCU;
    }

    /**
     * <p>
     * An object that contains settings for notifications that are sent whenever the provisioned capacity settings are
     * modified. This field is only visible when the compute mode is <code>PROVISIONED</code>.
     * </p>
     * 
     * @return An object that contains settings for notifications that are sent whenever the provisioned capacity
     *         settings are modified. This field is only visible when the compute mode is <code>PROVISIONED</code>.
     */
    public final AccountSettingsNotificationConfiguration notificationConfiguration() {
        return notificationConfiguration;
    }

    /**
     * <p>
     * Information about the last update to the provisioned capacity settings.
     * </p>
     * 
     * @return Information about the last update to the provisioned capacity settings.
     */
    public final LastUpdate lastUpdate() {
        return lastUpdate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(activeQueryTCU());
        hashCode = 31 * hashCode + Objects.hashCode(notificationConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProvisionedCapacityResponse)) {
            return false;
        }
        ProvisionedCapacityResponse other = (ProvisionedCapacityResponse) obj;
        return Objects.equals(activeQueryTCU(), other.activeQueryTCU())
                && Objects.equals(notificationConfiguration(), other.notificationConfiguration())
                && Objects.equals(lastUpdate(), other.lastUpdate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ProvisionedCapacityResponse").add("ActiveQueryTCU", activeQueryTCU())
                .add("NotificationConfiguration", notificationConfiguration()).add("LastUpdate", lastUpdate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ActiveQueryTCU":
            return Optional.ofNullable(clazz.cast(activeQueryTCU()));
        case "NotificationConfiguration":
            return Optional.ofNullable(clazz.cast(notificationConfiguration()));
        case "LastUpdate":
            return Optional.ofNullable(clazz.cast(lastUpdate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ActiveQueryTCU", ACTIVE_QUERY_TCU_FIELD);
        map.put("NotificationConfiguration", NOTIFICATION_CONFIGURATION_FIELD);
        map.put("LastUpdate", LAST_UPDATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ProvisionedCapacityResponse, T> g) {
        return obj -> g.apply((ProvisionedCapacityResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ProvisionedCapacityResponse> {
        /**
         * <p>
         * The number of Timestream Compute Units (TCUs) provisioned in the account. This field is only visible when the
         * compute mode is <code>PROVISIONED</code>.
         * </p>
         * 
         * @param activeQueryTCU
         *        The number of Timestream Compute Units (TCUs) provisioned in the account. This field is only visible
         *        when the compute mode is <code>PROVISIONED</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder activeQueryTCU(Integer activeQueryTCU);

        /**
         * <p>
         * An object that contains settings for notifications that are sent whenever the provisioned capacity settings
         * are modified. This field is only visible when the compute mode is <code>PROVISIONED</code>.
         * </p>
         * 
         * @param notificationConfiguration
         *        An object that contains settings for notifications that are sent whenever the provisioned capacity
         *        settings are modified. This field is only visible when the compute mode is <code>PROVISIONED</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notificationConfiguration(AccountSettingsNotificationConfiguration notificationConfiguration);

        /**
         * <p>
         * An object that contains settings for notifications that are sent whenever the provisioned capacity settings
         * are modified. This field is only visible when the compute mode is <code>PROVISIONED</code>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AccountSettingsNotificationConfiguration.Builder} avoiding the need to create one manually via
         * {@link AccountSettingsNotificationConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AccountSettingsNotificationConfiguration.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #notificationConfiguration(AccountSettingsNotificationConfiguration)}.
         * 
         * @param notificationConfiguration
         *        a consumer that will call methods on {@link AccountSettingsNotificationConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #notificationConfiguration(AccountSettingsNotificationConfiguration)
         */
        default Builder notificationConfiguration(
                Consumer<AccountSettingsNotificationConfiguration.Builder> notificationConfiguration) {
            return notificationConfiguration(AccountSettingsNotificationConfiguration.builder()
                    .applyMutation(notificationConfiguration).build());
        }

        /**
         * <p>
         * Information about the last update to the provisioned capacity settings.
         * </p>
         * 
         * @param lastUpdate
         *        Information about the last update to the provisioned capacity settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdate(LastUpdate lastUpdate);

        /**
         * <p>
         * Information about the last update to the provisioned capacity settings.
         * </p>
         * This is a convenience method that creates an instance of the {@link LastUpdate.Builder} avoiding the need to
         * create one manually via {@link LastUpdate#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LastUpdate.Builder#build()} is called immediately and its result
         * is passed to {@link #lastUpdate(LastUpdate)}.
         * 
         * @param lastUpdate
         *        a consumer that will call methods on {@link LastUpdate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lastUpdate(LastUpdate)
         */
        default Builder lastUpdate(Consumer<LastUpdate.Builder> lastUpdate) {
            return lastUpdate(LastUpdate.builder().applyMutation(lastUpdate).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Integer activeQueryTCU;

        private AccountSettingsNotificationConfiguration notificationConfiguration;

        private LastUpdate lastUpdate;

        private BuilderImpl() {
        }

        private BuilderImpl(ProvisionedCapacityResponse model) {
            activeQueryTCU(model.activeQueryTCU);
            notificationConfiguration(model.notificationConfiguration);
            lastUpdate(model.lastUpdate);
        }

        public final Integer getActiveQueryTCU() {
            return activeQueryTCU;
        }

        public final void setActiveQueryTCU(Integer activeQueryTCU) {
            this.activeQueryTCU = activeQueryTCU;
        }

        @Override
        public final Builder activeQueryTCU(Integer activeQueryTCU) {
            this.activeQueryTCU = activeQueryTCU;
            return this;
        }

        public final AccountSettingsNotificationConfiguration.Builder getNotificationConfiguration() {
            return notificationConfiguration != null ? notificationConfiguration.toBuilder() : null;
        }

        public final void setNotificationConfiguration(
                AccountSettingsNotificationConfiguration.BuilderImpl notificationConfiguration) {
            this.notificationConfiguration = notificationConfiguration != null ? notificationConfiguration.build() : null;
        }

        @Override
        public final Builder notificationConfiguration(AccountSettingsNotificationConfiguration notificationConfiguration) {
            this.notificationConfiguration = notificationConfiguration;
            return this;
        }

        public final LastUpdate.Builder getLastUpdate() {
            return lastUpdate != null ? lastUpdate.toBuilder() : null;
        }

        public final void setLastUpdate(LastUpdate.BuilderImpl lastUpdate) {
            this.lastUpdate = lastUpdate != null ? lastUpdate.build() : null;
        }

        @Override
        public final Builder lastUpdate(LastUpdate lastUpdate) {
            this.lastUpdate = lastUpdate;
            return this;
        }

        @Override
        public ProvisionedCapacityResponse build() {
            return new ProvisionedCapacityResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
