/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.timestreamquery.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides various insights and metrics related to the <code>ExecuteScheduledQueryRequest</code> that was executed.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ScheduledQueryInsightsResponse implements SdkPojo, Serializable,
        ToCopyableBuilder<ScheduledQueryInsightsResponse.Builder, ScheduledQueryInsightsResponse> {
    private static final SdkField<QuerySpatialCoverage> QUERY_SPATIAL_COVERAGE_FIELD = SdkField
            .<QuerySpatialCoverage> builder(MarshallingType.SDK_POJO).memberName("QuerySpatialCoverage")
            .getter(getter(ScheduledQueryInsightsResponse::querySpatialCoverage)).setter(setter(Builder::querySpatialCoverage))
            .constructor(QuerySpatialCoverage::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QuerySpatialCoverage").build())
            .build();

    private static final SdkField<QueryTemporalRange> QUERY_TEMPORAL_RANGE_FIELD = SdkField
            .<QueryTemporalRange> builder(MarshallingType.SDK_POJO).memberName("QueryTemporalRange")
            .getter(getter(ScheduledQueryInsightsResponse::queryTemporalRange)).setter(setter(Builder::queryTemporalRange))
            .constructor(QueryTemporalRange::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryTemporalRange").build())
            .build();

    private static final SdkField<Long> QUERY_TABLE_COUNT_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("QueryTableCount").getter(getter(ScheduledQueryInsightsResponse::queryTableCount))
            .setter(setter(Builder::queryTableCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryTableCount").build()).build();

    private static final SdkField<Long> OUTPUT_ROWS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("OutputRows").getter(getter(ScheduledQueryInsightsResponse::outputRows))
            .setter(setter(Builder::outputRows))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputRows").build()).build();

    private static final SdkField<Long> OUTPUT_BYTES_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("OutputBytes").getter(getter(ScheduledQueryInsightsResponse::outputBytes))
            .setter(setter(Builder::outputBytes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputBytes").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(QUERY_SPATIAL_COVERAGE_FIELD,
            QUERY_TEMPORAL_RANGE_FIELD, QUERY_TABLE_COUNT_FIELD, OUTPUT_ROWS_FIELD, OUTPUT_BYTES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final QuerySpatialCoverage querySpatialCoverage;

    private final QueryTemporalRange queryTemporalRange;

    private final Long queryTableCount;

    private final Long outputRows;

    private final Long outputBytes;

    private ScheduledQueryInsightsResponse(BuilderImpl builder) {
        this.querySpatialCoverage = builder.querySpatialCoverage;
        this.queryTemporalRange = builder.queryTemporalRange;
        this.queryTableCount = builder.queryTableCount;
        this.outputRows = builder.outputRows;
        this.outputBytes = builder.outputBytes;
    }

    /**
     * <p>
     * Provides insights into the spatial coverage of the query, including the table with sub-optimal (max) spatial
     * pruning. This information can help you identify areas for improvement in your partitioning strategy to enhance
     * spatial pruning.
     * </p>
     * 
     * @return Provides insights into the spatial coverage of the query, including the table with sub-optimal (max)
     *         spatial pruning. This information can help you identify areas for improvement in your partitioning
     *         strategy to enhance spatial pruning.
     */
    public final QuerySpatialCoverage querySpatialCoverage() {
        return querySpatialCoverage;
    }

    /**
     * <p>
     * Provides insights into the temporal range of the query, including the table with the largest (max) time range.
     * Following are some of the potential options for optimizing time-based pruning:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Add missing time-predicates.
     * </p>
     * </li>
     * <li>
     * <p>
     * Remove functions around the time predicates.
     * </p>
     * </li>
     * <li>
     * <p>
     * Add time predicates to all the sub-queries.
     * </p>
     * </li>
     * </ul>
     * 
     * @return Provides insights into the temporal range of the query, including the table with the largest (max) time
     *         range. Following are some of the potential options for optimizing time-based pruning:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Add missing time-predicates.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Remove functions around the time predicates.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Add time predicates to all the sub-queries.
     *         </p>
     *         </li>
     */
    public final QueryTemporalRange queryTemporalRange() {
        return queryTemporalRange;
    }

    /**
     * <p>
     * Indicates the number of tables in the query.
     * </p>
     * 
     * @return Indicates the number of tables in the query.
     */
    public final Long queryTableCount() {
        return queryTableCount;
    }

    /**
     * <p>
     * Indicates the total number of rows returned as part of the query result set. You can use this data to validate if
     * the number of rows in the result set have changed as part of the query tuning exercise.
     * </p>
     * 
     * @return Indicates the total number of rows returned as part of the query result set. You can use this data to
     *         validate if the number of rows in the result set have changed as part of the query tuning exercise.
     */
    public final Long outputRows() {
        return outputRows;
    }

    /**
     * <p>
     * Indicates the size of query result set in bytes. You can use this data to validate if the result set has changed
     * as part of the query tuning exercise.
     * </p>
     * 
     * @return Indicates the size of query result set in bytes. You can use this data to validate if the result set has
     *         changed as part of the query tuning exercise.
     */
    public final Long outputBytes() {
        return outputBytes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(querySpatialCoverage());
        hashCode = 31 * hashCode + Objects.hashCode(queryTemporalRange());
        hashCode = 31 * hashCode + Objects.hashCode(queryTableCount());
        hashCode = 31 * hashCode + Objects.hashCode(outputRows());
        hashCode = 31 * hashCode + Objects.hashCode(outputBytes());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScheduledQueryInsightsResponse)) {
            return false;
        }
        ScheduledQueryInsightsResponse other = (ScheduledQueryInsightsResponse) obj;
        return Objects.equals(querySpatialCoverage(), other.querySpatialCoverage())
                && Objects.equals(queryTemporalRange(), other.queryTemporalRange())
                && Objects.equals(queryTableCount(), other.queryTableCount()) && Objects.equals(outputRows(), other.outputRows())
                && Objects.equals(outputBytes(), other.outputBytes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ScheduledQueryInsightsResponse").add("QuerySpatialCoverage", querySpatialCoverage())
                .add("QueryTemporalRange", queryTemporalRange()).add("QueryTableCount", queryTableCount())
                .add("OutputRows", outputRows()).add("OutputBytes", outputBytes()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "QuerySpatialCoverage":
            return Optional.ofNullable(clazz.cast(querySpatialCoverage()));
        case "QueryTemporalRange":
            return Optional.ofNullable(clazz.cast(queryTemporalRange()));
        case "QueryTableCount":
            return Optional.ofNullable(clazz.cast(queryTableCount()));
        case "OutputRows":
            return Optional.ofNullable(clazz.cast(outputRows()));
        case "OutputBytes":
            return Optional.ofNullable(clazz.cast(outputBytes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("QuerySpatialCoverage", QUERY_SPATIAL_COVERAGE_FIELD);
        map.put("QueryTemporalRange", QUERY_TEMPORAL_RANGE_FIELD);
        map.put("QueryTableCount", QUERY_TABLE_COUNT_FIELD);
        map.put("OutputRows", OUTPUT_ROWS_FIELD);
        map.put("OutputBytes", OUTPUT_BYTES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ScheduledQueryInsightsResponse, T> g) {
        return obj -> g.apply((ScheduledQueryInsightsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ScheduledQueryInsightsResponse> {
        /**
         * <p>
         * Provides insights into the spatial coverage of the query, including the table with sub-optimal (max) spatial
         * pruning. This information can help you identify areas for improvement in your partitioning strategy to
         * enhance spatial pruning.
         * </p>
         * 
         * @param querySpatialCoverage
         *        Provides insights into the spatial coverage of the query, including the table with sub-optimal (max)
         *        spatial pruning. This information can help you identify areas for improvement in your partitioning
         *        strategy to enhance spatial pruning.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder querySpatialCoverage(QuerySpatialCoverage querySpatialCoverage);

        /**
         * <p>
         * Provides insights into the spatial coverage of the query, including the table with sub-optimal (max) spatial
         * pruning. This information can help you identify areas for improvement in your partitioning strategy to
         * enhance spatial pruning.
         * </p>
         * This is a convenience method that creates an instance of the {@link QuerySpatialCoverage.Builder} avoiding
         * the need to create one manually via {@link QuerySpatialCoverage#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link QuerySpatialCoverage.Builder#build()} is called immediately and
         * its result is passed to {@link #querySpatialCoverage(QuerySpatialCoverage)}.
         * 
         * @param querySpatialCoverage
         *        a consumer that will call methods on {@link QuerySpatialCoverage.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #querySpatialCoverage(QuerySpatialCoverage)
         */
        default Builder querySpatialCoverage(Consumer<QuerySpatialCoverage.Builder> querySpatialCoverage) {
            return querySpatialCoverage(QuerySpatialCoverage.builder().applyMutation(querySpatialCoverage).build());
        }

        /**
         * <p>
         * Provides insights into the temporal range of the query, including the table with the largest (max) time
         * range. Following are some of the potential options for optimizing time-based pruning:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Add missing time-predicates.
         * </p>
         * </li>
         * <li>
         * <p>
         * Remove functions around the time predicates.
         * </p>
         * </li>
         * <li>
         * <p>
         * Add time predicates to all the sub-queries.
         * </p>
         * </li>
         * </ul>
         * 
         * @param queryTemporalRange
         *        Provides insights into the temporal range of the query, including the table with the largest (max)
         *        time range. Following are some of the potential options for optimizing time-based pruning:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        Add missing time-predicates.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Remove functions around the time predicates.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Add time predicates to all the sub-queries.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queryTemporalRange(QueryTemporalRange queryTemporalRange);

        /**
         * <p>
         * Provides insights into the temporal range of the query, including the table with the largest (max) time
         * range. Following are some of the potential options for optimizing time-based pruning:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Add missing time-predicates.
         * </p>
         * </li>
         * <li>
         * <p>
         * Remove functions around the time predicates.
         * </p>
         * </li>
         * <li>
         * <p>
         * Add time predicates to all the sub-queries.
         * </p>
         * </li>
         * </ul>
         * This is a convenience method that creates an instance of the {@link QueryTemporalRange.Builder} avoiding the
         * need to create one manually via {@link QueryTemporalRange#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link QueryTemporalRange.Builder#build()} is called immediately and its
         * result is passed to {@link #queryTemporalRange(QueryTemporalRange)}.
         * 
         * @param queryTemporalRange
         *        a consumer that will call methods on {@link QueryTemporalRange.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #queryTemporalRange(QueryTemporalRange)
         */
        default Builder queryTemporalRange(Consumer<QueryTemporalRange.Builder> queryTemporalRange) {
            return queryTemporalRange(QueryTemporalRange.builder().applyMutation(queryTemporalRange).build());
        }

        /**
         * <p>
         * Indicates the number of tables in the query.
         * </p>
         * 
         * @param queryTableCount
         *        Indicates the number of tables in the query.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queryTableCount(Long queryTableCount);

        /**
         * <p>
         * Indicates the total number of rows returned as part of the query result set. You can use this data to
         * validate if the number of rows in the result set have changed as part of the query tuning exercise.
         * </p>
         * 
         * @param outputRows
         *        Indicates the total number of rows returned as part of the query result set. You can use this data to
         *        validate if the number of rows in the result set have changed as part of the query tuning exercise.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputRows(Long outputRows);

        /**
         * <p>
         * Indicates the size of query result set in bytes. You can use this data to validate if the result set has
         * changed as part of the query tuning exercise.
         * </p>
         * 
         * @param outputBytes
         *        Indicates the size of query result set in bytes. You can use this data to validate if the result set
         *        has changed as part of the query tuning exercise.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputBytes(Long outputBytes);
    }

    static final class BuilderImpl implements Builder {
        private QuerySpatialCoverage querySpatialCoverage;

        private QueryTemporalRange queryTemporalRange;

        private Long queryTableCount;

        private Long outputRows;

        private Long outputBytes;

        private BuilderImpl() {
        }

        private BuilderImpl(ScheduledQueryInsightsResponse model) {
            querySpatialCoverage(model.querySpatialCoverage);
            queryTemporalRange(model.queryTemporalRange);
            queryTableCount(model.queryTableCount);
            outputRows(model.outputRows);
            outputBytes(model.outputBytes);
        }

        public final QuerySpatialCoverage.Builder getQuerySpatialCoverage() {
            return querySpatialCoverage != null ? querySpatialCoverage.toBuilder() : null;
        }

        public final void setQuerySpatialCoverage(QuerySpatialCoverage.BuilderImpl querySpatialCoverage) {
            this.querySpatialCoverage = querySpatialCoverage != null ? querySpatialCoverage.build() : null;
        }

        @Override
        public final Builder querySpatialCoverage(QuerySpatialCoverage querySpatialCoverage) {
            this.querySpatialCoverage = querySpatialCoverage;
            return this;
        }

        public final QueryTemporalRange.Builder getQueryTemporalRange() {
            return queryTemporalRange != null ? queryTemporalRange.toBuilder() : null;
        }

        public final void setQueryTemporalRange(QueryTemporalRange.BuilderImpl queryTemporalRange) {
            this.queryTemporalRange = queryTemporalRange != null ? queryTemporalRange.build() : null;
        }

        @Override
        public final Builder queryTemporalRange(QueryTemporalRange queryTemporalRange) {
            this.queryTemporalRange = queryTemporalRange;
            return this;
        }

        public final Long getQueryTableCount() {
            return queryTableCount;
        }

        public final void setQueryTableCount(Long queryTableCount) {
            this.queryTableCount = queryTableCount;
        }

        @Override
        public final Builder queryTableCount(Long queryTableCount) {
            this.queryTableCount = queryTableCount;
            return this;
        }

        public final Long getOutputRows() {
            return outputRows;
        }

        public final void setOutputRows(Long outputRows) {
            this.outputRows = outputRows;
        }

        @Override
        public final Builder outputRows(Long outputRows) {
            this.outputRows = outputRows;
            return this;
        }

        public final Long getOutputBytes() {
            return outputBytes;
        }

        public final void setOutputBytes(Long outputBytes) {
            this.outputBytes = outputBytes;
        }

        @Override
        public final Builder outputBytes(Long outputBytes) {
            this.outputBytes = outputBytes;
            return this;
        }

        @Override
        public ScheduledQueryInsightsResponse build() {
            return new ScheduledQueryInsightsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
