/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.timestreamquery.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateAccountSettingsResponse extends TimestreamQueryResponse implements
        ToCopyableBuilder<UpdateAccountSettingsResponse.Builder, UpdateAccountSettingsResponse> {
    private static final SdkField<Integer> MAX_QUERY_TCU_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxQueryTCU").getter(getter(UpdateAccountSettingsResponse::maxQueryTCU))
            .setter(setter(Builder::maxQueryTCU))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxQueryTCU").build()).build();

    private static final SdkField<String> QUERY_PRICING_MODEL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("QueryPricingModel").getter(getter(UpdateAccountSettingsResponse::queryPricingModelAsString))
            .setter(setter(Builder::queryPricingModel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryPricingModel").build()).build();

    private static final SdkField<QueryComputeResponse> QUERY_COMPUTE_FIELD = SdkField
            .<QueryComputeResponse> builder(MarshallingType.SDK_POJO).memberName("QueryCompute")
            .getter(getter(UpdateAccountSettingsResponse::queryCompute)).setter(setter(Builder::queryCompute))
            .constructor(QueryComputeResponse::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryCompute").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAX_QUERY_TCU_FIELD,
            QUERY_PRICING_MODEL_FIELD, QUERY_COMPUTE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Integer maxQueryTCU;

    private final String queryPricingModel;

    private final QueryComputeResponse queryCompute;

    private UpdateAccountSettingsResponse(BuilderImpl builder) {
        super(builder);
        this.maxQueryTCU = builder.maxQueryTCU;
        this.queryPricingModel = builder.queryPricingModel;
        this.queryCompute = builder.queryCompute;
    }

    /**
     * <p>
     * The configured maximum number of compute units the service will use at any point in time to serve your queries.
     * </p>
     * 
     * @return The configured maximum number of compute units the service will use at any point in time to serve your
     *         queries.
     */
    public final Integer maxQueryTCU() {
        return maxQueryTCU;
    }

    /**
     * <p>
     * The pricing model for an account.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #queryPricingModel}
     * will return {@link QueryPricingModel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #queryPricingModelAsString}.
     * </p>
     * 
     * @return The pricing model for an account.
     * @see QueryPricingModel
     */
    public final QueryPricingModel queryPricingModel() {
        return QueryPricingModel.fromValue(queryPricingModel);
    }

    /**
     * <p>
     * The pricing model for an account.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #queryPricingModel}
     * will return {@link QueryPricingModel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #queryPricingModelAsString}.
     * </p>
     * 
     * @return The pricing model for an account.
     * @see QueryPricingModel
     */
    public final String queryPricingModelAsString() {
        return queryPricingModel;
    }

    /**
     * <p>
     * Confirms the updated account settings for querying data in your account.
     * </p>
     * 
     * @return Confirms the updated account settings for querying data in your account.
     */
    public final QueryComputeResponse queryCompute() {
        return queryCompute;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(maxQueryTCU());
        hashCode = 31 * hashCode + Objects.hashCode(queryPricingModelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(queryCompute());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateAccountSettingsResponse)) {
            return false;
        }
        UpdateAccountSettingsResponse other = (UpdateAccountSettingsResponse) obj;
        return Objects.equals(maxQueryTCU(), other.maxQueryTCU())
                && Objects.equals(queryPricingModelAsString(), other.queryPricingModelAsString())
                && Objects.equals(queryCompute(), other.queryCompute());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateAccountSettingsResponse").add("MaxQueryTCU", maxQueryTCU())
                .add("QueryPricingModel", queryPricingModelAsString()).add("QueryCompute", queryCompute()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MaxQueryTCU":
            return Optional.ofNullable(clazz.cast(maxQueryTCU()));
        case "QueryPricingModel":
            return Optional.ofNullable(clazz.cast(queryPricingModelAsString()));
        case "QueryCompute":
            return Optional.ofNullable(clazz.cast(queryCompute()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("MaxQueryTCU", MAX_QUERY_TCU_FIELD);
        map.put("QueryPricingModel", QUERY_PRICING_MODEL_FIELD);
        map.put("QueryCompute", QUERY_COMPUTE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateAccountSettingsResponse, T> g) {
        return obj -> g.apply((UpdateAccountSettingsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends TimestreamQueryResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateAccountSettingsResponse> {
        /**
         * <p>
         * The configured maximum number of compute units the service will use at any point in time to serve your
         * queries.
         * </p>
         * 
         * @param maxQueryTCU
         *        The configured maximum number of compute units the service will use at any point in time to serve your
         *        queries.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxQueryTCU(Integer maxQueryTCU);

        /**
         * <p>
         * The pricing model for an account.
         * </p>
         * 
         * @param queryPricingModel
         *        The pricing model for an account.
         * @see QueryPricingModel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see QueryPricingModel
         */
        Builder queryPricingModel(String queryPricingModel);

        /**
         * <p>
         * The pricing model for an account.
         * </p>
         * 
         * @param queryPricingModel
         *        The pricing model for an account.
         * @see QueryPricingModel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see QueryPricingModel
         */
        Builder queryPricingModel(QueryPricingModel queryPricingModel);

        /**
         * <p>
         * Confirms the updated account settings for querying data in your account.
         * </p>
         * 
         * @param queryCompute
         *        Confirms the updated account settings for querying data in your account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queryCompute(QueryComputeResponse queryCompute);

        /**
         * <p>
         * Confirms the updated account settings for querying data in your account.
         * </p>
         * This is a convenience method that creates an instance of the {@link QueryComputeResponse.Builder} avoiding
         * the need to create one manually via {@link QueryComputeResponse#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link QueryComputeResponse.Builder#build()} is called immediately and
         * its result is passed to {@link #queryCompute(QueryComputeResponse)}.
         * 
         * @param queryCompute
         *        a consumer that will call methods on {@link QueryComputeResponse.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #queryCompute(QueryComputeResponse)
         */
        default Builder queryCompute(Consumer<QueryComputeResponse.Builder> queryCompute) {
            return queryCompute(QueryComputeResponse.builder().applyMutation(queryCompute).build());
        }
    }

    static final class BuilderImpl extends TimestreamQueryResponse.BuilderImpl implements Builder {
        private Integer maxQueryTCU;

        private String queryPricingModel;

        private QueryComputeResponse queryCompute;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateAccountSettingsResponse model) {
            super(model);
            maxQueryTCU(model.maxQueryTCU);
            queryPricingModel(model.queryPricingModel);
            queryCompute(model.queryCompute);
        }

        public final Integer getMaxQueryTCU() {
            return maxQueryTCU;
        }

        public final void setMaxQueryTCU(Integer maxQueryTCU) {
            this.maxQueryTCU = maxQueryTCU;
        }

        @Override
        public final Builder maxQueryTCU(Integer maxQueryTCU) {
            this.maxQueryTCU = maxQueryTCU;
            return this;
        }

        public final String getQueryPricingModel() {
            return queryPricingModel;
        }

        public final void setQueryPricingModel(String queryPricingModel) {
            this.queryPricingModel = queryPricingModel;
        }

        @Override
        public final Builder queryPricingModel(String queryPricingModel) {
            this.queryPricingModel = queryPricingModel;
            return this;
        }

        @Override
        public final Builder queryPricingModel(QueryPricingModel queryPricingModel) {
            this.queryPricingModel(queryPricingModel == null ? null : queryPricingModel.toString());
            return this;
        }

        public final QueryComputeResponse.Builder getQueryCompute() {
            return queryCompute != null ? queryCompute.toBuilder() : null;
        }

        public final void setQueryCompute(QueryComputeResponse.BuilderImpl queryCompute) {
            this.queryCompute = queryCompute != null ? queryCompute.build() : null;
        }

        @Override
        public final Builder queryCompute(QueryComputeResponse queryCompute) {
            this.queryCompute = queryCompute;
            return this;
        }

        @Override
        public UpdateAccountSettingsResponse build() {
            return new UpdateAccountSettingsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
