/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.timestreamquery.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.timestreamquery.model.ErrorReportConfiguration;
import software.amazon.awssdk.services.timestreamquery.model.NotificationConfiguration;
import software.amazon.awssdk.services.timestreamquery.model.ScheduleConfiguration;
import software.amazon.awssdk.services.timestreamquery.model.Tag;
import software.amazon.awssdk.services.timestreamquery.model.TagListCopier;
import software.amazon.awssdk.services.timestreamquery.model.TargetConfiguration;
import software.amazon.awssdk.services.timestreamquery.model.TimestreamQueryRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateScheduledQueryRequest
extends TimestreamQueryRequest
implements ToCopyableBuilder<Builder, CreateScheduledQueryRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(CreateScheduledQueryRequest.getter(CreateScheduledQueryRequest::name)).setter(CreateScheduledQueryRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> QUERY_STRING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("QueryString").getter(CreateScheduledQueryRequest.getter(CreateScheduledQueryRequest::queryString)).setter(CreateScheduledQueryRequest.setter(Builder::queryString)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryString").build()}).build();
    private static final SdkField<ScheduleConfiguration> SCHEDULE_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ScheduleConfiguration").getter(CreateScheduledQueryRequest.getter(CreateScheduledQueryRequest::scheduleConfiguration)).setter(CreateScheduledQueryRequest.setter(Builder::scheduleConfiguration)).constructor(ScheduleConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScheduleConfiguration").build()}).build();
    private static final SdkField<NotificationConfiguration> NOTIFICATION_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("NotificationConfiguration").getter(CreateScheduledQueryRequest.getter(CreateScheduledQueryRequest::notificationConfiguration)).setter(CreateScheduledQueryRequest.setter(Builder::notificationConfiguration)).constructor(NotificationConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotificationConfiguration").build()}).build();
    private static final SdkField<TargetConfiguration> TARGET_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TargetConfiguration").getter(CreateScheduledQueryRequest.getter(CreateScheduledQueryRequest::targetConfiguration)).setter(CreateScheduledQueryRequest.setter(Builder::targetConfiguration)).constructor(TargetConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetConfiguration").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(CreateScheduledQueryRequest.getter(CreateScheduledQueryRequest::clientToken)).setter(CreateScheduledQueryRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> SCHEDULED_QUERY_EXECUTION_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ScheduledQueryExecutionRoleArn").getter(CreateScheduledQueryRequest.getter(CreateScheduledQueryRequest::scheduledQueryExecutionRoleArn)).setter(CreateScheduledQueryRequest.setter(Builder::scheduledQueryExecutionRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScheduledQueryExecutionRoleArn").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(CreateScheduledQueryRequest.getter(CreateScheduledQueryRequest::tags)).setter(CreateScheduledQueryRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KmsKeyId").getter(CreateScheduledQueryRequest.getter(CreateScheduledQueryRequest::kmsKeyId)).setter(CreateScheduledQueryRequest.setter(Builder::kmsKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()}).build();
    private static final SdkField<ErrorReportConfiguration> ERROR_REPORT_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ErrorReportConfiguration").getter(CreateScheduledQueryRequest.getter(CreateScheduledQueryRequest::errorReportConfiguration)).setter(CreateScheduledQueryRequest.setter(Builder::errorReportConfiguration)).constructor(ErrorReportConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorReportConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, QUERY_STRING_FIELD, SCHEDULE_CONFIGURATION_FIELD, NOTIFICATION_CONFIGURATION_FIELD, TARGET_CONFIGURATION_FIELD, CLIENT_TOKEN_FIELD, SCHEDULED_QUERY_EXECUTION_ROLE_ARN_FIELD, TAGS_FIELD, KMS_KEY_ID_FIELD, ERROR_REPORT_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateScheduledQueryRequest.memberNameToFieldInitializer();
    private final String name;
    private final String queryString;
    private final ScheduleConfiguration scheduleConfiguration;
    private final NotificationConfiguration notificationConfiguration;
    private final TargetConfiguration targetConfiguration;
    private final String clientToken;
    private final String scheduledQueryExecutionRoleArn;
    private final List<Tag> tags;
    private final String kmsKeyId;
    private final ErrorReportConfiguration errorReportConfiguration;

    private CreateScheduledQueryRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.queryString = builder.queryString;
        this.scheduleConfiguration = builder.scheduleConfiguration;
        this.notificationConfiguration = builder.notificationConfiguration;
        this.targetConfiguration = builder.targetConfiguration;
        this.clientToken = builder.clientToken;
        this.scheduledQueryExecutionRoleArn = builder.scheduledQueryExecutionRoleArn;
        this.tags = builder.tags;
        this.kmsKeyId = builder.kmsKeyId;
        this.errorReportConfiguration = builder.errorReportConfiguration;
    }

    public final String name() {
        return this.name;
    }

    public final String queryString() {
        return this.queryString;
    }

    public final ScheduleConfiguration scheduleConfiguration() {
        return this.scheduleConfiguration;
    }

    public final NotificationConfiguration notificationConfiguration() {
        return this.notificationConfiguration;
    }

    public final TargetConfiguration targetConfiguration() {
        return this.targetConfiguration;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final String scheduledQueryExecutionRoleArn() {
        return this.scheduledQueryExecutionRoleArn;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final String kmsKeyId() {
        return this.kmsKeyId;
    }

    public final ErrorReportConfiguration errorReportConfiguration() {
        return this.errorReportConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.queryString());
        hashCode = 31 * hashCode + Objects.hashCode(this.scheduleConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.notificationConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.scheduledQueryExecutionRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorReportConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateScheduledQueryRequest)) {
            return false;
        }
        CreateScheduledQueryRequest other = (CreateScheduledQueryRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.queryString(), other.queryString()) && Objects.equals(this.scheduleConfiguration(), other.scheduleConfiguration()) && Objects.equals(this.notificationConfiguration(), other.notificationConfiguration()) && Objects.equals(this.targetConfiguration(), other.targetConfiguration()) && Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.scheduledQueryExecutionRoleArn(), other.scheduledQueryExecutionRoleArn()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.kmsKeyId(), other.kmsKeyId()) && Objects.equals(this.errorReportConfiguration(), other.errorReportConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"CreateScheduledQueryRequest").add("Name", (Object)this.name()).add("QueryString", (Object)(this.queryString() == null ? null : "*** Sensitive Data Redacted ***")).add("ScheduleConfiguration", (Object)this.scheduleConfiguration()).add("NotificationConfiguration", (Object)this.notificationConfiguration()).add("TargetConfiguration", (Object)this.targetConfiguration()).add("ClientToken", (Object)(this.clientToken() == null ? null : "*** Sensitive Data Redacted ***")).add("ScheduledQueryExecutionRoleArn", (Object)this.scheduledQueryExecutionRoleArn()).add("Tags", this.hasTags() ? this.tags() : null).add("KmsKeyId", (Object)this.kmsKeyId()).add("ErrorReportConfiguration", (Object)this.errorReportConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "QueryString": {
                return Optional.ofNullable(clazz.cast(this.queryString()));
            }
            case "ScheduleConfiguration": {
                return Optional.ofNullable(clazz.cast(this.scheduleConfiguration()));
            }
            case "NotificationConfiguration": {
                return Optional.ofNullable(clazz.cast(this.notificationConfiguration()));
            }
            case "TargetConfiguration": {
                return Optional.ofNullable(clazz.cast(this.targetConfiguration()));
            }
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "ScheduledQueryExecutionRoleArn": {
                return Optional.ofNullable(clazz.cast(this.scheduledQueryExecutionRoleArn()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "KmsKeyId": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyId()));
            }
            case "ErrorReportConfiguration": {
                return Optional.ofNullable(clazz.cast(this.errorReportConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Name", NAME_FIELD);
        map.put("QueryString", QUERY_STRING_FIELD);
        map.put("ScheduleConfiguration", SCHEDULE_CONFIGURATION_FIELD);
        map.put("NotificationConfiguration", NOTIFICATION_CONFIGURATION_FIELD);
        map.put("TargetConfiguration", TARGET_CONFIGURATION_FIELD);
        map.put("ClientToken", CLIENT_TOKEN_FIELD);
        map.put("ScheduledQueryExecutionRoleArn", SCHEDULED_QUERY_EXECUTION_ROLE_ARN_FIELD);
        map.put("Tags", TAGS_FIELD);
        map.put("KmsKeyId", KMS_KEY_ID_FIELD);
        map.put("ErrorReportConfiguration", ERROR_REPORT_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateScheduledQueryRequest, T> g) {
        return obj -> g.apply((CreateScheduledQueryRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends TimestreamQueryRequest.BuilderImpl
    implements Builder {
        private String name;
        private String queryString;
        private ScheduleConfiguration scheduleConfiguration;
        private NotificationConfiguration notificationConfiguration;
        private TargetConfiguration targetConfiguration;
        private String clientToken;
        private String scheduledQueryExecutionRoleArn;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private String kmsKeyId;
        private ErrorReportConfiguration errorReportConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateScheduledQueryRequest model) {
            super(model);
            this.name(model.name);
            this.queryString(model.queryString);
            this.scheduleConfiguration(model.scheduleConfiguration);
            this.notificationConfiguration(model.notificationConfiguration);
            this.targetConfiguration(model.targetConfiguration);
            this.clientToken(model.clientToken);
            this.scheduledQueryExecutionRoleArn(model.scheduledQueryExecutionRoleArn);
            this.tags(model.tags);
            this.kmsKeyId(model.kmsKeyId);
            this.errorReportConfiguration(model.errorReportConfiguration);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getQueryString() {
            return this.queryString;
        }

        public final void setQueryString(String queryString) {
            this.queryString = queryString;
        }

        @Override
        public final Builder queryString(String queryString) {
            this.queryString = queryString;
            return this;
        }

        public final ScheduleConfiguration.Builder getScheduleConfiguration() {
            return this.scheduleConfiguration != null ? this.scheduleConfiguration.toBuilder() : null;
        }

        public final void setScheduleConfiguration(ScheduleConfiguration.BuilderImpl scheduleConfiguration) {
            this.scheduleConfiguration = scheduleConfiguration != null ? scheduleConfiguration.build() : null;
        }

        @Override
        public final Builder scheduleConfiguration(ScheduleConfiguration scheduleConfiguration) {
            this.scheduleConfiguration = scheduleConfiguration;
            return this;
        }

        public final NotificationConfiguration.Builder getNotificationConfiguration() {
            return this.notificationConfiguration != null ? this.notificationConfiguration.toBuilder() : null;
        }

        public final void setNotificationConfiguration(NotificationConfiguration.BuilderImpl notificationConfiguration) {
            this.notificationConfiguration = notificationConfiguration != null ? notificationConfiguration.build() : null;
        }

        @Override
        public final Builder notificationConfiguration(NotificationConfiguration notificationConfiguration) {
            this.notificationConfiguration = notificationConfiguration;
            return this;
        }

        public final TargetConfiguration.Builder getTargetConfiguration() {
            return this.targetConfiguration != null ? this.targetConfiguration.toBuilder() : null;
        }

        public final void setTargetConfiguration(TargetConfiguration.BuilderImpl targetConfiguration) {
            this.targetConfiguration = targetConfiguration != null ? targetConfiguration.build() : null;
        }

        @Override
        public final Builder targetConfiguration(TargetConfiguration targetConfiguration) {
            this.targetConfiguration = targetConfiguration;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getScheduledQueryExecutionRoleArn() {
            return this.scheduledQueryExecutionRoleArn;
        }

        public final void setScheduledQueryExecutionRoleArn(String scheduledQueryExecutionRoleArn) {
            this.scheduledQueryExecutionRoleArn = scheduledQueryExecutionRoleArn;
        }

        @Override
        public final Builder scheduledQueryExecutionRoleArn(String scheduledQueryExecutionRoleArn) {
            this.scheduledQueryExecutionRoleArn = scheduledQueryExecutionRoleArn;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getKmsKeyId() {
            return this.kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final ErrorReportConfiguration.Builder getErrorReportConfiguration() {
            return this.errorReportConfiguration != null ? this.errorReportConfiguration.toBuilder() : null;
        }

        public final void setErrorReportConfiguration(ErrorReportConfiguration.BuilderImpl errorReportConfiguration) {
            this.errorReportConfiguration = errorReportConfiguration != null ? errorReportConfiguration.build() : null;
        }

        @Override
        public final Builder errorReportConfiguration(ErrorReportConfiguration errorReportConfiguration) {
            this.errorReportConfiguration = errorReportConfiguration;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateScheduledQueryRequest build() {
            return new CreateScheduledQueryRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends TimestreamQueryRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateScheduledQueryRequest> {
        public Builder name(String var1);

        public Builder queryString(String var1);

        public Builder scheduleConfiguration(ScheduleConfiguration var1);

        default public Builder scheduleConfiguration(Consumer<ScheduleConfiguration.Builder> scheduleConfiguration) {
            return this.scheduleConfiguration((ScheduleConfiguration)((ScheduleConfiguration.Builder)ScheduleConfiguration.builder().applyMutation(scheduleConfiguration)).build());
        }

        public Builder notificationConfiguration(NotificationConfiguration var1);

        default public Builder notificationConfiguration(Consumer<NotificationConfiguration.Builder> notificationConfiguration) {
            return this.notificationConfiguration((NotificationConfiguration)((NotificationConfiguration.Builder)NotificationConfiguration.builder().applyMutation(notificationConfiguration)).build());
        }

        public Builder targetConfiguration(TargetConfiguration var1);

        default public Builder targetConfiguration(Consumer<TargetConfiguration.Builder> targetConfiguration) {
            return this.targetConfiguration((TargetConfiguration)((TargetConfiguration.Builder)TargetConfiguration.builder().applyMutation(targetConfiguration)).build());
        }

        public Builder clientToken(String var1);

        public Builder scheduledQueryExecutionRoleArn(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder kmsKeyId(String var1);

        public Builder errorReportConfiguration(ErrorReportConfiguration var1);

        default public Builder errorReportConfiguration(Consumer<ErrorReportConfiguration.Builder> errorReportConfiguration) {
            return this.errorReportConfiguration((ErrorReportConfiguration)((ErrorReportConfiguration.Builder)ErrorReportConfiguration.builder().applyMutation(errorReportConfiguration)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

