/*
 * Decompiled with CFR 0.152.
 */
package za.co.absa.cobrix.spark.cobol.replication;

import java.io.File;
import java.io.Serializable;
import java.util.Iterator;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.hadoop.conf.Configuration;
import org.apache.log4j.PropertyConfigurator;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;
import za.co.absa.cobrix.spark.cobol.replication.files.destination.generation.HDFSFileWriter;
import za.co.absa.cobrix.spark.cobol.replication.files.destination.identification.IncrementalFileIdProvider;

public final class CobolBinaryFilesReplicator$ {
    public static CobolBinaryFilesReplicator$ MODULE$;
    private final String PARAM_SOURCE_DIR;
    private final String PARAM_DESTINATION_DIR;
    private final String PARAM_MAX_SPACE_BYTES;
    private final String PARAM_MAX_PARALLEL_REPLICATORS;
    private final String PARAM_INITIAL_FILE_ID;

    static {
        new CobolBinaryFilesReplicator$();
    }

    private String PARAM_SOURCE_DIR() {
        return this.PARAM_SOURCE_DIR;
    }

    private String PARAM_DESTINATION_DIR() {
        return this.PARAM_DESTINATION_DIR;
    }

    private String PARAM_MAX_SPACE_BYTES() {
        return this.PARAM_MAX_SPACE_BYTES;
    }

    private String PARAM_MAX_PARALLEL_REPLICATORS() {
        return this.PARAM_MAX_PARALLEL_REPLICATORS;
    }

    private String PARAM_INITIAL_FILE_ID() {
        return this.PARAM_INITIAL_FILE_ID;
    }

    public void main(String[] args) {
        if (args.length != 5) {
            Predef$.MODULE$.println((Object)this.wrongParametersHelperMessage());
            System.exit(1);
        }
        PropertyConfigurator.configure((String)"log4j.properties");
        Map<String, String> params = this.parseArguments(args);
        String destDir = this.getDestinationDirectory(params);
        long maxAllowedSpaceBytes = this.getMaxAllowedSpaceBytes(params);
        IncrementalFileIdProvider idProvider = new IncrementalFileIdProvider(this.getInitialDestinationFileId(params));
        int maxParallelReplicators = this.getMaxParallelReplicators(params);
        File[] files = new File(this.getFilesSourceDirectory(params)).listFiles();
        Configuration conf = this.getConfiguration();
        int numWorkers = maxParallelReplicators < files.length ? maxParallelReplicators : files.length;
        Predef$.MODULE$.println((Object)new StringBuilder(55).append("[Cobol Binary Files Replicator] Destination directory: ").append(destDir).toString());
        Predef$.MODULE$.println((Object)new StringBuilder(55).append("[Cobol Binary Files Replicator] Maximum space allowed: ").append(maxAllowedSpaceBytes).toString());
        Predef$.MODULE$.println((Object)new StringBuilder(51).append("[Cobol Binary Files Replicator] Number of workers: ").append(numWorkers).toString());
        ExecutorService pool = Executors.newFixedThreadPool(numWorkers);
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), numWorkers).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)w -> pool.execute(new HDFSFileWriter(destDir, files, maxAllowedSpaceBytes / (long)numWorkers, conf, idProvider)));
        pool.shutdown();
    }

    private Map<String, String> parseArguments(String[] args) {
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])args)).map((Function1 & Serializable & scala.Serializable)param -> {
            String[] tokens = param.split("=");
            return new Tuple2((Object)tokens[0], (Object)tokens[1]);
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).toMap(Predef$.MODULE$.$conforms());
    }

    private String getDestinationDirectory(Map<String, String> params) {
        return (String)params.getOrElse((Object)this.PARAM_DESTINATION_DIR(), (Function0 & Serializable & scala.Serializable)() -> {
            throw new Exception(new StringBuilder(19).append("Missing parameter: ").append(MODULE$.PARAM_DESTINATION_DIR()).toString());
        });
    }

    private long getMaxAllowedSpaceBytes(Map<String, String> params) {
        return new StringOps(Predef$.MODULE$.augmentString((String)params.getOrElse((Object)this.PARAM_MAX_SPACE_BYTES(), (Function0 & Serializable & scala.Serializable)() -> {
            throw new Exception(new StringBuilder(19).append("Missing parameter: ").append(MODULE$.PARAM_MAX_SPACE_BYTES()).toString());
        }))).toLong();
    }

    private int getInitialDestinationFileId(Map<String, String> params) {
        return new StringOps(Predef$.MODULE$.augmentString((String)params.getOrElse((Object)this.PARAM_INITIAL_FILE_ID(), (Function0 & Serializable & scala.Serializable)() -> {
            throw new Exception(new StringBuilder(19).append("Missing parameter: ").append(MODULE$.PARAM_INITIAL_FILE_ID()).toString());
        }))).toInt();
    }

    private int getMaxParallelReplicators(Map<String, String> params) {
        return new StringOps(Predef$.MODULE$.augmentString((String)params.getOrElse((Object)this.PARAM_MAX_PARALLEL_REPLICATORS(), (Function0 & Serializable & scala.Serializable)() -> {
            throw new Exception(new StringBuilder(19).append("Missing parameter: ").append(MODULE$.PARAM_MAX_PARALLEL_REPLICATORS()).toString());
        }))).toInt();
    }

    private String getFilesSourceDirectory(Map<String, String> params) {
        return (String)params.getOrElse((Object)this.PARAM_SOURCE_DIR(), (Function0 & Serializable & scala.Serializable)() -> {
            throw new Exception("Missing parameter: PARAM_SOURCE_DIR");
        });
    }

    private String wrongParametersHelperMessage() {
        return new StringBuilder(171).append("Usage parameters: ").append(this.PARAM_SOURCE_DIR()).append("=dir_containing_files_to_replicate ").append(this.PARAM_DESTINATION_DIR()).append("=hdfs_destination_dir ").append(this.PARAM_MAX_SPACE_BYTES()).append("=maximum_allowed_space_in_bytes ").append(this.PARAM_MAX_PARALLEL_REPLICATORS()).append("=maximum_number_of_replication_threads ").append(this.PARAM_INITIAL_FILE_ID()).append("=first_replicated_file_id").toString();
    }

    private Configuration getConfiguration() {
        return new Configuration();
    }

    private void showConf(Configuration conf) {
        Iterator it = conf.iterator();
        while (it.hasNext()) {
            Predef$.MODULE$.println(it.next());
        }
    }

    private CobolBinaryFilesReplicator$() {
        MODULE$ = this;
        this.PARAM_SOURCE_DIR = "-DsourceDir";
        this.PARAM_DESTINATION_DIR = "-DdestinationDir";
        this.PARAM_MAX_SPACE_BYTES = "-DmaxSpaceBytes";
        this.PARAM_MAX_PARALLEL_REPLICATORS = "-DmaxParallelReplicators";
        this.PARAM_INITIAL_FILE_ID = "-DinitialFileId";
    }
}

