/*
 * Decompiled with CFR 0.152.
 */
package za.co.absa.cobrix.spark.cobol.replication.files.destination.generation;

import java.io.File;
import java.nio.file.Files;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import scala.Predef$;
import scala.reflect.ScalaSignature;
import za.co.absa.cobrix.spark.cobol.replication.files.destination.generation.HDFSFileWriter$;
import za.co.absa.cobrix.spark.cobol.replication.files.destination.identification.FileIdProvider;

@ScalaSignature(bytes="\u0006\u0001\u0005}u!\u0002\u0011\"\u0011\u00031d!\u0002\u001d\"\u0011\u0003I\u0004\"\u0002!\u0002\t\u0003\t\u0005b\u0002\"\u0002\u0005\u0004%Ia\u0011\u0005\u0007!\u0006\u0001\u000b\u0011\u0002#\u0007\ta\n\u0003!\u0015\u0005\t7\u0016\u0011\t\u0011)A\u00059\"Aa%\u0002B\u0001B\u0003%q\r\u0003\u0005q\u000b\t\u0005\t\u0015!\u0003r\u0011!!XA!A!\u0002\u0013)\bBCA\u0002\u000b\t\u0005\t\u0015!\u0003\u0002\u0006!1\u0001)\u0002C\u0001\u0003#A\u0011\"a\b\u0006\u0001\u0004%\t!!\t\t\u0013\u0005%R\u00011A\u0005\u0002\u0005-\u0002\u0002CA\u001c\u000b\u0001\u0006K!a\t\t\u0013\u0005eRA1A\u0005\u0004\u0005m\u0002\u0002CA%\u000b\u0001\u0006I!!\u0010\t\u0013\u0005-S\u00011A\u0005\n\u00055\u0003\"CA(\u000b\u0001\u0007I\u0011BA)\u0011\u001d\t)&\u0002Q!\nED\u0011\"a\u0016\u0006\u0001\u0004%I!!\t\t\u0013\u0005eS\u00011A\u0005\n\u0005m\u0003\u0002CA0\u000b\u0001\u0006K!a\t\t\u0013\u0005\u0005T\u00011A\u0005\n\u0005\u0005\u0002\"CA2\u000b\u0001\u0007I\u0011BA3\u0011!\tI'\u0002Q!\n\u0005\r\u0002bBA6\u000b\u0011\u0005\u0011Q\u000e\u0005\b\u0003_*A\u0011BA9\u0011\u001d\t9(\u0002C\u0005\u0003sBq!a \u0006\t\u0013\ti\u0007C\u0004\u0002\u0002\u0016!I!a!\t\u000f\u0005EU\u0001\"\u0003\u0002\u0014\u0006q\u0001\n\u0012$T\r&dWm\u0016:ji\u0016\u0014(B\u0001\u0012$\u0003)9WM\\3sCRLwN\u001c\u0006\u0003I\u0015\n1\u0002Z3ti&t\u0017\r^5p]*\u0011aeJ\u0001\u0006M&dWm\u001d\u0006\u0003Q%\n1B]3qY&\u001c\u0017\r^5p]*\u0011!fK\u0001\u0006G>\u0014w\u000e\u001c\u0006\u0003Y5\nQa\u001d9be.T!AL\u0018\u0002\r\r|'M]5y\u0015\t\u0001\u0014'\u0001\u0003bEN\f'B\u0001\u001a4\u0003\t\u0019wNC\u00015\u0003\tQ\u0018m\u0001\u0001\u0011\u0005]\nQ\"A\u0011\u0003\u001d!#ei\u0015$jY\u0016<&/\u001b;feN\u0011\u0011A\u000f\t\u0003wyj\u0011\u0001\u0010\u0006\u0002{\u0005)1oY1mC&\u0011q\b\u0010\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u00051\u0014!E<pe.,'/\u00133HK:,'/\u0019;peV\tA\t\u0005\u0002F\u001d6\taI\u0003\u0002H\u0011\u00061\u0011\r^8nS\u000eT!!\u0013&\u0002\u0015\r|gnY;se\u0016tGO\u0003\u0002L\u0019\u0006!Q\u000f^5m\u0015\u0005i\u0015\u0001\u00026bm\u0006L!a\u0014$\u0003\u001b\u0005#x.\\5d\u0013:$XmZ3s\u0003I9xN]6fe&#w)\u001a8fe\u0006$xN\u001d\u0011\u0014\u0007\u0015\u0011\u0006\f\u0005\u0002T-6\tAK\u0003\u0002V\u0019\u0006!A.\u00198h\u0013\t9FK\u0001\u0004PE*,7\r\u001e\t\u0003'fK!A\u0017+\u0003\u0011I+hN\\1cY\u0016\fq\u0001Z3ti\u0012K'\u000f\u0005\u0002^I:\u0011aL\u0019\t\u0003?rj\u0011\u0001\u0019\u0006\u0003CV\na\u0001\u0010:p_Rt\u0014BA2=\u0003\u0019\u0001&/\u001a3fM&\u0011QM\u001a\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005\rd\u0004cA\u001eiU&\u0011\u0011\u000e\u0010\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0003W:l\u0011\u0001\u001c\u0006\u0003[2\u000b!![8\n\u0005=d'\u0001\u0002$jY\u0016\fA\"\\1y'&TXMQ=uKN\u0004\"a\u000f:\n\u0005Md$\u0001\u0002'p]\u001e\f\u0001\u0002\u001b3gg\u000e{gN\u001a\t\u0003m~l\u0011a\u001e\u0006\u0003qf\fAaY8oM*\u0011!p_\u0001\u0007Q\u0006$wn\u001c9\u000b\u0005ql\u0018AB1qC\u000eDWMC\u0001\u007f\u0003\ry'oZ\u0005\u0004\u0003\u00039(!D\"p]\u001aLw-\u001e:bi&|g.\u0001\u0006jIB\u0013xN^5eKJ\u0004B!a\u0002\u0002\u000e5\u0011\u0011\u0011\u0002\u0006\u0004\u0003\u0017\u0019\u0013AD5eK:$\u0018NZ5dCRLwN\\\u0005\u0005\u0003\u001f\tIA\u0001\bGS2,\u0017\n\u001a)s_ZLG-\u001a:\u0015\u0019\u0005M\u0011QCA\f\u00033\tY\"!\b\u0011\u0005]*\u0001\"B.\f\u0001\u0004a\u0006\"\u0002\u0014\f\u0001\u00049\u0007\"\u00029\f\u0001\u0004\t\b\"\u0002;\f\u0001\u0004)\bbBA\u0002\u0017\u0001\u0007\u0011QA\u0001\to>\u00148.\u001a:JIV\u0011\u00111\u0005\t\u0004w\u0005\u0015\u0012bAA\u0014y\t\u0019\u0011J\u001c;\u0002\u0019]|'o[3s\u0013\u0012|F%Z9\u0015\t\u00055\u00121\u0007\t\u0004w\u0005=\u0012bAA\u0019y\t!QK\\5u\u0011%\t)$DA\u0001\u0002\u0004\t\u0019#A\u0002yIE\n\u0011b^8sW\u0016\u0014\u0018\n\u001a\u0011\u0002\t!$gm]\u000b\u0003\u0003{\u0001B!a\u0010\u0002F5\u0011\u0011\u0011\t\u0006\u0004\u0003\u0007J\u0018A\u00014t\u0013\u0011\t9%!\u0011\u0003\u0015\u0019KG.Z*zgR,W.A\u0003iI\u001a\u001c\b%A\tu_R\fGNQ=uKN<&/\u001b;uK:,\u0012!]\u0001\u0016i>$\u0018\r\u001c\"zi\u0016\u001cxK]5ui\u0016tw\fJ3r)\u0011\ti#a\u0015\t\u0011\u0005U\"#!AA\u0002E\f!\u0003^8uC2\u0014\u0015\u0010^3t/JLG\u000f^3oA\u0005Ya-\u001b7f!>Lg\u000e^3s\u0003=1\u0017\u000e\\3Q_&tG/\u001a:`I\u0015\fH\u0003BA\u0017\u0003;B\u0011\"!\u000e\u0016\u0003\u0003\u0005\r!a\t\u0002\u0019\u0019LG.\u001a)pS:$XM\u001d\u0011\u0002\u000fA|\u0017N\u001c;fe\u0006Y\u0001o\\5oi\u0016\u0014x\fJ3r)\u0011\ti#a\u001a\t\u0013\u0005U\u0002$!AA\u0002\u0005\r\u0012\u0001\u00039pS:$XM\u001d\u0011\u0002\u0007I,h\u000e\u0006\u0002\u0002.\u0005yq-\u001a;OKb$h)\u001b7f!\u0006$\b\u000e\u0006\u0002\u0002tA\u00191+!\u001e\n\u0005\u0015$\u0016AE;qI\u0006$XMQ=uKN<&/\u001b;uK:$B!!\f\u0002|!1\u0011Q\u0010\u000fA\u0002E\f1\u0002\\1ti^\u0013\u0018\u000e\u001e;f]\u0006\tR\u000f\u001d3bi\u00164\u0015\u000e\\3Q_&tG/\u001a:\u0002\u000b]\u0014\u0018\u000e^3\u0015\r\u0005\u0015\u0015\u0011RAG)\r\t\u0018q\u0011\u0005\b\u0003sq\u00029AA\u001f\u0011\u0019\tYI\ba\u0001U\u0006!a-\u001b7f\u0011\u0019\tyI\ba\u00019\u0006AA-Z:u\u001d\u0006lW-A\u0004u_\nKH/Z:\u0015\t\u0005U\u0015Q\u0014\t\u0005w!\f9\nE\u0002<\u00033K1!a'=\u0005\u0011\u0011\u0015\u0010^3\t\r\u0005-u\u00041\u0001k\u0001")
public class HDFSFileWriter
implements Runnable {
    private final String destDir;
    private final File[] files;
    private final long maxSizeBytes;
    private final FileIdProvider idProvider;
    private int workerId;
    private final FileSystem hdfs;
    private long totalBytesWritten;
    private int filePointer;
    private int pointer;

    public int workerId() {
        return this.workerId;
    }

    public void workerId_$eq(int x$1) {
        this.workerId = x$1;
    }

    public FileSystem hdfs() {
        return this.hdfs;
    }

    private long totalBytesWritten() {
        return this.totalBytesWritten;
    }

    private void totalBytesWritten_$eq(long x$1) {
        this.totalBytesWritten = x$1;
    }

    private int filePointer() {
        return this.filePointer;
    }

    private void filePointer_$eq(int x$1) {
        this.filePointer = x$1;
    }

    private int pointer() {
        return this.pointer;
    }

    private void pointer_$eq(int x$1) {
        this.pointer = x$1;
    }

    @Override
    public void run() {
        while (this.totalBytesWritten() < this.maxSizeBytes) {
            String nextFilePath = this.getNextFilePath();
            long lastWritten = this.write(this.files[this.pointer()], nextFilePath, this.hdfs());
            if (lastWritten == 0L) {
                return;
            }
            this.updateBytesWritten(lastWritten);
            this.updateFilePointer();
            Predef$.MODULE$.println((Object)new StringBuilder(40).append("[Worker ").append(this.workerId()).append("]: wrote file: ").append(nextFilePath).append(" (total bytes = ").append(this.totalBytesWritten()).append(")").toString());
        }
    }

    private String getNextFilePath() {
        return new StringBuilder(9).append(this.destDir).append("/part").append(this.idProvider.getNextId()).append(".bin").toString();
    }

    private void updateBytesWritten(long lastWritten) {
        this.totalBytesWritten_$eq(this.totalBytesWritten() + lastWritten);
    }

    private void updateFilePointer() {
        block0: {
            this.pointer_$eq(this.pointer() + 1);
            if (this.pointer() != this.files.length) break block0;
            this.pointer_$eq(0);
        }
    }

    private long write(File file, String destName, FileSystem hdfs) {
        long l;
        try {
            FSDataOutputStream outstream = hdfs.create(new Path(destName), true);
            outstream.write(this.toBytes(file));
            outstream.flush();
            outstream.close();
            l = file.length();
        }
        catch (Exception e) {
            Predef$.MODULE$.println((Object)new StringBuilder(20).append("Error writing ").append(file.getAbsolutePath()).append(" to ").append(destName).append(": ").append(e.getMessage()).toString());
            e.printStackTrace();
            l = 0L;
        }
        return l;
    }

    private byte[] toBytes(File file) {
        return Files.readAllBytes(file.toPath());
    }

    public HDFSFileWriter(String destDir, File[] files, long maxSizeBytes, Configuration hdfsConf, FileIdProvider idProvider) {
        this.destDir = destDir;
        this.files = files;
        this.maxSizeBytes = maxSizeBytes;
        this.idProvider = idProvider;
        this.workerId = HDFSFileWriter$.MODULE$.za$co$absa$cobrix$spark$cobol$replication$files$destination$generation$HDFSFileWriter$$workerIdGenerator().incrementAndGet();
        this.hdfs = FileSystem.get((Configuration)hdfsConf);
        this.totalBytesWritten = 0L;
        this.filePointer = 0;
        this.pointer = 0;
    }
}

