/*
 * Decompiled with CFR 0.152.
 */
package za.co.absa.cobrix.spark.cobol.source.parameters;

import java.io.FileNotFoundException;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.SparkConf;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.mutable.ArrayOps;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import za.co.absa.cobrix.cobol.reader.parameters.CobolParameters;
import za.co.absa.cobrix.spark.cobol.parameters.CobolParametersParser$;
import za.co.absa.cobrix.spark.cobol.utils.FileNameUtils$;

public final class CobolParametersValidator$ {
    public static CobolParametersValidator$ MODULE$;

    static {
        new CobolParametersValidator$();
    }

    public void checkSanity(CobolParameters params) {
        if (params.sourcePaths().isEmpty()) {
            throw new IllegalArgumentException("Data source path must be specified.");
        }
        if (params.copybookPath().isEmpty() && params.copybookContent().isEmpty() && params.multiCopybookPath().isEmpty()) {
            throw new IllegalArgumentException("Either, copybook path or copybook content must be specified.");
        }
    }

    public void validateOrThrow(SparkConf sparkConf, Configuration hadoopConf) {
        Map parameters = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)CobolParametersParser$.MODULE$.PARAM_COPYBOOK_PATH()), (Object)sparkConf.get(CobolParametersParser$.MODULE$.PARAM_COPYBOOK_PATH())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)CobolParametersParser$.MODULE$.PARAM_SOURCE_PATH()), (Object)sparkConf.get(CobolParametersParser$.MODULE$.PARAM_SOURCE_PATH()))}));
        this.validateOrThrow((Map<String, String>)parameters, hadoopConf);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void validateOrThrow(Map<String, String> parameters, Configuration hadoopConf) {
        Option copyBookContents = parameters.get((Object)CobolParametersParser$.MODULE$.PARAM_COPYBOOK_CONTENTS());
        Option copyBookPathFileName = parameters.get((Object)CobolParametersParser$.MODULE$.PARAM_COPYBOOK_PATH());
        Option copyBookMultiPathFileNames = parameters.get((Object)CobolParametersParser$.MODULE$.PARAM_MULTI_COPYBOOK_PATH());
        if (!parameters.isDefinedAt((Object)CobolParametersParser$.MODULE$.PARAM_SOURCE_PATH()) && !parameters.isDefinedAt((Object)CobolParametersParser$.MODULE$.PARAM_SOURCE_PATHS())) {
            throw new IllegalStateException(new StringBuilder(110).append("Cannot define path to data files: missing ").append("parameter: '").append(CobolParametersParser$.MODULE$.PARAM_SOURCE_PATH()).append("' or '").append(CobolParametersParser$.MODULE$.PARAM_SOURCE_PATHS()).append("'. It is automatically set when you invoke .load()").toString());
        }
        if (parameters.isDefinedAt((Object)CobolParametersParser$.MODULE$.PARAM_SOURCE_PATH()) && parameters.isDefinedAt((Object)CobolParametersParser$.MODULE$.PARAM_SOURCE_PATHS())) {
            throw new IllegalStateException(new StringBuilder(39).append("Only one of '").append(CobolParametersParser$.MODULE$.PARAM_SOURCE_PATH()).append("' or '").append(CobolParametersParser$.MODULE$.PARAM_SOURCE_PATHS()).append("' should be defined.").toString());
        }
        Tuple3 tuple3 = new Tuple3((Object)copyBookContents, (Object)copyBookPathFileName, (Object)copyBookMultiPathFileNames);
        if (tuple3 != null) {
            Option option = (Option)tuple3._1();
            Option option2 = (Option)tuple3._2();
            if (option instanceof Some && option2 instanceof Some) {
                throw new IllegalStateException(new StringBuilder(59).append("Both '").append(CobolParametersParser$.MODULE$.PARAM_COPYBOOK_PATH()).append("' and '").append(CobolParametersParser$.MODULE$.PARAM_COPYBOOK_CONTENTS()).append("' options cannot be specified at the same time").toString());
            }
        }
        if (tuple3 != null) {
            Option option = (Option)tuple3._1();
            Option option3 = (Option)tuple3._3();
            if (option instanceof Some && option3 instanceof Some) {
                throw new IllegalStateException(new StringBuilder(59).append("Both '").append(CobolParametersParser$.MODULE$.PARAM_MULTI_COPYBOOK_PATH()).append("' and '").append(CobolParametersParser$.MODULE$.PARAM_COPYBOOK_CONTENTS()).append("' options cannot be specified at the same time").toString());
            }
        }
        if (tuple3 != null) {
            Option option = (Option)tuple3._2();
            Option option4 = (Option)tuple3._3();
            if (option instanceof Some && option4 instanceof Some) {
                throw new IllegalStateException(new StringBuilder(59).append("Both '").append(CobolParametersParser$.MODULE$.PARAM_COPYBOOK_PATH()).append("' and '").append(CobolParametersParser$.MODULE$.PARAM_MULTI_COPYBOOK_PATH()).append("' options cannot be specified at the same time").toString());
            }
        }
        if (tuple3 != null) {
            Option option = (Option)tuple3._1();
            Option option5 = (Option)tuple3._2();
            Option option6 = (Option)tuple3._3();
            if (None$.MODULE$.equals(option) && None$.MODULE$.equals(option5) && None$.MODULE$.equals(option6)) {
                throw new IllegalStateException(new StringBuilder(73).append("COPYBOOK is not provided. Please, provide one of the options: ").append("'").append(CobolParametersParser$.MODULE$.PARAM_COPYBOOK_PATH()).append("', '").append(CobolParametersParser$.MODULE$.PARAM_COPYBOOK_CONTENTS()).append("', '").append(CobolParametersParser$.MODULE$.PARAM_MULTI_COPYBOOK_PATH()).append("'.").toString());
            }
        }
        if (tuple3 != null) {
            Option option = (Option)tuple3._1();
            Option option7 = (Option)tuple3._2();
            Option option8 = (Option)tuple3._3();
            if (option instanceof Some && None$.MODULE$.equals(option7) && None$.MODULE$.equals(option8)) {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            }
        }
        if (tuple3 != null) {
            Option option = (Option)tuple3._1();
            Option option9 = (Option)tuple3._2();
            Option option10 = (Option)tuple3._3();
            if (None$.MODULE$.equals(option) && option9 instanceof Some) {
                Some some = (Some)option9;
                String fileName2 = (String)some.value();
                if (None$.MODULE$.equals(option10)) {
                    CobolParametersValidator$.validatePath$1(fileName2, hadoopConf);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
            }
        }
        if (tuple3 == null) throw new MatchError((Object)tuple3);
        Option option = (Option)tuple3._1();
        Option option11 = (Option)tuple3._2();
        Option option12 = (Option)tuple3._3();
        if (!None$.MODULE$.equals(option)) throw new MatchError((Object)tuple3);
        if (!None$.MODULE$.equals(option11)) throw new MatchError((Object)tuple3);
        if (!(option12 instanceof Some)) throw new MatchError((Object)tuple3);
        Some some = (Some)option12;
        String fileNames = (String)some.value();
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fileNames.split(","))).foreach((Function1 & Serializable & scala.Serializable)fileName -> {
            CobolParametersValidator$.validatePath$1(fileName, hadoopConf);
            return BoxedUnit.UNIT;
        });
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private static final void validatePath$1(String fileName, Configuration hadoopConf$1) {
        Tuple2<Object, String> tuple2 = FileNameUtils$.MODULE$.getCopyBookFileName(fileName);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        boolean isLocalFS = tuple2._1$mcZ$sp();
        String copyBookFileName = (String)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)isLocalFS), (Object)copyBookFileName);
        Tuple2 tuple23 = tuple22;
        boolean isLocalFS2 = tuple23._1$mcZ$sp();
        String copyBookFileName2 = (String)tuple23._2();
        if (isLocalFS2) {
            if (!Files.exists(Paths.get(copyBookFileName2, new String[0]), new LinkOption[0])) {
                throw new FileNotFoundException(new StringBuilder(22).append("Copybook not found at ").append(copyBookFileName2).toString());
            }
            if (!Files.isRegularFile(Paths.get(copyBookFileName2, new String[0]), new LinkOption[0])) {
                throw new IllegalArgumentException(new StringBuilder(35).append("The copybook path '").append(copyBookFileName2).append("' is not a file.").toString());
            }
            if (!Files.isReadable(Paths.get(copyBookFileName2, new String[0]))) {
                throw new IllegalArgumentException(new StringBuilder(37).append("The copybook path '").append(copyBookFileName2).append("' is not readable.").toString());
            }
        } else {
            FileSystem fs = new Path(fileName).getFileSystem(hadoopConf$1);
            if (!fs.exists(new Path(copyBookFileName2))) {
                throw new FileNotFoundException(new StringBuilder(22).append("Copybook not found at ").append(copyBookFileName2).toString());
            }
            if (!fs.isFile(new Path(copyBookFileName2))) {
                throw new IllegalArgumentException(new StringBuilder(35).append("The copybook path '").append(copyBookFileName2).append("' is not a file.").toString());
            }
        }
    }

    private CobolParametersValidator$() {
        MODULE$ = this;
    }
}

