/*
 * Decompiled with CFR 0.152.
 */
package za.co.absa.cobrix.spark.cobol.utils;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.Serializable;
import org.apache.spark.SparkContext;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.Predef$;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.ListBuffer;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class SparkUtils$ {
    public static SparkUtils$ MODULE$;
    private final Logger logger;

    static {
        new SparkUtils$();
    }

    private Logger logger() {
        return this.logger;
    }

    public Seq<String> currentActiveExecutors(SparkContext sc) {
        Iterable allExecutors = (Iterable)sc.getExecutorMemoryStatus().map((Function1 & Serializable & scala.Serializable)x$1 -> (String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])((String)x$1._1()).split(":"))).head(), Iterable$.MODULE$.canBuildFrom());
        String driverHost = sc.getConf().get("spark.driver.host", "localhost");
        this.logger().info(new StringBuilder(85).append("Going to filter driver from available executors: Driver host: ").append(driverHost).append(", Available executors: ").append(allExecutors).toString());
        return (Seq)((TraversableOnce)allExecutors.filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)SparkUtils$.$anonfun$currentActiveExecutors$2(driverHost, x$2)))).toList().distinct();
    }

    public Dataset<Row> flattenSchema(Dataset<Row> df, boolean useShortFieldNames) {
        ListBuffer fields = new ListBuffer();
        ListBuffer stringFields = new ListBuffer();
        HashSet usedNames = new HashSet();
        SparkUtils$.flattenGroup$1("", "", df.schema(), useShortFieldNames, fields, stringFields, df, usedNames);
        this.logger().info(stringFields.mkString("Flattening code: \n.select(\n", ",\n", "\n)"));
        return df.select((Seq)fields);
    }

    public boolean flattenSchema$default$2() {
        return false;
    }

    public Dataset<Row> convertDataframeFieldsToStrings(Dataset<Row> df) {
        ListBuffer fields = new ListBuffer();
        SparkUtils$.convertToStrings$1("", df.schema(), fields);
        return df.select((Seq)fields);
    }

    public String convertDataFrameToPrettyJSON(Dataset<Row> df, int takeN) {
        String collected = takeN <= 0 ? new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])df.toJSON().collect())).mkString("\n") : new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])df.toJSON().take(takeN))).mkString("\n");
        String json = new StringBuilder(2).append("[").append(new StringOps(Predef$.MODULE$.augmentString("}\n")).r().replaceAllIn((CharSequence)collected, "},\n")).append("]").toString();
        return this.prettyJSON(json);
    }

    public int convertDataFrameToPrettyJSON$default$2() {
        return 0;
    }

    public String prettyJSON(String jsonIn) {
        ObjectMapper mapper = new ObjectMapper();
        Object jsonUnindented = mapper.readValue(jsonIn, Object.class);
        String indented = mapper.writerWithDefaultPrettyPrinter().writeValueAsString(jsonUnindented);
        return indented.replace("\r\n", "\n");
    }

    public static final /* synthetic */ boolean $anonfun$currentActiveExecutors$2(String driverHost$1, String x$2) {
        return !x$2.equals(driverHost$1);
    }

    /*
     * WARNING - void declaration
     */
    private static final String getNewFieldName$1(String desiredName, HashSet usedNames$1) {
        void var2_2;
        String name = desiredName;
        int i = 1;
        while (usedNames$1.contains((Object)name)) {
            name = new StringBuilder(0).append(desiredName).append(i).toString();
            ++i;
        }
        usedNames$1.add((Object)name);
        return var2_2;
    }

    private static final void flattenStructArray$1(String path, String fieldNamePrefix, StructField structField, ArrayType arrayType, Dataset df$1, ListBuffer fields$1, ListBuffer stringFields$1, boolean useShortFieldNames$1, HashSet usedNames$1) {
        int maxInd = new StringOps(Predef$.MODULE$.augmentString(((Row[])df$1.agg(functions$.MODULE$.max(functions$.MODULE$.expr(new StringBuilder(6).append("size(").append(path).append(structField.name()).append(")").toString())), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[0])).collect())[0].apply(0).toString())).toInt();
        for (int i = 0; i < maxInd; ++i) {
            BoxedUnit boxedUnit;
            DataType dataType = arrayType.elementType();
            if (dataType instanceof StructType) {
                StructType structType = (StructType)dataType;
                String newFieldNamePrefix = new StringBuilder(1).append(fieldNamePrefix).append(i).append("_").toString();
                SparkUtils$.flattenGroup$1(new StringBuilder(5).append(path).append("`").append(structField.name()).append("`[").append(i).append("].").toString(), newFieldNamePrefix, structType, useShortFieldNames$1, fields$1, stringFields$1, df$1, usedNames$1);
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            if (dataType instanceof ArrayType) {
                ArrayType arrayType2 = (ArrayType)dataType;
                String newFieldNamePrefix = new StringBuilder(1).append(fieldNamePrefix).append(i).append("_").toString();
                SparkUtils$.flattenArray$1(new StringBuilder(5).append(path).append("`").append(structField.name()).append("`[").append(i).append("].").toString(), newFieldNamePrefix, structField, arrayType2, df$1, fields$1, stringFields$1, useShortFieldNames$1, usedNames$1);
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            String newFieldNamePrefix = new StringBuilder(0).append(fieldNamePrefix).append(i).toString();
            String newFieldName = SparkUtils$.getNewFieldName$1(String.valueOf(newFieldNamePrefix), usedNames$1);
            fields$1.$plus$eq((Object)functions$.MODULE$.expr(new StringBuilder(4).append(path).append("`").append(structField.name()).append("`[").append(i).append("]").toString()).as(newFieldName));
            boxedUnit = stringFields$1.$plus$eq((Object)new StringBuilder(18).append("expr(\"").append(path).append("`").append(structField.name()).append("`[").append(i).append("] AS `").append(newFieldName).append("`\")").toString());
        }
    }

    private static final void flattenNestedArrays$1(String path, String fieldNamePrefix, ArrayType arrayType, Dataset df$1, ListBuffer fields$1, ListBuffer stringFields$1, boolean useShortFieldNames$1, HashSet usedNames$1) {
        int maxInd = new StringOps(Predef$.MODULE$.augmentString(((Row[])df$1.agg(functions$.MODULE$.max(functions$.MODULE$.expr(new StringBuilder(6).append("size(").append(path).append(")").toString())), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[0])).collect())[0].apply(0).toString())).toInt();
        for (int i = 0; i < maxInd; ++i) {
            BoxedUnit boxedUnit;
            DataType dataType = arrayType.elementType();
            if (dataType instanceof StructType) {
                StructType structType = (StructType)dataType;
                String newFieldNamePrefix = new StringBuilder(1).append(fieldNamePrefix).append(i).append("_").toString();
                SparkUtils$.flattenGroup$1(new StringBuilder(2).append(path).append("[").append(i).append("]").toString(), newFieldNamePrefix, structType, useShortFieldNames$1, fields$1, stringFields$1, df$1, usedNames$1);
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            if (dataType instanceof ArrayType) {
                ArrayType arrayType2 = (ArrayType)dataType;
                String newFieldNamePrefix = new StringBuilder(1).append(fieldNamePrefix).append(i).append("_").toString();
                SparkUtils$.flattenNestedArrays$1(new StringBuilder(2).append(path).append("[").append(i).append("]").toString(), newFieldNamePrefix, arrayType2, df$1, fields$1, stringFields$1, useShortFieldNames$1, usedNames$1);
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            String newFieldNamePrefix = new StringBuilder(0).append(fieldNamePrefix).append(i).toString();
            String newFieldName = SparkUtils$.getNewFieldName$1(String.valueOf(newFieldNamePrefix), usedNames$1);
            fields$1.$plus$eq((Object)functions$.MODULE$.expr(new StringBuilder(2).append(path).append("[").append(i).append("]").toString()).as(newFieldName));
            boxedUnit = stringFields$1.$plus$eq((Object)new StringBuilder(17).append("expr(\"").append(path).append("`[").append(i).append("] AS `").append(newFieldName).append("`\")").toString());
        }
    }

    private static final void flattenArray$1(String path, String fieldNamePrefix, StructField structField, ArrayType arrayType, Dataset df$1, ListBuffer fields$1, ListBuffer stringFields$1, boolean useShortFieldNames$1, HashSet usedNames$1) {
        DataType dataType = arrayType.elementType();
        if (dataType instanceof ArrayType) {
            SparkUtils$.flattenNestedArrays$1(new StringBuilder(0).append(path).append(structField.name()).toString(), fieldNamePrefix, arrayType, df$1, fields$1, stringFields$1, useShortFieldNames$1, usedNames$1);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            SparkUtils$.flattenStructArray$1(path, fieldNamePrefix, structField, arrayType, df$1, fields$1, stringFields$1, useShortFieldNames$1, usedNames$1);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    private static final void flattenGroup$1(String path, String fieldNamePrefix, StructType structField, boolean useShortFieldNames$1, ListBuffer fields$1, ListBuffer stringFields$1, Dataset df$1, HashSet usedNames$1) {
        structField.foreach((Function1 & Serializable & scala.Serializable)field -> {
            BoxedUnit boxedUnit;
            String newFieldNamePrefix = useShortFieldNames$1 ? new StringBuilder(1).append(field.name()).append("_").toString() : new StringBuilder(1).append(fieldNamePrefix).append(field.name()).append("_").toString();
            DataType dataType = field.dataType();
            if (dataType instanceof StructType) {
                StructType structType = (StructType)dataType;
                SparkUtils$.flattenGroup$1(new StringBuilder(3).append(path).append("`").append(field.name()).append("`.").toString(), newFieldNamePrefix, structType, useShortFieldNames$1, fields$1, stringFields$1, df$1, usedNames$1);
                boxedUnit = BoxedUnit.UNIT;
            } else if (dataType instanceof ArrayType) {
                ArrayType arrayType = (ArrayType)dataType;
                SparkUtils$.flattenArray$1(path, newFieldNamePrefix, field, arrayType, df$1, fields$1, stringFields$1, useShortFieldNames$1, usedNames$1);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                String newFieldName = SparkUtils$.getNewFieldName$1(new StringBuilder(0).append(fieldNamePrefix).append(field.name()).toString(), usedNames$1);
                fields$1.$plus$eq((Object)functions$.MODULE$.expr(new StringBuilder(2).append(path).append("`").append(field.name()).append("`").toString()).as(newFieldName));
                boxedUnit = new StringOps(Predef$.MODULE$.augmentString(path)).contains((Object)BoxesRunTime.boxToCharacter((char)'[')) ? stringFields$1.$plus$eq((Object)new StringBuilder(16).append("expr(\"").append(path).append("`").append(field.name()).append("` AS `").append(newFieldName).append("`\")").toString()) : stringFields$1.$plus$eq((Object)new StringBuilder(16).append("col(\"").append(path).append("`").append(field.name()).append("`\").as(\"").append(newFieldName).append("\")").toString());
            }
            return boxedUnit;
        });
    }

    private static final void convertArrayToStrings$1(String path, StructField structField, ArrayType arrayType, ListBuffer fields$2) {
        DataType dataType = arrayType.elementType();
        if (dataType instanceof StructType) {
            fields$2.$plus$eq((Object)functions$.MODULE$.expr(new StringBuilder(2).append(path).append("`").append(structField.name()).append("`").toString()));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            fields$2.$plus$eq((Object)functions$.MODULE$.expr(new StringBuilder(2).append(path).append("`").append(structField.name()).append("`").toString()).cast((DataType)ArrayType$.MODULE$.apply((DataType)StringType$.MODULE$)));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    private static final void convertToStrings$1(String path, StructType structField, ListBuffer fields$2) {
        structField.foreach((Function1 & Serializable & scala.Serializable)field -> {
            BoxedUnit boxedUnit;
            DataType dataType = field.dataType();
            if (dataType instanceof StructType) {
                StructType structType = (StructType)dataType;
                SparkUtils$.convertToStrings$1(new StringBuilder(3).append(path).append("`").append(field.name()).append("`.").toString(), structType, fields$2);
                boxedUnit = BoxedUnit.UNIT;
            } else if (dataType instanceof ArrayType) {
                ArrayType arrayType = (ArrayType)dataType;
                SparkUtils$.convertArrayToStrings$1(path, field, arrayType, fields$2);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = fields$2.$plus$eq((Object)functions$.MODULE$.expr(new StringBuilder(2).append(path).append("`").append(field.name()).append("`").toString()).cast((DataType)StringType$.MODULE$));
            }
            return boxedUnit;
        });
    }

    private SparkUtils$() {
        MODULE$ = this;
        this.logger = LoggerFactory.getLogger(this.getClass());
    }
}

