/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.ext.spring.config;

import javax.annotation.Nonnull;
import net.shibboleth.utilities.java.support.component.AbstractIdentifiableInitializableComponent;
import net.shibboleth.utilities.java.support.component.AbstractIdentifiedInitializableComponent;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.IdentifiedComponent;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.testng.AbstractTestNGSpringContextTests;
import org.testng.Assert;
import org.testng.annotations.Test;

@ContextConfiguration(value={"identifiableBeanPostProcessorTest.xml"})
public class IdentifiableBeanPostProcessorTest
extends AbstractTestNGSpringContextTests {
    @Test(expectedExceptions={ComponentInitializationException.class, BeanCreationException.class})
    public void defaultedIdentified() {
        this.applicationContext.getBean("IdentifiedBean");
    }

    @Test
    public void defaultedIdentifiable() {
        IdentifiedComponent bean = (IdentifiedComponent)this.applicationContext.getBean("IdentifiableBean", Identifiable.class);
        Assert.assertEquals((String)bean.getId(), (String)"IdentifiableBean");
    }

    @Test
    public void nonDefaultedIdentified() {
        IdentifiedComponent bean = (IdentifiedComponent)this.applicationContext.getBean("NonDefaultIdentifiedBean", Identified.class);
        Assert.assertEquals((String)bean.getId(), (String)"NameForAnIdentifiedBean");
    }

    @Test
    public void nonDefaultedIdentifiable() {
        IdentifiedComponent bean = (IdentifiedComponent)this.applicationContext.getBean("NonDefaultIdentifiableBean", Identifiable.class);
        Assert.assertEquals((String)bean.getId(), (String)"NameForAnIdentifiableBean");
    }

    @Test
    public void TautologousTest() {
        IdentifiedComponent bean = (IdentifiedComponent)this.applicationContext.getBean("TautologousName", Identifiable.class);
        Assert.assertEquals((String)bean.getId(), (String)"TautologousName");
    }

    @Test
    public void testSingleton() {
        IdentifiedComponent bean = (IdentifiedComponent)this.applicationContext.getBean("SingletonIdentifiableBean", Identifiable.class);
        Assert.assertEquals((String)bean.getId(), (String)"SingletonIdentifiableBean");
    }

    @Test
    public void testNonDefaultSingleton() {
        IdentifiedComponent bean = (IdentifiedComponent)this.applicationContext.getBean("NonDefaultSingletonIdentifiableBean", Identifiable.class);
        Assert.assertEquals((String)bean.getId(), (String)"NameForNonDefaultSingletonIdentifiableBean");
    }

    public static class Identifiable
    extends AbstractIdentifiableInitializableComponent {
    }

    public static class Identified
    extends AbstractIdentifiedInitializableComponent {
        public void setId(@Nonnull String componentId) {
            super.setId(componentId);
        }
    }
}

